/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.LinuxFile;
import lcmc.data.VMSXML;
import lcmc.data.resources.Resource;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import lcmc.utilities.Unit;
import lcmc.utilities.UpdatableItem;
import org.w3c.dom.Node;

public abstract class VMSHardwareInfo
extends EditableInfo {
    private JComponent infoPanel = null;
    private final VMSVirtualDomainInfo vmsVirtualDomainInfo;
    private static final ImageIcon BACK_ICON = Tools.createImageIcon(Tools.getDefault("BackIcon"));
    private static final Map<String, String> DEFAULT_UNIT = new HashMap<String, String>();
    private static final Map<String, Boolean> HAS_UNIT = new HashMap<String, Boolean>();
    private final Map<String, LinuxFile> linuxFileCache = new HashMap<String, LinuxFile>();
    private static final Pattern STAT_PATTERN = Pattern.compile("(.).{9}\\s+(\\d+)\\s+(\\d+)\\s+(\\d+) (.*)$");
    protected static final boolean FILECHOOSER_DIR_ONLY = true;
    protected static final boolean FILECHOOSER_FILE_ONLY = false;

    VMSHardwareInfo(String name, Browser browser, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(name, browser);
        this.setResource(new Resource(name));
        this.vmsVirtualDomainInfo = vmsVirtualDomainInfo;
    }

    @Override
    protected final ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    @Override
    public final JComponent getInfoPanel() {
        if (this.infoPanel != null) {
            return this.infoPanel;
        }
        boolean abExisted = this.getApplyButton() != null;
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JTable headerTable = this.getTable("header");
        if (headerTable != null) {
            mainPanel.add(headerTable.getTableHeader());
            mainPanel.add(headerTable);
        }
        this.addHardwareTable(mainPanel);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        JPanel optionsPanel = new JPanel(new FlowLayout(0, 0, 20));
        optionsPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        final String[] params = this.getParametersFromXML();
        this.initApplyButton(null);
        if (!abExisted) {
            this.getApplyButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            VMSHardwareInfo.this.getBrowser().clStatusLock();
                            VMSHardwareInfo.this.apply(false);
                            VMSHardwareInfo.this.getBrowser().clStatusUnlock();
                        }
                    });
                    thread.start();
                }
            });
            this.getRevertButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            VMSHardwareInfo.this.getBrowser().clStatusLock();
                            VMSHardwareInfo.this.revert();
                            VMSHardwareInfo.this.getBrowser().clStatusUnlock();
                        }
                    });
                    thread.start();
                }
            });
        }
        JPanel extraButtonPanel = new JPanel(new FlowLayout(2, 3, 0));
        extraButtonPanel.setBackground(Browser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.add(extraButtonPanel);
        this.addApplyButton(buttonPanel);
        this.addRevertButton(extraButtonPanel);
        MyButton overviewButton = new MyButton("VM Host Overview", BACK_ICON);
        overviewButton.miniButton();
        overviewButton.setPreferredSize(new Dimension(130, 50));
        overviewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VMSHardwareInfo.this.vmsVirtualDomainInfo.selectMyself();
            }
        });
        extraButtonPanel.add(overviewButton);
        this.addParams(optionsPanel, params, ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH * 2, null);
        buttonPanel.add((Component)this.getActionsButton(), "East");
        mainPanel.add(optionsPanel);
        JPanel newPanel = new JPanel();
        newPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(buttonPanel);
        newPanel.add(this.getMoreOptionsPanel(ClusterBrowser.SERVICE_LABEL_WIDTH + ClusterBrowser.SERVICE_FIELD_WIDTH + 4));
        newPanel.add(new JScrollPane(mainPanel));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VMSHardwareInfo.this.getApplyButton().setVisible(!VMSHardwareInfo.this.getVMSVirtualDomainInfo().getResource().isNew());
                VMSHardwareInfo.this.setApplyButtons(null, params);
            }
        });
        this.infoPanel = newPanel;
        this.infoPanelDone();
        return this.infoPanel;
    }

    @Override
    protected final boolean hasUnitPrefix(String param) {
        return HAS_UNIT.containsKey(param) && HAS_UNIT.get(param) != false;
    }

    @Override
    protected final Unit[] getUnits() {
        return new Unit[]{new Unit("K", "K", "KiByte", "KiBytes"), new Unit("M", "M", "MiByte", "MiBytes"), new Unit("G", "G", "GiByte", "GiBytes"), new Unit("T", "T", "TiByte", "TiBytes")};
    }

    protected final String getDefaultUnit(String param) {
        return DEFAULT_UNIT.get(param);
    }

    @Override
    protected final String[] getColumnNames(String tableName) {
        return this.vmsVirtualDomainInfo.getColumnNames(tableName);
    }

    @Override
    protected final void rowClicked(final String tableName, final String key, final int column) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (VMSHardwareInfo.this.isControlButton(tableName, column)) {
                    VMSHardwareInfo.this.vmsVirtualDomainInfo.rowClicked(tableName, key, column);
                } else {
                    VMSHardwareInfo.this.vmsVirtualDomainInfo.selectMyself();
                }
            }
        });
        thread.start();
    }

    @Override
    protected final Color getTableRowColor(String tableName, String key) {
        if ("header".equals(tableName)) {
            return this.vmsVirtualDomainInfo.getTableRowColor(tableName, key);
        }
        return Browser.PANEL_BACKGROUND;
    }

    @Override
    protected final int getTableColumnAlignment(String tableName, int column) {
        if ("header".equals(tableName)) {
            return this.vmsVirtualDomainInfo.getTableColumnAlignment(tableName, column);
        }
        return 2;
    }

    @Override
    protected final Info getTableInfo(String tableName, String key) {
        if ("header".equals(tableName)) {
            return this.vmsVirtualDomainInfo;
        }
        return null;
    }

    protected final VMSVirtualDomainInfo getVMSVirtualDomainInfo() {
        return this.vmsVirtualDomainInfo;
    }

    protected final Host getFirstConnectedHost() {
        for (Host h : this.getBrowser().getClusterHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null || !h.isConnected()) continue;
            return h;
        }
        return null;
    }

    protected abstract String isRemoveable();

    abstract void updateParameters();

    @Override
    public final List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        boolean testOnly = false;
        MyMenuItem removeMenuItem = new MyMenuItem(Tools.getString("VMSHardwareInfo.Menu.Remove"), ClusterBrowser.REMOVE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, Tools.getString("VMSHardwareInfo.Menu.Cancel"), ClusterBrowser.REMOVE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return !VMSHardwareInfo.this.getResource().isNew();
            }

            @Override
            public String enablePredicate() {
                if (VMSHardwareInfo.this.getResource().isNew()) {
                    return null;
                }
                return VMSHardwareInfo.this.isRemoveable();
            }

            @Override
            public void action() {
                VMSHardwareInfo.this.hidePopup();
                VMSHardwareInfo.this.removeMyself(false);
            }
        };
        this.addMouseOverListener(removeMenuItem, null);
        items.add(removeMenuItem);
        return items;
    }

    @Override
    public final void removeMyself(boolean testOnly) {
        if (this.getResource().isNew()) {
            super.removeMyself(testOnly);
            this.getResource().setNew(false);
            this.removeNode();
            return;
        }
        String desc = Tools.getString("VMSHardwareInfo.confirmRemove.Description");
        desc = desc.replaceAll("@HW@", Matcher.quoteReplacement(this.toString()));
        if (Tools.confirmDialog(Tools.getString("VMSHardwareInfo.confirmRemove.Title"), desc, Tools.getString("VMSHardwareInfo.confirmRemove.Yes"), Tools.getString("VMSHardwareInfo.confirmRemove.No"))) {
            this.removeMyselfNoConfirm(testOnly);
            this.getResource().setNew(false);
        }
    }

    protected abstract void removeMyselfNoConfirm(boolean var1);

    abstract void apply(boolean var1);

    protected abstract void addHardwareTable(JPanel var1);

    protected abstract void modifyXML(VMSXML var1, Node var2, String var3, Map<String, String> var4);

    @Override
    protected final Map<Integer, Integer> getDefaultWidths(String tableName) {
        return this.vmsVirtualDomainInfo.getDefaultWidths(tableName);
    }

    protected Map<String, String> getHWParameters(boolean allParams) {
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSHardwareInfo.this.getInfoPanel();
            }
        });
        String[] params = this.getParametersFromXML();
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String param : this.getParametersFromXML()) {
            String value = this.getComboBoxValue(param);
            if (!allParams && Tools.areEqual(this.getParamSaved(param), value)) continue;
            if (Tools.areEqual(this.getParamDefault(param), value)) {
                parameters.put(param, null);
                continue;
            }
            parameters.put(param, value);
        }
        return parameters;
    }

    @Override
    protected final boolean isControlButton(String tableName, int column) {
        return this.vmsVirtualDomainInfo.isControlButton(tableName, column);
    }

    @Override
    protected String getTableToolTip(String tableName, String key, Object object, int raw, int column) {
        return this.vmsVirtualDomainInfo.getTableToolTip(tableName, key, object, raw, column);
    }

    public final LinuxFile getLinuxDir(String dir, Host host) {
        LinuxFile ret = this.linuxFileCache.get(dir);
        if (ret == null) {
            ret = new LinuxFile(this, host, dir, "d", 0L, 0L);
            this.linuxFileCache.put(dir, ret);
        }
        return ret;
    }

    private FileSystemView getFileSystemView(final Host host, final String directory) {
        final VMSHardwareInfo thisClass = this;
        return new FileSystemView(){

            @Override
            public final File[] getRoots() {
                return new LinuxFile[]{VMSHardwareInfo.this.getLinuxDir("/", host)};
            }

            @Override
            public final boolean isRoot(File f) {
                String path = Tools.getUnixPath(f.toString());
                return "/".equals(path);
            }

            @Override
            public final File createNewFolder(File containingDir) {
                return null;
            }

            @Override
            public final File getHomeDirectory() {
                return VMSHardwareInfo.this.getLinuxDir(directory, host);
            }

            @Override
            public final Boolean isTraversable(File f) {
                LinuxFile lf = (LinuxFile)VMSHardwareInfo.this.linuxFileCache.get(f.toString());
                if (lf != null) {
                    return lf.isDirectory();
                }
                return true;
            }

            @Override
            public final File getParentDirectory(File dir) {
                return VMSHardwareInfo.this.getLinuxDir(dir.getParent(), host);
            }

            @Override
            public final File[] getFiles(File dir, boolean useFileHiding) {
                StringBuilder dirSB = new StringBuilder(dir.toString());
                if ("/".equals(dir.toString())) {
                    dirSB.append('*');
                } else {
                    dirSB.append("/*");
                }
                SSH.SSHOutput out = Tools.execCommandProgressIndicator(host, "stat -c \"%A %a %Y %s %n\" " + dirSB.toString() + " 2>/dev/null", null, false, "executing...", SSH.DEFAULT_COMMAND_TIMEOUT);
                ArrayList<LinuxFile> files = new ArrayList<LinuxFile>();
                if (out.getExitCode() == 0) {
                    for (String line : out.getOutput().split("\r\n")) {
                        if ("".equals(line.trim())) continue;
                        Matcher m = STAT_PATTERN.matcher(line);
                        if (m.matches()) {
                            String type = m.group(1);
                            long lastModified = Long.parseLong(m.group(3)) * 1000L;
                            long size = Long.parseLong(m.group(4));
                            String filename = m.group(5);
                            LinuxFile lf = (LinuxFile)VMSHardwareInfo.this.linuxFileCache.get(filename);
                            if (lf == null) {
                                lf = new LinuxFile(thisClass, host, filename, type, lastModified, size);
                                VMSHardwareInfo.this.linuxFileCache.put(filename, lf);
                            } else {
                                lf.update(type, lastModified, size);
                            }
                            files.add(lf);
                            continue;
                        }
                        Tools.appWarning("could not match: " + line);
                    }
                }
                return files.toArray(new LinuxFile[files.size()]);
            }
        };
    }

    protected void startFileChooser(Widget paramWi, String directory, boolean dirOnly) {
        final Host host = this.getFirstConnectedHost();
        if (host == null) {
            Tools.appError("Connection to host lost.");
            return;
        }
        final VMSHardwareInfo thisClass = this;
        JFileChooser fc = new JFileChooser(this.getLinuxDir(directory, host), this.getFileSystemView(host, directory)){
            private static final long serialVersionUID = 1L;

            @Override
            public final void setCurrentDirectory(File dir) {
                super.setCurrentDirectory(new LinuxFile(thisClass, host, dir.toString(), "d", 0L, 0L));
            }
        };
        fc.setBackground(ClusterBrowser.STATUS_BACKGROUND);
        fc.setDialogType(2);
        if (dirOnly) {
            fc.setFileSelectionMode(1);
        }
        fc.setDialogTitle(Tools.getString("VMSDiskInfo.FileChooserTitle") + host.getName());
        fc.setApproveButtonToolTipText(Tools.getString("VMSDiskInfo.Approve.ToolTip"));
        fc.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        int ret = fc.showDialog(Tools.getGUIData().getMainFrame(), Tools.getString("VMSDiskInfo.Approve"));
        this.linuxFileCache.clear();
        if (ret == 0 && fc.getSelectedFile() != null) {
            String name = fc.getSelectedFile().getAbsolutePath();
            paramWi.setValue(name);
        }
    }

    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params) {
        return this.checkResourceFieldsChanged(param, params, false);
    }

    boolean checkResourceFieldsChanged(String param, String[] params, boolean fromDomain) {
        VMSVirtualDomainInfo vdi = this.vmsVirtualDomainInfo;
        if (!fromDomain && vdi != null && params.length != 1) {
            vdi.setApplyButtons(null, vdi.getParametersFromXML());
        }
        String[] parameters = params == null || params.length == 1 ? params : this.getRealParametersFromXML();
        return super.checkResourceFieldsChanged(param, parameters);
    }

    @Override
    public boolean checkResourceFieldsCorrect(String param, String[] params) {
        return this.checkResourceFieldsCorrect(param, params, false);
    }

    boolean checkResourceFieldsCorrect(String param, String[] params, boolean fromDomain) {
        VMSVirtualDomainInfo vdi = this.vmsVirtualDomainInfo;
        if (!fromDomain && vdi != null && params.length != 1) {
            vdi.setApplyButtons(null, vdi.getParametersFromXML());
        }
        String[] parameters = params == null || params.length == 1 ? params : this.getRealParametersFromXML();
        return super.checkResourceFieldsCorrect(param, parameters);
    }

    @Override
    protected final void checkOneParam(String param) {
        this.checkResourceFieldsCorrect(param, new String[]{param}, true);
    }

    String[] getRealParametersFromXML() {
        return this.getParametersFromXML();
    }

    public final void savePreferredValues() {
        for (String param : this.getParametersFromXML()) {
            String pv = this.getParamPreferred(param);
            if (pv == null) continue;
            this.getResource().setValue(param, pv);
        }
    }
}

