/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.widget;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import lcmc.data.AccessMode;
import lcmc.gui.resources.Info;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

public final class RadioGroup
extends Widget {
    private static final long serialVersionUID = 1L;
    private String radioGroupValue;
    private final Map<String, Object> radioGroupHash = new HashMap<String, Object>();
    private final Map<String, JComponent> componentsHash = new HashMap<String, JComponent>();
    private final ReadWriteLock mComponentsLock = new ReentrantReadWriteLock();
    private final Lock mComponentsReadLock = this.mComponentsLock.readLock();
    private final Lock mComponentsWriteLock = this.mComponentsLock.writeLock();

    public RadioGroup(String selectedValue, Object[] items, String regexp, int width, AccessMode enableAccessMode, MyButton fieldButton) {
        super(regexp, enableAccessMode, fieldButton);
        this.addComponent(this.getRadioGroup(selectedValue, items), width);
    }

    protected JComponent getRadioGroup(String selectedValue, Object[] items) {
        ButtonGroup group = new ButtonGroup();
        JPanel radioPanel = new JPanel(new GridLayout(1, 1));
        this.mComponentsWriteLock.lock();
        this.componentsHash.clear();
        for (int i = 0; i < items.length; ++i) {
            Object item = items[i];
            JRadioButton rb = new JRadioButton(item.toString());
            this.radioGroupHash.put(item.toString(), item);
            rb.setActionCommand(item.toString());
            group.add(rb);
            radioPanel.add(rb);
            String v = item instanceof Info ? ((Info)item).getInternalValue() : item.toString();
            this.componentsHash.put(v, rb);
            if (v.equals(selectedValue)) {
                rb.setSelected(true);
                this.radioGroupValue = selectedValue;
            }
            rb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RadioGroup.this.mComponentsReadLock.lock();
                    Object item = RadioGroup.this.radioGroupHash.get(e.getActionCommand());
                    RadioGroup.this.mComponentsReadLock.unlock();
                    String v = item instanceof Info ? ((Info)item).getInternalValue() : item.toString();
                    RadioGroup.this.radioGroupValue = v;
                }
            });
        }
        this.mComponentsWriteLock.unlock();
        return radioPanel;
    }

    @Override
    public void setEnabled(String s, boolean enabled) {
        JLabel label;
        final boolean accessible = Tools.getConfigData().isAccessible(this.getEnableAccessMode());
        this.mComponentsReadLock.lock();
        final JComponent c = this.componentsHash.get(s);
        this.mComponentsReadLock.unlock();
        if (c != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    c.setEnabled(RadioGroup.this.isEnablePredicate() && accessible);
                }
            });
        }
        if ((label = this.getLabel()) != null) {
            label.setEnabled(accessible);
        }
    }

    public void setVisible(String s, boolean visible) {
        this.mComponentsReadLock.lock();
        JComponent c = this.componentsHash.get(s);
        this.mComponentsReadLock.unlock();
        if (c != null) {
            c.setVisible(visible);
        }
    }

    @Override
    public String getStringValue() {
        Object o = this.getValue();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    protected Object getValueInternal() {
        String value = this.radioGroupValue;
        if (NOTHING_SELECTED_DISPLAY.equals(value)) {
            return null;
        }
        return value;
    }

    @Override
    protected void setComponentsVisible(final boolean visible) {
        final JComponent comp = this.getComponent();
        final JLabel label = this.getLabel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (label != null) {
                    label.setVisible(visible);
                }
                comp.setVisible(visible);
                RadioGroup.this.mComponentsReadLock.lock();
                for (JComponent c : RadioGroup.this.componentsHash.values()) {
                    c.setVisible(visible);
                }
                RadioGroup.this.mComponentsReadLock.unlock();
                RadioGroup.this.repaint();
            }
        });
    }

    @Override
    boolean isEditable() {
        return false;
    }

    @Override
    protected void setValueAndWait0(Object item) {
        if (item != null) {
            this.mComponentsReadLock.lock();
            JRadioButton rb = (JRadioButton)this.componentsHash.get(item);
            this.mComponentsReadLock.unlock();
            if (rb != null) {
                rb.setSelected(true);
            }
            this.radioGroupValue = item instanceof Info ? ((Info)item).getInternalValue() : (String)item;
        }
    }

    @Override
    public Document getDocument() {
        return null;
    }

    @Override
    public void addListeners(WidgetListener wl) {
        this.getWidgetListeners().add(wl);
        this.mComponentsReadLock.lock();
        ItemListener il = this.getItemListener(wl);
        for (JComponent c : this.componentsHash.values()) {
            ((JRadioButton)c).addItemListener(il);
        }
        this.mComponentsReadLock.unlock();
    }

    @Override
    protected void setComponentBackground(Color backgroundColor, Color compColor) {
        this.getComponent().setBackground(backgroundColor);
        this.mComponentsReadLock.lock();
        for (JComponent c : this.componentsHash.values()) {
            c.setBackground(backgroundColor);
        }
        this.mComponentsReadLock.unlock();
    }

    @Override
    public void setBackgroundColor(final Color bg) {
        final JComponent comp = this.getComponent();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RadioGroup.this.setBackground(bg);
                comp.setBackground(bg);
                RadioGroup.this.mComponentsReadLock.lock();
                for (JComponent c : RadioGroup.this.componentsHash.values()) {
                    c.setBackground(bg);
                }
                RadioGroup.this.mComponentsReadLock.unlock();
            }
        });
    }

    @Override
    Object getItemAt(int i) {
        return this.getComponent();
    }

    @Override
    public void cleanup() {
        this.getWidgetListeners().clear();
        this.mComponentsReadLock.lock();
        for (JComponent c : this.componentsHash.values()) {
            for (ItemListener il : ((JRadioButton)c).getItemListeners()) {
                ((JRadioButton)c).removeItemListener(il);
            }
        }
        this.mComponentsReadLock.unlock();
    }

    @Override
    protected void setComponentsEnabled(boolean enabled) {
        super.setComponentsEnabled(enabled);
        this.mComponentsReadLock.lock();
        for (JComponent c : this.componentsHash.values()) {
            c.setEnabled(enabled);
        }
        this.mComponentsReadLock.unlock();
    }
}

