/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.gui.SpringUtilities;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

public abstract class Widget
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComponent component;
    private boolean editable = false;
    private boolean alwaysEditable = false;
    private MyButton fieldButton;
    private JComponent componentPart = null;
    private static final Color ERROR_VALUE_BACKGROUND = Tools.getDefaultColor("Widget.ErrorValue");
    private static final Color CHANGED_VALUE_COLOR = Tools.getDefaultColor("Widget.ChangedValue");
    private static final Color DEFAULT_VALUE_COLOR = Tools.getDefaultColor("Widget.DefaultValue");
    private static final Color SAVED_VALUE_COLOR = Tools.getDefaultColor("Widget.SavedValue");
    protected static final int SCROLLBAR_MAX_ROWS = 10;
    protected static final int WIDGET_HEIGHT = 28;
    private static final int WIDGET_COMPONENT_HEIGHT = 30;
    public static final String NOTHING_SELECTED_DISPLAY = Tools.getString("Widget.NothingSelected");
    public static final String NOTHING_SELECTED_INTERNAL = null;
    private JLabel label = null;
    private boolean enablePredicate = true;
    private boolean tfButtonEnabled = true;
    private AccessMode enableAccessMode = new AccessMode(ConfigData.AccessType.RO, false);
    private String toolTipText = null;
    private String labelToolTipText = null;
    private final ReadWriteLock mValueLock = new ReentrantReadWriteLock();
    private final Lock mValueReadLock = this.mValueLock.readLock();
    private final Lock mValueWriteLock = this.mValueLock.writeLock();
    private final String regexp;
    private String disabledReason = null;
    private final List<WidgetListener> widgetListeners = new ArrayList<WidgetListener>();
    private boolean newFlag = true;
    public static final Type GUESS_TYPE = null;
    public static final String NO_DEFAULT = null;
    public static final Object[] NO_ITEMS = null;
    public static final String NO_REGEXP = null;
    public static final Map<String, String> NO_ABBRV = null;
    public static final MyButton NO_BUTTON = null;
    public static final String WIZARD_PREFIX = "widget";

    public Widget(String regexp, AccessMode enableAccessMode) {
        this(regexp, enableAccessMode, NO_BUTTON);
    }

    public Widget(String regexp, AccessMode enableAccessMode, MyButton fieldButton) {
        this.enableAccessMode = enableAccessMode;
        this.fieldButton = fieldButton;
        this.setLayout(new BorderLayout(0, 0));
        this.regexp = regexp != null && regexp.indexOf("@NOTHING_SELECTED@") > -1 ? regexp.replaceAll("@NOTHING_SELECTED@", NOTHING_SELECTED_DISPLAY) : regexp;
    }

    protected final void addComponent(JComponent newComp, int width) {
        if (this.fieldButton == null) {
            this.component = newComp;
        } else {
            this.componentPart = newComp;
            this.componentPart.setPreferredSize(new Dimension(width / 3 * 2, 28));
            this.componentPart.setMinimumSize(this.componentPart.getPreferredSize());
            this.componentPart.setMaximumSize(this.componentPart.getPreferredSize());
            this.component = new JPanel();
            this.component.setLayout(new SpringLayout());
            this.component.add(newComp);
            this.component.add(this.fieldButton);
            SpringUtilities.makeCompactGrid(this.component, 1, 2, 0, 0, 0, 0);
        }
        this.component.setPreferredSize(new Dimension(width, 28));
        if (this.componentPart != null) {
            this.componentPart.setPreferredSize(new Dimension(width, 28));
        }
        this.setPreferredSize(new Dimension(width, 30));
        if (width != 0) {
            this.component.setMaximumSize(new Dimension(width, 28));
            this.setMaximumSize(new Dimension(width, 30));
        }
        this.add(Box.createRigidArea(new Dimension(0, 1)), "First");
        this.add((Component)this.component, "Center");
        this.add(Box.createRigidArea(new Dimension(0, 1)), "Last");
        this.processAccessMode();
    }

    public void reloadComboBox(String selectedValue, Object[] items) {
    }

    @Override
    public void setToolTipText(String text) {
        boolean accessible;
        this.toolTipText = text;
        String disabledReason0 = this.disabledReason;
        if (disabledReason0 != null) {
            text = text + "<br>" + disabledReason0;
        }
        if (this.enableAccessMode.getAccessType() != ConfigData.AccessType.NEVER && !(accessible = Tools.getConfigData().isAccessible(this.enableAccessMode))) {
            text = text + "<br>" + this.getDisabledTooltip();
        }
        this.component.setToolTipText("<html>" + text + "</html>");
        if (this.fieldButton != null) {
            this.componentPart.setToolTipText("<html>" + text + "</html>");
            this.fieldButton.setToolTipText("<html>" + text + "</html>");
        }
    }

    private void setLabelToolTipText(String text) {
        String disabledReason0;
        boolean accessible;
        this.labelToolTipText = text;
        if (text == null || this.label == null) {
            return;
        }
        String disabledTooltip = null;
        if (this.enableAccessMode.getAccessType() != ConfigData.AccessType.NEVER && !(accessible = Tools.getConfigData().isAccessible(this.enableAccessMode))) {
            disabledTooltip = this.getDisabledTooltip();
        }
        if ((disabledReason0 = this.disabledReason) != null || disabledTooltip != null) {
            StringBuilder tt = new StringBuilder(40);
            if (disabledReason0 != null) {
                tt.append(disabledReason0);
                tt.append("<br>");
            }
            if (disabledTooltip != null) {
                tt.append(disabledTooltip);
            }
            text = text.length() > 6 && "<html>".equals(text.substring(0, 6)) ? "<html>" + tt.toString() + "<br>" + "<br>" + text.substring(6) : Tools.html(text + "<br>" + tt.toString());
        }
        this.label.setToolTipText(text);
    }

    private String getDisabledTooltip() {
        String advanced = "";
        if (this.enableAccessMode.isAdvancedMode()) {
            advanced = "Advanced ";
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append("editable in \"");
        sb.append(advanced);
        sb.append(ConfigData.OP_MODES_MAP.get((Object)this.enableAccessMode.getAccessType()));
        sb.append("\" mode");
        if (this.disabledReason != null) {
            sb.append(' ');
            sb.append(this.disabledReason);
        }
        return sb.toString();
    }

    public final void setEditable() {
        this.setEditable(this.editable);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public abstract String getStringValue();

    public final Object getValue() {
        this.mValueReadLock.lock();
        Object value = this.getValueInternal();
        this.mValueReadLock.unlock();
        return value;
    }

    abstract Object getValueInternal();

    public void clear() {
    }

    @Override
    public final void setVisible(boolean visible) {
        this.setComponentsVisible(visible);
    }

    protected void setComponentsVisible(final boolean visible) {
        JComponent c = this.fieldButton == null ? this.component : this.componentPart;
        final JComponent comp = c;
        super.setVisible(visible);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Widget.this.label != null) {
                    Widget.this.label.setVisible(visible);
                }
                comp.setVisible(visible);
                Widget.this.repaint();
            }
        });
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enablePredicate = enabled;
        this.setComponentsEnabled(this.enablePredicate && Tools.getConfigData().isAccessible(this.enableAccessMode));
    }

    public final void setTFButtonEnabled(boolean tfButtonEnabled) {
        this.tfButtonEnabled = tfButtonEnabled;
        this.fieldButton.setEnabled(tfButtonEnabled);
    }

    protected void setComponentsEnabled(boolean enabled) {
        this.component.setEnabled(enabled);
        if (this.fieldButton != null) {
            this.componentPart.setEnabled(enabled);
            this.fieldButton.setEnabled(enabled && this.tfButtonEnabled);
        }
    }

    public void setEnabled(String s, boolean enabled) {
    }

    abstract boolean isEditable();

    public final void setValueAndWait(Object item) {
        this.newFlag = false;
        if (Tools.areEqual(item, this.getValue())) {
            return;
        }
        this.mValueWriteLock.lock();
        this.setValueAndWait0(item);
        this.mValueWriteLock.unlock();
    }

    protected abstract void setValueAndWait0(Object var1);

    public final void setValueNoListeners(Object item) {
        this.newFlag = false;
        if (Tools.areEqual(item, this.getValue())) {
            return;
        }
        for (WidgetListener wl : this.widgetListeners) {
            wl.setEnabled(false);
        }
        this.mValueWriteLock.lock();
        this.setValueAndWait0(item);
        this.mValueWriteLock.unlock();
        for (WidgetListener wl : this.widgetListeners) {
            wl.setEnabled(true);
        }
    }

    public final void setValue(final Object item) {
        this.newFlag = false;
        if (Tools.areEqual(item, this.getValue())) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Widget.this.mValueWriteLock.lock();
                Widget.this.setValueAndWait0(item);
                Widget.this.mValueWriteLock.unlock();
            }
        });
    }

    public void setSelectedIndex(int index) {
    }

    public abstract Document getDocument();

    public void selectSubnet() {
    }

    protected final void addDocumentListener(final Document doc, final WidgetListener wl) {
        doc.addDocumentListener(new DocumentListener(){

            private void check(DocumentEvent e) {
                if (wl.isEnabled()) {
                    try {
                        final String text = e.getDocument().getText(0, doc.getLength());
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                wl.check(text);
                            }
                        });
                        t.start();
                    }
                    catch (BadLocationException ble) {
                        Tools.appWarning("document listener error");
                    }
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.check(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.check(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.check(e);
            }
        });
    }

    protected ItemListener getItemListener(final WidgetListener wl) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (wl.isEnabled() && e.getStateChange() == 1) {
                    final Object value = e.getItem();
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            wl.check(value);
                        }
                    });
                    t.start();
                }
            }
        };
    }

    public void addListeners(WidgetListener wl) {
        this.widgetListeners.add(wl);
    }

    public final void wrongValue() {
        this.setBackgroundColor(ERROR_VALUE_BACKGROUND);
        if (this.label != null) {
            this.label.setForeground(Color.RED);
        }
    }

    public final void setBackground(Object defaultValue, Object savedValue, boolean required) {
        this.setBackground(null, defaultValue, null, savedValue, required);
    }

    public final void setBackground(String defaultLabel, Object defaultValue, String savedLabel, Object savedValue, boolean required) {
        if (this.getParent() == null) {
            return;
        }
        if (this.fieldButton == null) {
            JComponent comp = this.component;
        } else {
            JComponent comp = this.componentPart;
        }
        Object value = this.getValue();
        String labelText = null;
        if (savedLabel != null) {
            labelText = this.label.getText();
        }
        Color backgroundColor = this.getParent().getBackground();
        Color compColor = Color.WHITE;
        if (!Tools.areEqual(value, savedValue) || savedLabel != null && !Tools.areEqual(labelText, savedLabel)) {
            if (this.label != null) {
                Tools.debug(this, "changed label: " + labelText + " != " + savedLabel, 1);
                Tools.debug(this, "changed: " + value + " != " + savedValue, 1);
                this.label.setForeground(CHANGED_VALUE_COLOR);
            }
        } else if (Tools.areEqual(value, defaultValue) && (savedLabel == null || Tools.areEqual(labelText, defaultLabel))) {
            if (this.label != null) {
                this.label.setForeground(DEFAULT_VALUE_COLOR);
            }
        } else if (this.label != null) {
            this.label.setForeground(SAVED_VALUE_COLOR);
        }
        this.setBackground(backgroundColor);
        this.setComponentBackground(backgroundColor, compColor);
        this.processAccessMode();
    }

    protected void setComponentBackground(Color backgroundColor, Color compColor) {
    }

    public final void setAlwaysEditable(boolean alwaysEditable) {
        this.alwaysEditable = alwaysEditable;
        this.setEditable(alwaysEditable);
    }

    protected final boolean isAlwaysEditable() {
        return this.alwaysEditable;
    }

    @Override
    public void requestFocus() {
    }

    void selectAll() {
    }

    public final void setWidth(int newWidth) {
        int hc = (int)this.component.getPreferredSize().getHeight();
        int h = (int)this.getPreferredSize().getHeight();
        this.component.setMinimumSize(new Dimension(newWidth, hc));
        this.component.setPreferredSize(new Dimension(newWidth, hc));
        this.component.setMaximumSize(new Dimension(newWidth, hc));
        this.setMinimumSize(new Dimension(newWidth, h));
        this.setPreferredSize(new Dimension(newWidth, h));
        this.setMaximumSize(new Dimension(newWidth, h));
        this.revalidate();
        this.component.revalidate();
        this.repaint();
        this.component.repaint();
    }

    final JComponent getJComponent() {
        return this.component;
    }

    public void setBackgroundColor(final Color bg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Widget.this.setBackground(bg);
            }
        });
    }

    public final void setLabel(JLabel label, String labelToolTipText) {
        this.label = label;
        this.labelToolTipText = labelToolTipText;
    }

    public final JLabel getLabel() {
        return this.label;
    }

    public final void processAccessMode() {
        boolean accessible = Tools.getConfigData().isAccessible(this.enableAccessMode);
        this.setComponentsEnabled(this.enablePredicate && accessible);
        if (this.toolTipText != null) {
            this.setToolTipText(this.toolTipText);
        }
        if (this.label != null) {
            if (this.labelToolTipText != null) {
                this.setLabelToolTipText(this.labelToolTipText);
            }
            this.label.setEnabled(this.enablePredicate && accessible);
        }
    }

    Object getItemAt(int i) {
        return null;
    }

    public void cleanup() {
        this.widgetListeners.clear();
    }

    public final String getRegexp() {
        return this.regexp;
    }

    public final void setDisabledReason(String disabledReason) {
        this.disabledReason = disabledReason;
    }

    protected final JComponent getComponent() {
        if (this.fieldButton == null) {
            return this.component;
        }
        return this.componentPart;
    }

    protected final List<WidgetListener> getWidgetListeners() {
        return this.widgetListeners;
    }

    protected final boolean isEnablePredicate() {
        return this.enablePredicate;
    }

    protected final AccessMode getEnableAccessMode() {
        return this.enableAccessMode;
    }

    public final boolean isNew() {
        return this.newFlag;
    }

    public void select(int selectionStart, int selectionEnd) {
        Tools.appWarning("select not implemented");
    }

    public final class MComboBox<E>
    extends JComboBox<E> {
        private static final long serialVersionUID = 1L;
        private boolean layingOut;

        public MComboBox() {
            this.layingOut = false;
        }

        public MComboBox(E[] items) {
            super(items);
            this.layingOut = false;
        }

        public MComboBox(Vector<E> items) {
            super(items);
            this.layingOut = false;
        }

        public MComboBox(ComboBoxModel<E> aModel) {
            super(aModel);
            this.layingOut = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doLayout() {
            try {
                this.layingOut = true;
                super.doLayout();
            }
            finally {
                this.layingOut = false;
            }
        }

        @Override
        public Dimension getSize() {
            Accessible c;
            Dimension dim = super.getSize();
            if (!this.layingOut && (c = this.getUI().getAccessibleChild(this, 0)) instanceof JPopupMenu) {
                JScrollPane scrollPane = (JScrollPane)((JPopupMenu)c).getComponent(0);
                Dimension size = scrollPane.getPreferredSize();
                JComponent view = (JComponent)scrollPane.getViewport().getView();
                int newSize = view.getPreferredSize().width + 2;
                dim.width = Math.max(dim.width, newSize);
            }
            return dim;
        }
    }

    public static final class MTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private volatile boolean selected = false;

        public MTextField(String text) {
            super(text);
        }

        public MTextField(String text, int columns) {
            super(text, columns);
        }

        MTextField(Document doc, String text, int columns) {
            super(doc, text, columns);
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (!this.selected) {
                this.selected = true;
                if (e.getID() == 1004) {
                    this.selectAll();
                }
            }
        }
    }

    static class ActivateDefaultButtonListener
    extends KeyAdapter
    implements ActionListener {
        private final JComboBox box;

        ActivateDefaultButtonListener(JComboBox box) {
            this.box = box;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.doClick(e);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.doClick(e);
        }

        private void doClick(EventObject e) {
            JButton defaultButton;
            Component c = (Component)e.getSource();
            JRootPane rootPane = SwingUtilities.getRootPane(c);
            if (rootPane != null && (defaultButton = rootPane.getDefaultButton()) != null && !this.box.isPopupVisible()) {
                Object selection = this.box.getEditor().getItem();
                this.box.setSelectedItem(selection);
                defaultButton.doClick();
            }
        }
    }

    public static enum Type {
        LABELFIELD,
        TEXTFIELD,
        PASSWDFIELD,
        COMBOBOX,
        RADIOGROUP,
        CHECKBOX,
        TEXTFIELDWITHUNIT;

    }
}

