/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import lcmc.data.Host;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public final class Corosync {
    private static final String COROSYNC_CONF_DIR = "/etc/corosync/";
    private static final String COROSYNC_CONF_NAME = "corosync.conf";
    private static final String COROSYNC_CONF_PERMS = "0600";
    private static final String AUTHKEYS_CONF_NAME = "authkey";
    private static final String AUTHKEYS_CONF_PERMS = "0400";

    private Corosync() {
    }

    private static void execCommand(Host host, String command, boolean outputVisible) {
        Tools.execCommandProgressIndicator(host, command, null, outputVisible, Tools.getString("Corosync.ExecutingCommand"), SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    public static void switchToCorosync(Host host) {
        String command = host.getDistCommand("Heartbeat.deleteFromRc;;;Corosync.addToRc;;;Corosync.startCorosync", (ConvertCmdCallback)null);
        Corosync.execCommand(host, command, true);
    }

    public static void startCorosync(Host host) {
        String command = host.getDistCommand("Corosync.startCorosync", (ConvertCmdCallback)null);
        Corosync.execCommand(host, command, true);
    }

    public static void startCorosyncWithPcmk(Host host) {
        String command = host.getDistCommand("Corosync.startCorosyncWithPcmk", (ConvertCmdCallback)null);
        Corosync.execCommand(host, command, true);
    }

    public static void startPacemaker(Host host) {
        String command = host.getDistCommand("Corosync.startPcmk", (ConvertCmdCallback)null);
        Corosync.execCommand(host, command, true);
    }

    public static void stopCorosync(Host host) {
        String command = host.getDistCommand("Corosync.stopCorosync", (ConvertCmdCallback)null);
        Corosync.execCommand(host, command, true);
    }

    public static void stopCorosyncWithPcmk(Host host) {
        String command = host.getDistCommand("Corosync.stopCorosyncWithPcmk", (ConvertCmdCallback)null);
        Corosync.execCommand(host, command, true);
    }

    public static void startCorosyncRc(Host host) {
        String command = host.getDistCommand("Corosync.startCorosync;;;Corosync.addToRc", (ConvertCmdCallback)null);
        Corosync.execCommand(host, command, true);
    }

    public static void addCorosyncToRc(Host host) {
        String command = host.getDistCommand("Corosync.addToRc", (ConvertCmdCallback)null);
        Corosync.execCommand(host, command, true);
    }

    public static void reloadCorosync(Host host) {
        String command = host.getDistCommand("Corosync.reloadCorosync", (ConvertCmdCallback)null);
        Corosync.execCommand(host, command, true);
    }

    public static void createCorosyncConfig(Host[] hosts, StringBuilder config) {
        Tools.createConfigOnAllHosts(hosts, config.toString(), COROSYNC_CONF_NAME, COROSYNC_CONF_DIR, COROSYNC_CONF_PERMS, true);
        StringBuilder authkeys = new StringBuilder(Tools.getRandomSecret(128));
        Tools.createConfigOnAllHosts(hosts, authkeys.toString(), AUTHKEYS_CONF_NAME, COROSYNC_CONF_DIR, AUTHKEYS_CONF_PERMS, true);
    }

    public static void reloadCorosyncs(Host[] hosts) {
        for (Host host : hosts) {
            Corosync.reloadCorosync(host);
        }
    }
}

