/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

public final class PatternDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = 1L;
    private final Pattern pattern;
    private final Map<String, String> abbreviations;

    public PatternDocument(String regexp) {
        this.pattern = Pattern.compile(regexp);
        this.abbreviations = null;
    }

    public PatternDocument(String regexp, Map<String, String> abbreviations) {
        this.pattern = Pattern.compile(regexp);
        this.abbreviations = abbreviations;
    }

    @Override
    public void insertString(int offs, String s, AttributeSet a) throws BadLocationException {
        try {
            String texta;
            String text = this.getText(0, this.getLength());
            if (this.abbreviations != null && this.abbreviations.containsKey(s)) {
                s = this.abbreviations.get(s);
            }
            if (this.matches(texta = text.length() > 0 ? (offs >= 0 ? text.substring(0, offs) : "") + s + text.substring(offs) : s)) {
                super.insertString(offs, s, a);
            }
        }
        catch (BadLocationException e) {
            return;
        }
    }

    private boolean matches(String text) {
        return true;
    }
}

