/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.bidimap;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.MapIterator;
import org.apache.commons.collections15.OrderedBidiMap;
import org.apache.commons.collections15.OrderedMapIterator;
import org.apache.commons.collections15.SortedBidiMap;
import org.apache.commons.collections15.Unmodifiable;
import org.apache.commons.collections15.bidimap.AbstractSortedBidiMapDecorator;
import org.apache.commons.collections15.iterators.UnmodifiableOrderedMapIterator;
import org.apache.commons.collections15.map.UnmodifiableEntrySet;
import org.apache.commons.collections15.map.UnmodifiableSortedMap;
import org.apache.commons.collections15.set.UnmodifiableSet;

public final class UnmodifiableSortedBidiMap<K, V>
extends AbstractSortedBidiMapDecorator<K, V>
implements Unmodifiable {
    private UnmodifiableSortedBidiMap<V, K> inverse;

    public static <K, V> SortedBidiMap<K, V> decorate(SortedBidiMap<K, V> map) {
        if (map instanceof Unmodifiable) {
            return map;
        }
        return new UnmodifiableSortedBidiMap<K, V>(map);
    }

    private UnmodifiableSortedBidiMap(SortedBidiMap<K, V> map) {
        super(map);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> mapToCopy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = super.entrySet();
        return UnmodifiableEntrySet.decorate(set);
    }

    @Override
    public Set<K> keySet() {
        Set set = super.keySet();
        return UnmodifiableSet.decorate(set);
    }

    @Override
    public Set<V> values() {
        Collection coll = super.values();
        return UnmodifiableSet.decorate(coll);
    }

    @Override
    public K removeValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MapIterator<K, V> mapIterator() {
        return this.orderedMapIterator();
    }

    @Override
    public BidiMap<V, K> inverseBidiMap() {
        return this.inverseSortedBidiMap();
    }

    @Override
    public OrderedMapIterator<K, V> orderedMapIterator() {
        OrderedMapIterator it = this.getSortedBidiMap().orderedMapIterator();
        return UnmodifiableOrderedMapIterator.decorate(it);
    }

    @Override
    public OrderedBidiMap<V, K> inverseOrderedBidiMap() {
        return this.inverseSortedBidiMap();
    }

    @Override
    public SortedBidiMap<V, K> inverseSortedBidiMap() {
        if (this.inverse == null) {
            this.inverse = new UnmodifiableSortedBidiMap<K, V>(this.getSortedBidiMap().inverseSortedBidiMap());
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        SortedMap sm = this.getSortedBidiMap().subMap(fromKey, toKey);
        return UnmodifiableSortedMap.decorate(sm);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        SortedMap sm = this.getSortedBidiMap().headMap(toKey);
        return UnmodifiableSortedMap.decorate(sm);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        SortedMap sm = this.getSortedBidiMap().tailMap(fromKey);
        return UnmodifiableSortedMap.decorate(sm);
    }
}

