/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.collection;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections15.BoundedCollection;
import org.apache.commons.collections15.collection.AbstractCollectionDecorator;
import org.apache.commons.collections15.collection.AbstractSerializableCollectionDecorator;
import org.apache.commons.collections15.collection.SynchronizedCollection;
import org.apache.commons.collections15.iterators.UnmodifiableIterator;

public final class UnmodifiableBoundedCollection<E>
extends AbstractSerializableCollectionDecorator<E>
implements BoundedCollection<E> {
    private static final long serialVersionUID = -7112672385450340330L;

    public static <E> BoundedCollection<E> decorate(BoundedCollection<E> coll) {
        return new UnmodifiableBoundedCollection<E>(coll);
    }

    public static <E> BoundedCollection<E> decorateUsing(Collection<E> coll) {
        if (coll == null) {
            throw new IllegalArgumentException("The collection must not be null");
        }
        for (int i = 0; i < 1000 && !(coll instanceof BoundedCollection); ++i) {
            if (coll instanceof AbstractCollectionDecorator) {
                coll = ((AbstractCollectionDecorator)coll).collection;
                continue;
            }
            if (!(coll instanceof SynchronizedCollection)) break;
            coll = ((SynchronizedCollection)coll).collection;
        }
        if (!(coll instanceof BoundedCollection)) {
            throw new IllegalArgumentException("The collection is not a bounded collection");
        }
        return new UnmodifiableBoundedCollection<E>((BoundedCollection)coll);
    }

    private UnmodifiableBoundedCollection(BoundedCollection<E> coll) {
        super(coll);
    }

    @Override
    public Iterator<E> iterator() {
        return UnmodifiableIterator.decorate(this.getCollection().iterator());
    }

    @Override
    public boolean add(E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFull() {
        return ((BoundedCollection)this.collection).isFull();
    }

    @Override
    public int maxSize() {
        return ((BoundedCollection)this.collection).maxSize();
    }
}

