/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections15.Unmodifiable;
import org.apache.commons.collections15.collection.UnmodifiableCollection;
import org.apache.commons.collections15.map.AbstractSortedMapDecorator;
import org.apache.commons.collections15.map.UnmodifiableEntrySet;
import org.apache.commons.collections15.set.UnmodifiableSet;

public final class UnmodifiableSortedMap<K, V>
extends AbstractSortedMapDecorator<K, V>
implements Unmodifiable,
Serializable {
    private static final long serialVersionUID = 5805344239827376360L;

    public static <K, V> SortedMap<K, V> decorate(SortedMap<K, V> map) {
        if (map instanceof Unmodifiable) {
            return map;
        }
        return new UnmodifiableSortedMap<K, V>(map);
    }

    private UnmodifiableSortedMap(SortedMap<K, V> map) {
        super(map);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> mapToCopy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = super.entrySet();
        return UnmodifiableEntrySet.decorate(set);
    }

    @Override
    public Set<K> keySet() {
        Set set = super.keySet();
        return UnmodifiableSet.decorate(set);
    }

    @Override
    public Collection<V> values() {
        Collection coll = super.values();
        return UnmodifiableCollection.decorate(coll);
    }

    @Override
    public K firstKey() {
        return this.getSortedMap().firstKey();
    }

    @Override
    public K lastKey() {
        return this.getSortedMap().lastKey();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.getSortedMap().comparator();
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        SortedMap map = this.getSortedMap().subMap(fromKey, toKey);
        return new UnmodifiableSortedMap(map);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        SortedMap map = this.getSortedMap().headMap(toKey);
        return new UnmodifiableSortedMap(map);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        SortedMap map = this.getSortedMap().tailMap(fromKey);
        return new UnmodifiableSortedMap(map);
    }
}

