/*
 * Decompiled with CFR 0.152.
 */
package tightvnc;

import java.applet.Applet;
import java.io.IOException;
import java.net.Socket;
import tightvnc.HTTPConnectSocket;
import tightvnc.SocketFactory;

class HTTPConnectSocketFactory
implements SocketFactory {
    HTTPConnectSocketFactory() {
    }

    @Override
    public Socket createSocket(String host, int port, Applet applet) throws IOException {
        return this.createSocket(host, port, applet.getParameter("PROXYHOST1"), applet.getParameter("PROXYPORT1"));
    }

    @Override
    public Socket createSocket(String host, int port, String[] args) throws IOException {
        return this.createSocket(host, port, this.readArg(args, "PROXYHOST1"), this.readArg(args, "PROXYPORT1"));
    }

    public Socket createSocket(String host, int port, String proxyHost, String proxyPortStr) throws IOException {
        int proxyPort = 0;
        if (proxyPortStr != null) {
            try {
                proxyPort = Integer.parseInt(proxyPortStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (proxyHost == null || proxyPort == 0) {
            System.out.println("Incomplete parameter list for HTTPConnectSocket");
            return new Socket(host, port);
        }
        System.out.println("HTTP CONNECT via proxy " + proxyHost + " port " + proxyPort);
        HTTPConnectSocket s = new HTTPConnectSocket(host, port, proxyHost, proxyPort);
        return s;
    }

    private String readArg(String[] args, String name) {
        for (int i = 0; i < args.length; i += 2) {
            if (!args[i].equalsIgnoreCase(name)) continue;
            try {
                return args[i + 1];
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

