/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.io.Serializable;
import org.mockito.ReturnValues;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.configuration.DefaultMockitoConfiguration;
import org.mockito.configuration.IMockitoConfiguration;
import org.mockito.internal.configuration.ClassPathLoader;
import org.mockito.stubbing.Answer;

public class GlobalConfiguration
implements IMockitoConfiguration,
Serializable {
    private static final long serialVersionUID = -2860353062105505938L;
    private static final ThreadLocal<IMockitoConfiguration> GLOBAL_CONFIGURATION = new ThreadLocal();

    IMockitoConfiguration getIt() {
        return GLOBAL_CONFIGURATION.get();
    }

    public GlobalConfiguration() {
        if (GLOBAL_CONFIGURATION.get() == null) {
            GLOBAL_CONFIGURATION.set(this.createConfig());
        }
    }

    private IMockitoConfiguration createConfig() {
        DefaultMockitoConfiguration defaultMockitoConfiguration = new DefaultMockitoConfiguration();
        IMockitoConfiguration iMockitoConfiguration = new ClassPathLoader().loadConfiguration();
        if (iMockitoConfiguration != null) {
            return iMockitoConfiguration;
        }
        return defaultMockitoConfiguration;
    }

    public static void validate() {
        new GlobalConfiguration();
    }

    @Override
    public ReturnValues getReturnValues() {
        return GLOBAL_CONFIGURATION.get().getReturnValues();
    }

    @Override
    public AnnotationEngine getAnnotationEngine() {
        return GLOBAL_CONFIGURATION.get().getAnnotationEngine();
    }

    @Override
    public boolean cleansStackTrace() {
        return GLOBAL_CONFIGURATION.get().cleansStackTrace();
    }

    @Override
    public boolean enableClassCache() {
        return GLOBAL_CONFIGURATION.get().enableClassCache();
    }

    @Override
    public Answer<Object> getDefaultAnswer() {
        return GLOBAL_CONFIGURATION.get().getDefaultAnswer();
    }
}

