/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import java.io.Serializable;
import org.mockito.exceptions.Reporter;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ReturnsArgumentAt
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = -589315085166295101L;
    public static final int LAST_ARGUMENT = -1;
    private final int wantedArgumentPosition;

    public ReturnsArgumentAt(int n) {
        this.wantedArgumentPosition = this.checkWithinAllowedRange(n);
    }

    @Override
    public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
        this.validateIndexWithinInvocationRange(invocationOnMock);
        return invocationOnMock.getArguments()[this.actualArgumentPosition(invocationOnMock)];
    }

    private int actualArgumentPosition(InvocationOnMock invocationOnMock) {
        return this.returningLastArg() ? this.lastArgumentIndexOf(invocationOnMock) : this.argumentIndexOf(invocationOnMock);
    }

    private boolean returningLastArg() {
        return this.wantedArgumentPosition == -1;
    }

    private int argumentIndexOf(InvocationOnMock invocationOnMock) {
        return this.wantedArgumentPosition;
    }

    private int lastArgumentIndexOf(InvocationOnMock invocationOnMock) {
        return invocationOnMock.getArguments().length - 1;
    }

    private int checkWithinAllowedRange(int n) {
        if (n != -1 && n < 0) {
            new Reporter().invalidArgumentRangeAtIdentityAnswerCreationTime();
        }
        return n;
    }

    public int wantedArgumentPosition() {
        return this.wantedArgumentPosition;
    }

    public void validateIndexWithinInvocationRange(InvocationOnMock invocationOnMock) {
        if (!this.argumentPositionInRange(invocationOnMock)) {
            new Reporter().invalidArgumentPositionRangeAtInvocationTime(invocationOnMock, this.returningLastArg(), this.wantedArgumentPosition);
        }
    }

    private boolean argumentPositionInRange(InvocationOnMock invocationOnMock) {
        int n = this.actualArgumentPosition(invocationOnMock);
        if (n < 0) {
            return false;
        }
        if (!invocationOnMock.getMethod().isVarArgs()) {
            return invocationOnMock.getArguments().length > n;
        }
        return true;
    }

    public Class returnedTypeOnSignature(InvocationOnMock invocationOnMock) {
        int n = this.actualArgumentPosition(invocationOnMock);
        if (!invocationOnMock.getMethod().isVarArgs()) {
            return invocationOnMock.getMethod().getParameterTypes()[n];
        }
        Class<?>[] classArray = invocationOnMock.getMethod().getParameterTypes();
        int n2 = classArray.length - 1;
        if (n < n2) {
            return classArray[n];
        }
        return classArray[n2].getComponentType();
    }
}

