/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import org.osgi.util.function.Function;
import org.osgi.util.function.Predicate;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Success;

final class PromiseImpl<T>
implements Promise<T> {
    private final ConcurrentLinkedQueue<Runnable> callbacks;
    private final CountDownLatch resolved;
    private T value;
    private Throwable fail;

    PromiseImpl() {
        this.callbacks = new ConcurrentLinkedQueue();
        this.resolved = new CountDownLatch(1);
    }

    PromiseImpl(T t, Throwable throwable) {
        this.value = t;
        this.fail = throwable;
        this.callbacks = new ConcurrentLinkedQueue();
        this.resolved = new CountDownLatch(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolve(T t, Throwable throwable) {
        CountDownLatch countDownLatch = this.resolved;
        synchronized (countDownLatch) {
            if (this.resolved.getCount() == 0L) {
                throw new IllegalStateException("Already resolved");
            }
            this.value = t;
            this.fail = throwable;
            this.resolved.countDown();
        }
        this.notifyCallbacks();
    }

    private void notifyCallbacks() {
        if (this.resolved.getCount() != 0L) {
            return;
        }
        Runnable runnable = this.callbacks.poll();
        while (runnable != null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                Logger.logCallbackException(throwable);
            }
            runnable = this.callbacks.poll();
        }
    }

    @Override
    public boolean isDone() {
        return this.resolved.getCount() == 0L;
    }

    @Override
    public T getValue() throws InvocationTargetException, InterruptedException {
        this.resolved.await();
        if (this.fail == null) {
            return this.value;
        }
        throw new InvocationTargetException(this.fail);
    }

    @Override
    public Throwable getFailure() throws InterruptedException {
        this.resolved.await();
        return this.fail;
    }

    @Override
    public Promise<T> onResolve(Runnable runnable) {
        this.callbacks.offer(runnable);
        this.notifyCallbacks();
        return this;
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success, Failure failure) {
        PromiseImpl<T> promiseImpl = new PromiseImpl<T>();
        this.onResolve(new Then<R>(promiseImpl, success, failure));
        return promiseImpl;
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success) {
        return this.then(success, null);
    }

    Promise<Void> resolveWith(Promise<? extends T> promise) {
        PromiseImpl<Void> promiseImpl = new PromiseImpl<Void>();
        ResolveWith resolveWith = new ResolveWith(promiseImpl);
        promise.then(resolveWith, resolveWith);
        return promiseImpl;
    }

    @Override
    public Promise<T> filter(Predicate<? super T> predicate) {
        return this.then(new Filter<T>(predicate));
    }

    @Override
    public <R> Promise<R> map(Function<? super T, ? extends R> function) {
        return this.then(new Map<T, R>(function));
    }

    @Override
    public <R> Promise<R> flatMap(Function<? super T, Promise<? extends R>> function) {
        return this.then(new FlatMap<T, R>(function));
    }

    @Override
    public Promise<T> recover(Function<Promise<?>, ? extends T> function) {
        PromiseImpl<T> promiseImpl = new PromiseImpl<T>();
        Recover<? extends T> recover = new Recover<T>(promiseImpl, function);
        this.then(recover, recover);
        return promiseImpl;
    }

    @Override
    public Promise<T> recoverWith(Function<Promise<?>, Promise<? extends T>> function) {
        PromiseImpl<T> promiseImpl = new PromiseImpl<T>();
        RecoverWith<? extends T> recoverWith = new RecoverWith<T>(promiseImpl, function);
        this.then(recoverWith, recoverWith);
        return promiseImpl;
    }

    @Override
    public Promise<T> fallbackTo(Promise<? extends T> promise) {
        PromiseImpl<T> promiseImpl = new PromiseImpl<T>();
        FallbackTo<? extends T> fallbackTo = new FallbackTo<T>(promiseImpl, promise);
        this.then(fallbackTo, fallbackTo);
        return promiseImpl;
    }

    static <V> V requireNonNull(V v) {
        if (v != null) {
            return v;
        }
        throw new NullPointerException();
    }

    private static final class Logger {
        private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(PromiseImpl.class.getName());

        private Logger() {
        }

        static void logCallbackException(Throwable throwable) {
            LOGGER.log(Level.WARNING, "Exception from Promise callback", throwable);
        }
    }

    private static final class FallbackTo<T>
    implements Success<T, Void>,
    Failure {
        private final PromiseImpl<T> chained;
        private final Promise<? extends T> fallback;

        FallbackTo(PromiseImpl<T> promiseImpl, Promise<? extends T> promise) {
            this.chained = promiseImpl;
            this.fallback = PromiseImpl.requireNonNull(promise);
        }

        @Override
        public Promise<Void> call(Promise<T> promise) throws Exception {
            T t;
            try {
                t = promise.getValue();
            }
            catch (Throwable throwable) {
                this.chained.resolve(null, throwable);
                return null;
            }
            this.chained.resolve(t, null);
            return null;
        }

        @Override
        public void fail(Promise<?> promise) throws Exception {
            Throwable throwable;
            try {
                throwable = promise.getFailure();
            }
            catch (Throwable throwable2) {
                this.chained.resolve(null, throwable2);
                return;
            }
            this.fallback.onResolve(new Chain<T>(this.chained, this.fallback, throwable));
        }
    }

    private static final class RecoverWith<T>
    implements Success<T, Void>,
    Failure {
        private final PromiseImpl<T> chained;
        private final Function<Promise<?>, Promise<? extends T>> recovery;

        RecoverWith(PromiseImpl<T> promiseImpl, Function<Promise<?>, Promise<? extends T>> function) {
            this.chained = promiseImpl;
            this.recovery = PromiseImpl.requireNonNull(function);
        }

        @Override
        public Promise<Void> call(Promise<T> promise) throws Exception {
            T t;
            try {
                t = promise.getValue();
            }
            catch (Throwable throwable) {
                this.chained.resolve(null, throwable);
                return null;
            }
            this.chained.resolve(t, null);
            return null;
        }

        @Override
        public void fail(Promise<?> promise) throws Exception {
            Throwable throwable;
            Promise<T> promise2;
            try {
                promise2 = this.recovery.apply(promise);
                throwable = promise.getFailure();
            }
            catch (Throwable throwable2) {
                this.chained.resolve(null, throwable2);
                return;
            }
            if (promise2 == null) {
                this.chained.resolve(null, throwable);
            } else {
                promise2.onResolve(new Chain<T>(this.chained, promise2));
            }
        }
    }

    private static final class Recover<T>
    implements Success<T, Void>,
    Failure {
        private final PromiseImpl<T> chained;
        private final Function<Promise<?>, ? extends T> recovery;

        Recover(PromiseImpl<T> promiseImpl, Function<Promise<?>, ? extends T> function) {
            this.chained = promiseImpl;
            this.recovery = PromiseImpl.requireNonNull(function);
        }

        @Override
        public Promise<Void> call(Promise<T> promise) throws Exception {
            T t;
            try {
                t = promise.getValue();
            }
            catch (Throwable throwable) {
                this.chained.resolve(null, throwable);
                return null;
            }
            this.chained.resolve(t, null);
            return null;
        }

        @Override
        public void fail(Promise<?> promise) throws Exception {
            Throwable throwable;
            T t;
            try {
                t = this.recovery.apply(promise);
                throwable = promise.getFailure();
            }
            catch (Throwable throwable2) {
                this.chained.resolve(null, throwable2);
                return;
            }
            if (t == null) {
                this.chained.resolve(null, throwable);
            } else {
                this.chained.resolve(t, null);
            }
        }
    }

    private static final class FlatMap<T, R>
    implements Success<T, R> {
        private final Function<? super T, Promise<? extends R>> mapper;

        FlatMap(Function<? super T, Promise<? extends R>> function) {
            this.mapper = PromiseImpl.requireNonNull(function);
        }

        @Override
        public Promise<R> call(Promise<T> promise) throws Exception {
            return this.mapper.apply(promise.getValue());
        }
    }

    private static final class Map<T, R>
    implements Success<T, R> {
        private final Function<? super T, ? extends R> mapper;

        Map(Function<? super T, ? extends R> function) {
            this.mapper = PromiseImpl.requireNonNull(function);
        }

        @Override
        public Promise<R> call(Promise<T> promise) throws Exception {
            return new PromiseImpl<R>(this.mapper.apply(promise.getValue()), null);
        }
    }

    private static final class Filter<T>
    implements Success<T, T> {
        private final Predicate<? super T> predicate;

        Filter(Predicate<? super T> predicate) {
            this.predicate = PromiseImpl.requireNonNull(predicate);
        }

        @Override
        public Promise<T> call(Promise<T> promise) throws Exception {
            if (this.predicate.test(promise.getValue())) {
                return promise;
            }
            throw new NoSuchElementException();
        }
    }

    private final class ResolveWith
    implements Success<T, Void>,
    Failure {
        private final PromiseImpl<Void> chained;

        ResolveWith(PromiseImpl<Void> promiseImpl2) {
            this.chained = promiseImpl2;
        }

        @Override
        public Promise<Void> call(Promise<T> promise) throws Exception {
            try {
                PromiseImpl.this.resolve(promise.getValue(), null);
            }
            catch (Throwable throwable) {
                this.chained.resolve(null, throwable);
                return null;
            }
            this.chained.resolve(null, null);
            return null;
        }

        @Override
        public void fail(Promise<?> promise) throws Exception {
            try {
                PromiseImpl.this.resolve(null, promise.getFailure());
            }
            catch (Throwable throwable) {
                this.chained.resolve(null, throwable);
                return;
            }
            this.chained.resolve(null, null);
        }
    }

    private static final class Chain<R>
    implements Runnable {
        private final PromiseImpl<R> chained;
        private final Promise<? extends R> promise;
        private final Throwable failure;

        Chain(PromiseImpl<R> promiseImpl, Promise<? extends R> promise) {
            this.chained = promiseImpl;
            this.promise = promise;
            this.failure = null;
        }

        Chain(PromiseImpl<R> promiseImpl, Promise<? extends R> promise, Throwable throwable) {
            this.chained = promiseImpl;
            this.promise = promise;
            this.failure = throwable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable throwable;
            Object t = null;
            boolean bl = Thread.interrupted();
            try {
                throwable = this.promise.getFailure();
                if (throwable == null) {
                    t = this.promise.getValue();
                } else if (this.failure != null) {
                    throwable = this.failure;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            finally {
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
            this.chained.resolve(t, throwable);
        }
    }

    private final class Then<R>
    implements Runnable {
        private final PromiseImpl<R> chained;
        private final Success<T, ? extends R> success;
        private final Failure failure;

        Then(PromiseImpl<R> promiseImpl2, Success<? super T, ? extends R> success, Failure failure) {
            this.chained = promiseImpl2;
            this.success = success;
            this.failure = failure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable throwable;
            boolean bl = Thread.interrupted();
            try {
                throwable = PromiseImpl.this.getFailure();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            finally {
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
            if (throwable != null) {
                if (this.failure != null) {
                    try {
                        this.failure.fail(PromiseImpl.this);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                    }
                }
                this.chained.resolve(null, throwable);
                return;
            }
            Promise<R> promise = null;
            if (this.success != null) {
                try {
                    promise = this.success.call(PromiseImpl.this);
                }
                catch (Throwable throwable4) {
                    this.chained.resolve(null, throwable4);
                    return;
                }
            }
            if (promise == null) {
                this.chained.resolve(null, null);
            } else {
                promise.onResolve(new Chain<R>(this.chained, promise));
            }
        }
    }
}

