/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.AdminPermissionCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.SignerProperty;

public final class AdminPermission
extends BasicPermission {
    static final long serialVersionUID = 307051004521261705L;
    public static final String CLASS = "class";
    public static final String EXECUTE = "execute";
    public static final String EXTENSIONLIFECYCLE = "extensionLifecycle";
    public static final String LIFECYCLE = "lifecycle";
    public static final String LISTENER = "listener";
    public static final String METADATA = "metadata";
    public static final String RESOLVE = "resolve";
    public static final String RESOURCE = "resource";
    public static final String STARTLEVEL = "startlevel";
    public static final String CONTEXT = "context";
    public static final String WEAVE = "weave";
    private static final int ACTION_CLASS = 1;
    private static final int ACTION_EXECUTE = 2;
    private static final int ACTION_LIFECYCLE = 4;
    private static final int ACTION_LISTENER = 8;
    private static final int ACTION_METADATA = 16;
    private static final int ACTION_RESOLVE = 64;
    private static final int ACTION_RESOURCE = 128;
    private static final int ACTION_STARTLEVEL = 256;
    private static final int ACTION_EXTENSIONLIFECYCLE = 512;
    private static final int ACTION_CONTEXT = 1024;
    private static final int ACTION_WEAVE = 2048;
    private static final int ACTION_ALL = 4063;
    static final int ACTION_NONE = 0;
    private volatile String actions = null;
    transient int action_mask;
    transient Filter filter;
    final transient Bundle bundle;
    private volatile transient Map<String, Object> properties;
    private static final ThreadLocal<Bundle> recurse = new ThreadLocal();

    public AdminPermission() {
        this(null, 4063);
    }

    public AdminPermission(String string, String string2) {
        this(AdminPermission.parseFilter(string), AdminPermission.parseActions(string2));
    }

    public AdminPermission(Bundle bundle, String string) {
        super(AdminPermission.createName(bundle));
        this.setTransients(null, AdminPermission.parseActions(string));
        this.bundle = bundle;
    }

    private static String createName(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        StringBuffer stringBuffer = new StringBuffer("(id=");
        stringBuffer.append(bundle.getBundleId());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    AdminPermission(Filter filter, int n) {
        super(filter == null ? "*" : filter.toString());
        this.setTransients(filter, n);
        this.bundle = null;
    }

    private void setTransients(Filter filter, int n) {
        this.filter = filter;
        if (n == 0 || (n & 0xFDF) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
    }

    private static int parseActions(String string) {
        if (string == null || string.equals("*")) {
            return 4063;
        }
        boolean bl = false;
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 4 || cArray[n2 - 4] != 'c' && cArray[n2 - 4] != 'C' || cArray[n2 - 3] != 'l' && cArray[n2 - 3] != 'L' || cArray[n2 - 2] != 'a' && cArray[n2 - 2] != 'A' || cArray[n2 - 1] != 's' && cArray[n2 - 1] != 'S' || cArray[n2] != 's' && cArray[n2] != 'S')) {
                n3 = 5;
                n |= 0x41;
            } else if (!(n2 < 6 || cArray[n2 - 6] != 'e' && cArray[n2 - 6] != 'E' || cArray[n2 - 5] != 'x' && cArray[n2 - 5] != 'X' || cArray[n2 - 4] != 'e' && cArray[n2 - 4] != 'E' || cArray[n2 - 3] != 'c' && cArray[n2 - 3] != 'C' || cArray[n2 - 2] != 'u' && cArray[n2 - 2] != 'U' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 7;
                n |= 0x42;
            } else if (!(n2 < 17 || cArray[n2 - 17] != 'e' && cArray[n2 - 17] != 'E' || cArray[n2 - 16] != 'x' && cArray[n2 - 16] != 'X' || cArray[n2 - 15] != 't' && cArray[n2 - 15] != 'T' || cArray[n2 - 14] != 'e' && cArray[n2 - 14] != 'E' || cArray[n2 - 13] != 'n' && cArray[n2 - 13] != 'N' || cArray[n2 - 12] != 's' && cArray[n2 - 12] != 'S' || cArray[n2 - 11] != 'i' && cArray[n2 - 11] != 'I' || cArray[n2 - 10] != 'o' && cArray[n2 - 10] != 'O' || cArray[n2 - 9] != 'n' && cArray[n2 - 9] != 'N' || cArray[n2 - 8] != 'l' && cArray[n2 - 8] != 'L' || cArray[n2 - 7] != 'i' && cArray[n2 - 7] != 'I' || cArray[n2 - 6] != 'f' && cArray[n2 - 6] != 'F' || cArray[n2 - 5] != 'e' && cArray[n2 - 5] != 'E' || cArray[n2 - 4] != 'c' && cArray[n2 - 4] != 'C' || cArray[n2 - 3] != 'y' && cArray[n2 - 3] != 'Y' || cArray[n2 - 2] != 'c' && cArray[n2 - 2] != 'C' || cArray[n2 - 1] != 'l' && cArray[n2 - 1] != 'L' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 18;
                n |= 0x200;
            } else if (!(n2 < 8 || cArray[n2 - 8] != 'l' && cArray[n2 - 8] != 'L' || cArray[n2 - 7] != 'i' && cArray[n2 - 7] != 'I' || cArray[n2 - 6] != 'f' && cArray[n2 - 6] != 'F' || cArray[n2 - 5] != 'e' && cArray[n2 - 5] != 'E' || cArray[n2 - 4] != 'c' && cArray[n2 - 4] != 'C' || cArray[n2 - 3] != 'y' && cArray[n2 - 3] != 'Y' || cArray[n2 - 2] != 'c' && cArray[n2 - 2] != 'C' || cArray[n2 - 1] != 'l' && cArray[n2 - 1] != 'L' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 9;
                n |= 4;
            } else if (!(n2 < 7 || cArray[n2 - 7] != 'l' && cArray[n2 - 7] != 'L' || cArray[n2 - 6] != 'i' && cArray[n2 - 6] != 'I' || cArray[n2 - 5] != 's' && cArray[n2 - 5] != 'S' || cArray[n2 - 4] != 't' && cArray[n2 - 4] != 'T' || cArray[n2 - 3] != 'e' && cArray[n2 - 3] != 'E' || cArray[n2 - 2] != 'n' && cArray[n2 - 2] != 'N' || cArray[n2 - 1] != 'e' && cArray[n2 - 1] != 'E' || cArray[n2] != 'r' && cArray[n2] != 'R')) {
                n3 = 8;
                n |= 8;
            } else if (!(n2 < 7 || cArray[n2 - 7] != 'm' && cArray[n2 - 7] != 'M' || cArray[n2 - 6] != 'e' && cArray[n2 - 6] != 'E' || cArray[n2 - 5] != 't' && cArray[n2 - 5] != 'T' || cArray[n2 - 4] != 'a' && cArray[n2 - 4] != 'A' || cArray[n2 - 3] != 'd' && cArray[n2 - 3] != 'D' || cArray[n2 - 2] != 'a' && cArray[n2 - 2] != 'A' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'a' && cArray[n2] != 'A')) {
                n3 = 8;
                n |= 0x10;
            } else if (!(n2 < 6 || cArray[n2 - 6] != 'r' && cArray[n2 - 6] != 'R' || cArray[n2 - 5] != 'e' && cArray[n2 - 5] != 'E' || cArray[n2 - 4] != 's' && cArray[n2 - 4] != 'S' || cArray[n2 - 3] != 'o' && cArray[n2 - 3] != 'O' || cArray[n2 - 2] != 'l' && cArray[n2 - 2] != 'L' || cArray[n2 - 1] != 'v' && cArray[n2 - 1] != 'V' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 7;
                n |= 0x40;
            } else if (!(n2 < 7 || cArray[n2 - 7] != 'r' && cArray[n2 - 7] != 'R' || cArray[n2 - 6] != 'e' && cArray[n2 - 6] != 'E' || cArray[n2 - 5] != 's' && cArray[n2 - 5] != 'S' || cArray[n2 - 4] != 'o' && cArray[n2 - 4] != 'O' || cArray[n2 - 3] != 'u' && cArray[n2 - 3] != 'U' || cArray[n2 - 2] != 'r' && cArray[n2 - 2] != 'R' || cArray[n2 - 1] != 'c' && cArray[n2 - 1] != 'C' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 8;
                n |= 0xC0;
            } else if (!(n2 < 9 || cArray[n2 - 9] != 's' && cArray[n2 - 9] != 'S' || cArray[n2 - 8] != 't' && cArray[n2 - 8] != 'T' || cArray[n2 - 7] != 'a' && cArray[n2 - 7] != 'A' || cArray[n2 - 6] != 'r' && cArray[n2 - 6] != 'R' || cArray[n2 - 5] != 't' && cArray[n2 - 5] != 'T' || cArray[n2 - 4] != 'l' && cArray[n2 - 4] != 'L' || cArray[n2 - 3] != 'e' && cArray[n2 - 3] != 'E' || cArray[n2 - 2] != 'v' && cArray[n2 - 2] != 'V' || cArray[n2 - 1] != 'e' && cArray[n2 - 1] != 'E' || cArray[n2] != 'l' && cArray[n2] != 'L')) {
                n3 = 10;
                n |= 0x100;
            } else if (!(n2 < 6 || cArray[n2 - 6] != 'c' && cArray[n2 - 6] != 'C' || cArray[n2 - 5] != 'o' && cArray[n2 - 5] != 'O' || cArray[n2 - 4] != 'n' && cArray[n2 - 4] != 'N' || cArray[n2 - 3] != 't' && cArray[n2 - 3] != 'T' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 'x' && cArray[n2 - 1] != 'X' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 7;
                n |= 0x400;
            } else if (!(n2 < 4 || cArray[n2 - 4] != 'w' && cArray[n2 - 4] != 'W' || cArray[n2 - 3] != 'e' && cArray[n2 - 3] != 'E' || cArray[n2 - 2] != 'a' && cArray[n2 - 2] != 'A' || cArray[n2 - 1] != 'v' && cArray[n2 - 1] != 'V' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 5;
                n |= 0x800;
            } else if (n2 >= 0 && cArray[n2] == '*') {
                n3 = 1;
                n |= 0xFDF;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        if (bl) {
            throw new IllegalArgumentException("invalid permission: " + string);
        }
        return n;
    }

    private static Filter parseFilter(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equals("*")) {
            return null;
        }
        try {
            return FrameworkUtil.createFilter(string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid filter");
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            return false;
        }
        AdminPermission adminPermission = (AdminPermission)permission;
        if (this.bundle != null) {
            return false;
        }
        if (adminPermission.filter != null) {
            return false;
        }
        return this.implies0(adminPermission, 0);
    }

    boolean implies0(AdminPermission adminPermission, int n) {
        int n2 = adminPermission.action_mask;
        if (((n |= this.action_mask) & n2) != n2) {
            return false;
        }
        Filter filter = this.filter;
        if (filter == null) {
            return true;
        }
        if (adminPermission.bundle == null) {
            return false;
        }
        Map<String, Object> map = adminPermission.getProperties();
        if (map == null) {
            return true;
        }
        return filter.matches(map);
    }

    @Override
    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.action_mask;
            if ((n & 1) == 1) {
                stringBuffer.append(CLASS);
                stringBuffer.append(',');
            }
            if ((n & 2) == 2) {
                stringBuffer.append(EXECUTE);
                stringBuffer.append(',');
            }
            if ((n & 0x200) == 512) {
                stringBuffer.append(EXTENSIONLIFECYCLE);
                stringBuffer.append(',');
            }
            if ((n & 4) == 4) {
                stringBuffer.append(LIFECYCLE);
                stringBuffer.append(',');
            }
            if ((n & 8) == 8) {
                stringBuffer.append(LISTENER);
                stringBuffer.append(',');
            }
            if ((n & 0x10) == 16) {
                stringBuffer.append(METADATA);
                stringBuffer.append(',');
            }
            if ((n & 0x40) == 64) {
                stringBuffer.append(RESOLVE);
                stringBuffer.append(',');
            }
            if ((n & 0x80) == 128) {
                stringBuffer.append(RESOURCE);
                stringBuffer.append(',');
            }
            if ((n & 0x100) == 256) {
                stringBuffer.append(STARTLEVEL);
                stringBuffer.append(',');
            }
            if ((n & 0x400) == 1024) {
                stringBuffer.append(CONTEXT);
                stringBuffer.append(',');
            }
            if ((n & 0x800) == 2048) {
                stringBuffer.append(WEAVE);
                stringBuffer.append(',');
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new AdminPermissionCollection();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdminPermission)) {
            return false;
        }
        AdminPermission adminPermission = (AdminPermission)object;
        return this.action_mask == adminPermission.action_mask && (this.bundle == adminPermission.bundle || this.bundle != null && this.bundle.equals(adminPermission.bundle)) && (this.filter == null ? adminPermission.filter == null : this.filter.equals(adminPermission.filter));
    }

    @Override
    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        if (this.bundle != null) {
            n = 31 * n + this.bundle.hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.bundle != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(AdminPermission.parseFilter(this.getName()), AdminPermission.parseActions(this.actions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getProperties() {
        Map<String, Object> map = this.properties;
        if (map != null) {
            return map;
        }
        Bundle bundle = recurse.get();
        if (bundle == this.bundle) {
            return null;
        }
        recurse.set(this.bundle);
        try {
            final HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SignerProperty signerProperty;
                    hashMap.put("id", new Long(AdminPermission.this.bundle.getBundleId()));
                    hashMap.put("location", AdminPermission.this.bundle.getLocation());
                    String string = AdminPermission.this.bundle.getSymbolicName();
                    if (string != null) {
                        hashMap.put("name", string);
                    }
                    if ((signerProperty = new SignerProperty(AdminPermission.this.bundle)).isBundleSigned()) {
                        hashMap.put("signer", signerProperty);
                    }
                    return null;
                }
            });
            this.properties = hashMap;
            HashMap<String, Object> hashMap2 = this.properties;
            return hashMap2;
        }
        finally {
            recurse.set(null);
        }
    }
}

