/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.aelfred;

import com.icl.saxon.aelfred.SAXDriver;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.SAXException;

final class XmlParser {
    private static final boolean USE_CHEATS = true;
    private static final int DEFAULT_ATTR_COUNT = 23;
    public static final int CONTENT_UNDECLARED = 0;
    public static final int CONTENT_ANY = 1;
    public static final int CONTENT_EMPTY = 2;
    public static final int CONTENT_MIXED = 3;
    public static final int CONTENT_ELEMENTS = 4;
    public static final int ENTITY_UNDECLARED = 0;
    public static final int ENTITY_INTERNAL = 1;
    public static final int ENTITY_NDATA = 2;
    public static final int ENTITY_TEXT = 3;
    public static final int ATTRIBUTE_UNDECLARED = 0;
    public static final int ATTRIBUTE_CDATA = 1;
    public static final int ATTRIBUTE_ID = 2;
    public static final int ATTRIBUTE_IDREF = 3;
    public static final int ATTRIBUTE_IDREFS = 4;
    public static final int ATTRIBUTE_ENTITY = 5;
    public static final int ATTRIBUTE_ENTITIES = 6;
    public static final int ATTRIBUTE_NMTOKEN = 7;
    public static final int ATTRIBUTE_NMTOKENS = 8;
    public static final int ATTRIBUTE_ENUMERATED = 9;
    public static final int ATTRIBUTE_NOTATION = 10;
    private static Hashtable attributeTypeHash = new Hashtable(13);
    private static final int ENCODING_EXTERNAL = 0;
    private static final int ENCODING_UTF_8 = 1;
    private static final int ENCODING_ISO_8859_1 = 2;
    private static final int ENCODING_UCS_2_12 = 3;
    private static final int ENCODING_UCS_2_21 = 4;
    private static final int ENCODING_UCS_4_1234 = 5;
    private static final int ENCODING_UCS_4_4321 = 6;
    private static final int ENCODING_UCS_4_2143 = 7;
    private static final int ENCODING_UCS_4_3412 = 8;
    private static final int ENCODING_ASCII = 9;
    public static final int ATTRIBUTE_DEFAULT_UNDECLARED = 30;
    public static final int ATTRIBUTE_DEFAULT_SPECIFIED = 31;
    public static final int ATTRIBUTE_DEFAULT_IMPLIED = 32;
    public static final int ATTRIBUTE_DEFAULT_REQUIRED = 33;
    public static final int ATTRIBUTE_DEFAULT_FIXED = 34;
    private static final int INPUT_NONE = 0;
    private static final int INPUT_INTERNAL = 1;
    private static final int INPUT_STREAM = 3;
    private static final int INPUT_BUFFER = 4;
    private static final int INPUT_READER = 5;
    private static final int LIT_ENTITY_REF = 2;
    private static final int LIT_NORMALIZE = 4;
    private static final int LIT_ATTRIBUTE = 8;
    private static final int LIT_DISABLE_PE = 16;
    private static final int LIT_DISABLE_CREF = 32;
    private static final int LIT_DISABLE_EREF = 64;
    private static final int LIT_ENTITY_CHECK = 128;
    private static final int LIT_PUBID = 256;
    private static final int CONTEXT_NORMAL = 0;
    private static final int CONTEXT_LITERAL = 1;
    private SAXDriver handler;
    private Reader reader;
    private InputStream is;
    private int line;
    private int column;
    private int sourceType;
    private Stack inputStack;
    private URLConnection externalEntity;
    private int encoding;
    private int currentByteCount;
    private char[] readBuffer;
    private int readBufferPos;
    private int readBufferLength;
    private int readBufferOverflow;
    private static final int READ_BUFFER_MAX = 16384;
    private byte[] rawReadBuffer;
    private static int DATA_BUFFER_INITIAL;
    private char[] dataBuffer;
    private int dataBufferPos;
    private static int NAME_BUFFER_INITIAL;
    private char[] nameBuffer;
    private int nameBufferPos;
    private Hashtable elementInfo;
    private Hashtable entityInfo;
    private Hashtable notationInfo;
    private String currentElement;
    private int currentElementContent;
    private String basePublicId;
    private String baseURI;
    private int baseEncoding;
    private Reader baseReader;
    private InputStream baseInputStream;
    private char[] baseInputBuffer;
    private int baseInputBufferStart;
    private int baseInputBufferLength;
    private Stack entityStack;
    private boolean inLiteral;
    private boolean expandPE;
    private boolean peIsError;
    private static final int SYMBOL_TABLE_LENGTH = 1087;
    private Object[][] symbolTable;
    private String[] tagAttributes;
    private int tagAttributePos;
    private boolean sawCR;
    private boolean inCDATA;

    XmlParser() {
        this.cleanupVariables();
    }

    void setHandler(SAXDriver sAXDriver) {
        this.handler = sAXDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doParse(String string, String string2, Reader reader, InputStream inputStream, String string3) throws Exception {
        if (this.handler == null) {
            throw new IllegalStateException("no callback handler");
        }
        this.basePublicId = string2;
        this.baseURI = string;
        this.baseReader = reader;
        this.baseInputStream = inputStream;
        this.initializeVariables();
        this.setInternalEntity("amp", "&#38;");
        this.setInternalEntity("lt", "&#60;");
        this.setInternalEntity("gt", "&#62;");
        this.setInternalEntity("apos", "&#39;");
        this.setInternalEntity("quot", "&#34;");
        this.handler.startDocument();
        this.pushURL("[document]", this.basePublicId, this.baseURI, this.baseReader, this.baseInputStream, string3, false);
        try {
            this.parseDocument();
            this.handler.endDocument();
        }
        finally {
            if (this.baseReader != null) {
                try {
                    this.baseReader.close();
                }
                catch (IOException iOException) {}
            }
            if (this.baseInputStream != null) {
                try {
                    this.baseInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            this.cleanupVariables();
        }
    }

    private void error(String string, String string2, String string3) throws SAXException {
        if (string2 != null) {
            string = string + " (found \"" + string2 + "\")";
        }
        if (string3 != null) {
            string = string + " (expected \"" + string3 + "\")";
        }
        String string4 = null;
        if (this.externalEntity != null) {
            string4 = this.externalEntity.getURL().toString();
        }
        this.handler.error(string, string4, this.line, this.column);
        throw new SAXException(string);
    }

    private void error(String string, char c, String string2) throws SAXException {
        this.error(string, new Character(c).toString(), string2);
    }

    private void error(String string) throws SAXException {
        this.error(string, null, null);
    }

    private void parseDocument() throws Exception {
        try {
            this.parseProlog();
            this.require('<', "document prolog");
            this.parseElement();
        }
        catch (EOFException eOFException) {
            this.error("premature end of file", "[EOF]", null);
        }
        try {
            this.parseMisc();
            char c = this.readCh();
            this.error("unexpected characters after document end", c, null);
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void parseComment() throws Exception {
        boolean bl = this.expandPE;
        this.expandPE = false;
        this.parseUntil("--");
        this.require('>', "-- in comment");
        this.expandPE = bl;
        this.handler.comment(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
    }

    private void parsePI() throws SAXException, IOException {
        boolean bl = this.expandPE;
        this.expandPE = false;
        String string = this.readNmtoken(true);
        if ("xml".equalsIgnoreCase(string)) {
            this.error("Illegal processing instruction target", string, null);
        }
        if (!this.tryRead("?>")) {
            this.requireWhitespace();
            this.parseUntil("?>");
        }
        this.expandPE = bl;
        this.handler.processingInstruction(string, this.dataBufferToString());
    }

    private void parseCDSect() throws Exception {
        this.parseUntil("]]>");
        this.dataBufferFlush();
    }

    private void parseProlog() throws Exception {
        this.parseMisc();
        if (this.tryRead("<!DOCTYPE")) {
            this.parseDoctypedecl();
            this.parseMisc();
        }
    }

    private String parseXMLDecl(boolean bl) throws SAXException, IOException {
        String string = null;
        String string2 = null;
        int n = 112;
        this.require("version", "XML declaration");
        this.parseEq();
        String string3 = this.readLiteral(n);
        if (!string3.equals("1.0")) {
            this.error("unsupported XML version", string3, "1.0");
        }
        boolean bl2 = this.tryWhitespace();
        if (this.tryRead("encoding")) {
            if (!bl2) {
                this.error("whitespace required before 'encoding='");
            }
            this.parseEq();
            string = this.readLiteral(n);
            if (!bl) {
                this.setupDecoding(string);
            }
        }
        if (string != null) {
            bl2 = this.tryWhitespace();
        }
        if (this.tryRead("standalone")) {
            if (!bl2) {
                this.error("whitespace required before 'standalone='");
            }
            this.parseEq();
            string2 = this.readLiteral(n);
            if (!"yes".equals(string2) && !"no".equals(string2)) {
                this.error("standalone flag must be 'yes' or 'no'");
            }
        }
        this.skipWhitespace();
        this.require("?>", "XML declaration");
        return string;
    }

    private String parseTextDecl(boolean bl) throws SAXException, IOException {
        String string = null;
        int n = 112;
        if (this.tryRead("version")) {
            this.parseEq();
            String string2 = this.readLiteral(n);
            if (!string2.equals("1.0")) {
                this.error("unsupported XML version", string2, "1.0");
            }
            this.requireWhitespace();
        }
        this.require("encoding", "XML text declaration");
        this.parseEq();
        string = this.readLiteral(n);
        if (!bl) {
            this.setupDecoding(string);
        }
        this.skipWhitespace();
        this.require("?>", "XML text declaration");
        return string;
    }

    private void setupDecoding(String string) throws SAXException, IOException {
        string = string.toUpperCase();
        if (this.encoding == 1 || this.encoding == 0) {
            if (string.equals("ISO-8859-1") || string.equals("8859_1") || string.equals("ISO8859_1")) {
                this.encoding = 2;
                return;
            }
            if (string.equals("US-ASCII") || string.equals("ASCII")) {
                this.encoding = 9;
                return;
            }
            if (string.equals("UTF-8") || string.equals("UTF8")) {
                this.encoding = 1;
                return;
            }
            if (this.encoding != 0) {
                throw new EncodingException(string);
            }
        }
        if (this.encoding == 3 || this.encoding == 4) {
            if (!(string.equals("ISO-10646-UCS-2") || string.equals("UTF-16") || string.equals("UTF-16BE") || string.equals("UTF-16LE"))) {
                this.error("unsupported Unicode encoding", string, "UTF-16");
            }
            return;
        }
        if (this.encoding == 5 || this.encoding == 6 || this.encoding == 7 || this.encoding == 8) {
            if (!string.equals("ISO-10646-UCS-4")) {
                this.error("unsupported 32-bit encoding", string, "ISO-10646-UCS-4");
            }
            return;
        }
        if (string.equals("UTF-16BE")) {
            this.encoding = 3;
            return;
        }
        if (string.equals("UTF-16LE")) {
            this.encoding = 4;
            return;
        }
        if (string.equals("UTF-16") || string.equals("ISO-10646-UCS-2")) {
            string = "Unicode";
        }
        this.reader = new InputStreamReader(this.is, string);
        this.sourceType = 5;
    }

    private void parseMisc() throws Exception {
        while (true) {
            this.skipWhitespace();
            if (this.tryRead("<?")) {
                this.parsePI();
                continue;
            }
            if (!this.tryRead("<!--")) break;
            this.parseComment();
        }
    }

    private void parseDoctypedecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.skipWhitespace();
        String[] stringArray = this.readExternalIds(false);
        this.handler.doctypeDecl(string, stringArray[0], stringArray[1]);
        this.skipWhitespace();
        if (this.tryRead('[')) {
            while (true) {
                this.expandPE = true;
                this.skipWhitespace();
                this.expandPE = false;
                if (this.tryRead(']')) break;
                this.expandPE = true;
                this.peIsError = true;
                this.parseMarkupdecl();
                this.expandPE = false;
                this.peIsError = false;
            }
        }
        if (stringArray[1] != null) {
            this.pushURL("[external subset]", stringArray[0], stringArray[1], null, null, null, false);
            while (true) {
                this.expandPE = true;
                this.skipWhitespace();
                this.expandPE = false;
                if (!this.tryRead('>')) {
                    this.expandPE = true;
                    this.parseMarkupdecl();
                    this.expandPE = false;
                    continue;
                }
                break;
            }
        } else {
            this.skipWhitespace();
            this.require('>', "internal DTD subset");
        }
        this.handler.endDoctype();
        this.expandPE = false;
    }

    private void parseMarkupdecl() throws Exception {
        if (this.tryRead("<!ELEMENT")) {
            this.parseElementdecl();
        } else if (this.tryRead("<!ATTLIST")) {
            this.parseAttlistDecl();
        } else if (this.tryRead("<!ENTITY")) {
            this.parseEntityDecl();
        } else if (this.tryRead("<!NOTATION")) {
            this.parseNotationDecl();
        } else if (this.tryRead("<?")) {
            this.parsePI();
        } else if (this.tryRead("<!--")) {
            this.parseComment();
        } else if (this.tryRead("<![")) {
            if (this.inputStack.size() > 0) {
                this.parseConditionalSect();
            } else {
                this.error("conditional sections illegal in internal subset");
            }
        } else {
            this.error("expected markup declaration");
        }
    }

    private void parseElement() throws Exception {
        String string;
        int n = this.currentElementContent;
        String string2 = this.currentElement;
        this.tagAttributePos = 0;
        this.currentElement = string = this.readNmtoken(true);
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        this.currentElementContent = this.getContentType(objectArray, 1);
        boolean bl = this.tryWhitespace();
        char c = this.readCh();
        while (c != '/' && c != '>') {
            this.unread(c);
            if (!bl) {
                this.error("need whitespace between attributes");
            }
            this.parseAttribute(string);
            bl = this.tryWhitespace();
            c = this.readCh();
        }
        Enumeration enumeration = this.declaredAttributes(objectArray);
        if (enumeration != null) {
            block5: while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                for (int i = 0; i < this.tagAttributePos; ++i) {
                    if (this.tagAttributes[i] == string3) continue block5;
                }
                String string4 = this.getAttributeExpandedValue(string, string3);
                if (string4 == null) continue;
                this.handler.attribute(string3, string4, false);
            }
        }
        switch (c) {
            case '>': {
                this.handler.startElement(string);
                this.parseContent();
                break;
            }
            case '/': {
                this.require('>', "empty element tag");
                this.handler.startElement(string);
                this.handler.endElement(string);
            }
        }
        this.currentElement = string2;
        this.currentElementContent = n;
    }

    private void parseAttribute(String string) throws Exception {
        int n = 10;
        String string2 = this.readNmtoken(true);
        int n2 = this.getAttributeType(string, string2);
        this.parseEq();
        String string3 = n2 == 1 || n2 == 0 ? this.readLiteral(n) : this.readLiteral(n | 4);
        for (int i = 0; i < this.tagAttributePos; ++i) {
            if (!string2.equals(this.tagAttributes[i])) continue;
            this.error("duplicate attribute", string2, null);
        }
        this.handler.attribute(string2, string3, true);
        this.dataBufferPos = 0;
        if (this.tagAttributePos == this.tagAttributes.length) {
            String[] stringArray = new String[this.tagAttributes.length * 2];
            System.arraycopy(this.tagAttributes, 0, stringArray, 0, this.tagAttributePos);
            this.tagAttributes = stringArray;
        }
        this.tagAttributes[this.tagAttributePos++] = string2;
    }

    private void parseEq() throws SAXException, IOException {
        this.skipWhitespace();
        this.require('=', "attribute name");
        this.skipWhitespace();
    }

    private void parseETag() throws Exception {
        this.require(this.currentElement, "element end tag");
        this.skipWhitespace();
        this.require('>', "name in end tag");
        this.handler.endElement(this.currentElement);
    }

    private void parseContent() throws Exception {
        while (true) {
            this.parseCharData();
            char c = this.readCh();
            block0 : switch (c) {
                case '&': {
                    c = this.readCh();
                    if (c == '#') {
                        this.parseCharRef();
                        break;
                    }
                    this.unread(c);
                    this.parseEntityRef(true);
                    break;
                }
                case '<': {
                    this.dataBufferFlush();
                    c = this.readCh();
                    switch (c) {
                        case '!': {
                            c = this.readCh();
                            switch (c) {
                                case '-': {
                                    this.require('-', "start of comment");
                                    this.parseComment();
                                    break block0;
                                }
                                case '[': {
                                    this.require("CDATA[", "CDATA section");
                                    this.handler.startCDATA();
                                    this.inCDATA = true;
                                    this.parseCDSect();
                                    this.inCDATA = false;
                                    this.handler.endCDATA();
                                    break block0;
                                }
                            }
                            this.error("expected comment or CDATA section", c, null);
                            break block0;
                        }
                        case '?': {
                            this.parsePI();
                            break block0;
                        }
                        case '/': {
                            this.parseETag();
                            return;
                        }
                    }
                    this.unread(c);
                    this.parseElement();
                }
            }
        }
    }

    private void parseElementdecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.requireWhitespace();
        this.parseContentspec(string);
        this.skipWhitespace();
        this.require('>', "element declaration");
    }

    private void parseContentspec(String string) throws Exception {
        if (this.tryRead("EMPTY")) {
            this.setElement(string, 2, null, null);
            return;
        }
        if (this.tryRead("ANY")) {
            this.setElement(string, 1, null, null);
            return;
        }
        this.require('(', "element name");
        this.dataBufferAppend('(');
        this.skipWhitespace();
        if (this.tryRead("#PCDATA")) {
            this.dataBufferAppend("#PCDATA");
            this.parseMixed();
            this.setElement(string, 3, this.dataBufferToString(), null);
        } else {
            this.parseElements();
            this.setElement(string, 4, this.dataBufferToString(), null);
        }
    }

    private void parseElements() throws Exception {
        char c;
        this.skipWhitespace();
        this.parseCp();
        this.skipWhitespace();
        char c2 = this.readCh();
        switch (c2) {
            case ')': {
                this.dataBufferAppend(')');
                c2 = this.readCh();
                switch (c2) {
                    case '*': 
                    case '+': 
                    case '?': {
                        this.dataBufferAppend(c2);
                        break;
                    }
                    default: {
                        this.unread(c2);
                    }
                }
                return;
            }
            case ',': 
            case '|': {
                c = c2;
                this.dataBufferAppend(c2);
                break;
            }
            default: {
                this.error("bad separator in content model", c2, null);
                return;
            }
        }
        while (true) {
            this.skipWhitespace();
            this.parseCp();
            this.skipWhitespace();
            c2 = this.readCh();
            if (c2 == ')') break;
            if (c2 != c) {
                this.error("bad separator in content model", c2, null);
                return;
            }
            this.dataBufferAppend(c2);
        }
        this.dataBufferAppend(')');
        c2 = this.readCh();
        switch (c2) {
            case '*': 
            case '+': 
            case '?': {
                this.dataBufferAppend(c2);
                return;
            }
        }
        this.unread(c2);
    }

    private void parseCp() throws Exception {
        if (this.tryRead('(')) {
            this.dataBufferAppend('(');
            this.parseElements();
        } else {
            this.dataBufferAppend(this.readNmtoken(true));
            char c = this.readCh();
            switch (c) {
                case '*': 
                case '+': 
                case '?': {
                    this.dataBufferAppend(c);
                    break;
                }
                default: {
                    this.unread(c);
                }
            }
        }
    }

    private void parseMixed() throws Exception {
        this.skipWhitespace();
        if (this.tryRead(')')) {
            this.dataBufferAppend(")*");
            this.tryRead('*');
            return;
        }
        this.skipWhitespace();
        while (!this.tryRead(")*")) {
            this.require('|', "alternative");
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        this.dataBufferAppend(")*");
    }

    private void parseAttlistDecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        boolean bl = this.tryWhitespace();
        while (!this.tryRead('>')) {
            if (!bl) {
                this.error("whitespace required before attribute definition");
            }
            this.parseAttDef(string);
            bl = this.tryWhitespace();
        }
    }

    private void parseAttDef(String string) throws Exception {
        String string2 = null;
        String string3 = this.readNmtoken(true);
        this.requireWhitespace();
        int n = this.readAttType();
        if (n == 9 || n == 10) {
            string2 = this.dataBufferToString();
        }
        this.requireWhitespace();
        this.parseDefault(string, string3, n, string2);
    }

    private int readAttType() throws Exception {
        Integer n;
        if (this.tryRead('(')) {
            this.parseEnumeration(false);
            return 9;
        }
        String string = this.readNmtoken(true);
        if (string.equals("NOTATION")) {
            this.parseNotationType();
        }
        if ((n = (Integer)attributeTypeHash.get(string)) == null) {
            this.error("illegal attribute type", string, null);
            return 0;
        }
        return n;
    }

    private void parseEnumeration(boolean bl) throws Exception {
        this.dataBufferAppend('(');
        this.skipWhitespace();
        this.dataBufferAppend(this.readNmtoken(bl));
        this.skipWhitespace();
        while (!this.tryRead(')')) {
            this.require('|', "enumeration value");
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(bl));
            this.skipWhitespace();
        }
        this.dataBufferAppend(')');
    }

    private void parseNotationType() throws Exception {
        this.requireWhitespace();
        this.require('(', "NOTATION");
        this.parseEnumeration(true);
    }

    private void parseDefault(String string, String string2, int n, String string3) throws Exception {
        int n2 = 31;
        String string4 = null;
        int n3 = 184;
        if (this.tryRead('#')) {
            if (this.tryRead("FIXED")) {
                n2 = 34;
                this.requireWhitespace();
                string4 = this.readLiteral(n3);
            } else if (this.tryRead("REQUIRED")) {
                n2 = 33;
            } else if (this.tryRead("IMPLIED")) {
                n2 = 32;
            } else {
                this.error("illegal keyword for attribute default value");
            }
        } else {
            string4 = this.readLiteral(n3);
        }
        this.setAttribute(string, string2, n, string3, string4, n2);
    }

    private void parseConditionalSect() throws Exception {
        this.skipWhitespace();
        if (this.tryRead("INCLUDE")) {
            this.skipWhitespace();
            this.require('[', "INCLUDE");
            this.skipWhitespace();
            while (!this.tryRead("]]>")) {
                this.parseMarkupdecl();
                this.skipWhitespace();
            }
        } else if (this.tryRead("IGNORE")) {
            this.skipWhitespace();
            this.require('[', "IGNORE");
            boolean bl = true;
            this.expandPE = false;
            int n = 1;
            while (n > 0) {
                char c = this.readCh();
                switch (c) {
                    case '<': {
                        if (this.tryRead("![")) {
                            ++n;
                        }
                    }
                    case ']': {
                        if (!this.tryRead("]>")) break;
                        --n;
                    }
                }
            }
            this.expandPE = true;
        } else {
            this.error("conditional section must begin with INCLUDE or IGNORE");
        }
    }

    private void parseCharRef() throws SAXException, IOException {
        int n = 0;
        if (this.tryRead('x')) {
            block8: while (true) {
                char c = this.readCh();
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        n *= 16;
                        n += Integer.parseInt(new Character(c).toString(), 16);
                        continue block8;
                    }
                    case ';': {
                        break block8;
                    }
                    default: {
                        this.error("illegal character in character reference", c, null);
                        break block8;
                    }
                }
                break;
            }
        } else {
            block9: while (true) {
                char c = this.readCh();
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        n *= 10;
                        n += Integer.parseInt(new Character(c).toString(), 10);
                        continue block9;
                    }
                    case ';': {
                        break block9;
                    }
                    default: {
                        this.error("illegal character in character reference", c, null);
                        break block9;
                    }
                }
                break;
            }
        }
        if (n < 32 && n != 10 && n != 9 && n != 13 || n >= 55296 && n <= 57343 || n == 65534 || n == 65535 || n > 0x10FFFF) {
            this.error("illegal XML character reference U+" + Integer.toHexString(n));
        }
        if (n <= 65535) {
            this.dataBufferAppend((char)n);
        } else if (n <= 0x10FFFF) {
            this.dataBufferAppend((char)(0xD800 | (n -= 65536) >> 10));
            this.dataBufferAppend((char)(0xDC00 | n & 0x3FF));
        } else {
            this.error("character reference " + n + " is too large for UTF-16", new Integer(n).toString(), null);
        }
    }

    private void parseEntityRef(boolean bl) throws SAXException, IOException {
        String string = this.readNmtoken(true);
        this.require(';', "entity reference");
        switch (this.getEntityType(string)) {
            case 0: {
                this.error("reference to undeclared entity", string, null);
                break;
            }
            case 1: {
                this.pushString(string, this.getEntityValue(string));
                break;
            }
            case 3: {
                if (bl) {
                    this.pushURL(string, this.getEntityPublicId(string), this.getEntitySystemId(string), null, null, null, true);
                    break;
                }
                this.error("reference to external entity in attribute value.", string, null);
                break;
            }
            case 2: {
                if (bl) {
                    this.error("unparsed entity reference in content", string, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", string, null);
            }
        }
    }

    private void parsePEReference() throws SAXException, IOException {
        String string = "%" + this.readNmtoken(true);
        this.require(';', "parameter entity reference");
        switch (this.getEntityType(string)) {
            case 0: {
                break;
            }
            case 1: {
                if (this.inLiteral) {
                    this.pushString(string, this.getEntityValue(string));
                    break;
                }
                this.pushString(string, ' ' + this.getEntityValue(string) + ' ');
                break;
            }
            case 3: {
                if (!this.inLiteral) {
                    this.pushString(null, " ");
                }
                this.pushURL(string, this.getEntityPublicId(string), this.getEntitySystemId(string), null, null, null, true);
                if (this.inLiteral) break;
                this.pushString(null, " ");
            }
        }
    }

    private void parseEntityDecl() throws Exception {
        boolean bl = false;
        this.expandPE = false;
        this.requireWhitespace();
        if (this.tryRead('%')) {
            bl = true;
            this.requireWhitespace();
        }
        this.expandPE = true;
        String string = this.readNmtoken(true);
        if (bl) {
            string = "%" + string;
        }
        this.requireWhitespace();
        char c = this.readCh();
        this.unread(c);
        if (c == '\"' || c == '\'') {
            String string2 = this.readLiteral(0);
            this.setInternalEntity(string, string2);
        } else {
            String[] stringArray = this.readExternalIds(false);
            if (stringArray[1] == null) {
                this.error("system identifer missing", string, null);
            }
            boolean bl2 = this.tryWhitespace();
            if (!bl && this.tryRead("NDATA")) {
                if (!bl2) {
                    this.error("whitespace required before NDATA");
                }
                this.requireWhitespace();
                String string3 = this.readNmtoken(true);
                this.setExternalDataEntity(string, stringArray[0], stringArray[1], string3);
            } else {
                this.setExternalTextEntity(string, stringArray[0], stringArray[1]);
            }
        }
        this.skipWhitespace();
        this.require('>', "NDATA");
    }

    private void parseNotationDecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.requireWhitespace();
        String[] stringArray = this.readExternalIds(true);
        if (stringArray[0] == null && stringArray[1] == null) {
            this.error("external identifer missing", string, null);
        }
        this.setNotation(string, stringArray[0], stringArray[1]);
        this.skipWhitespace();
        this.require('>', "notation declaration");
    }

    private void parseCharData() throws Exception {
        char c;
        int n = 0;
        int n2 = 0;
        block11: for (int i = this.readBufferPos; i < this.readBufferLength; ++i) {
            c = this.readBuffer[i];
            switch (c) {
                case '\n': {
                    ++n;
                    n2 = 0;
                    continue block11;
                }
                case '&': 
                case '<': {
                    int n3 = this.readBufferPos;
                    ++n2;
                    this.readBufferPos = i;
                    if (n > 0) {
                        this.line += n;
                        this.column = n2;
                    } else {
                        this.column += n2;
                    }
                    this.dataBufferAppend(this.readBuffer, n3, i - n3);
                    return;
                }
                case ']': {
                    if (i + 2 < this.readBufferLength && this.readBuffer[i + 1] == ']' && this.readBuffer[i + 2] == '>') {
                        this.error("character data may not contain ']]>'");
                    }
                    ++n2;
                    continue block11;
                }
                default: {
                    if (c < ' ' || c > '\ufffd') {
                        this.error("illegal XML character U+" + Integer.toHexString(c));
                    }
                }
                case '\t': 
                case '\r': {
                    ++n2;
                }
            }
        }
        n = 0;
        block12: while (true) {
            c = this.readCh();
            switch (c) {
                case '&': 
                case '<': {
                    this.unread(c);
                    return;
                }
                case ']': {
                    ++n;
                    this.dataBufferAppend(c);
                    continue block12;
                }
                case '>': {
                    if (n < 2) break;
                    this.error("']]>' is not allowed here");
                    continue block12;
                }
            }
            n = 0;
            this.dataBufferAppend(c);
        }
    }

    private void requireWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
        } else {
            this.error("whitespace required", c, null);
        }
    }

    private void parseWhitespace() throws Exception {
        char c = this.readCh();
        while (this.isWhitespace(c)) {
            this.dataBufferAppend(c);
            c = this.readCh();
        }
        this.unread(c);
    }

    private void skipWhitespace() throws SAXException, IOException {
        char c = '\u0000';
        int n = 0;
        block5: for (int i = this.readBufferPos; i < this.readBufferLength; ++i) {
            switch (this.readBuffer[i]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    ++n;
                    continue block5;
                }
                case '\n': {
                    ++c;
                    n = 0;
                    continue block5;
                }
                case '%': {
                    if (this.expandPE) break block5;
                }
                default: {
                    this.readBufferPos = i;
                    if (c > '\u0000') {
                        this.line += c;
                        this.column = n;
                    } else {
                        this.column += n;
                    }
                    return;
                }
            }
        }
        c = this.readCh();
        while (this.isWhitespace(c)) {
            c = this.readCh();
        }
        this.unread(c);
    }

    private String readNmtoken(boolean bl) throws SAXException, IOException {
        char c;
        block7: for (int i = this.readBufferPos; i < this.readBufferLength; ++i) {
            c = this.readBuffer[i];
            switch (c) {
                case '%': {
                    if (this.expandPE) break block7;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    int n = this.readBufferPos;
                    if (i == n) {
                        this.error("name expected", this.readBuffer[i], null);
                    }
                    this.readBufferPos = i;
                    return this.intern(this.readBuffer, n, i - n);
                }
                default: {
                    if (i == this.readBufferPos && bl) {
                        if (Character.isUnicodeIdentifierStart(c) || c == ':' || c == '_') continue block7;
                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                        continue block7;
                    }
                    if (Character.isUnicodeIdentifierPart(c) || c == '-' || c == ':' || c == '_' || c == '.' || XmlParser.isExtender(c)) continue block7;
                    this.error("Not a name character, U+" + Integer.toHexString(c));
                    continue block7;
                }
            }
        }
        this.nameBufferPos = 0;
        while (true) {
            c = this.readCh();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    this.unread(c);
                    if (this.nameBufferPos == 0) {
                        this.error("name expected");
                    }
                    if (bl && !Character.isUnicodeIdentifierStart(this.nameBuffer[0]) && ":_".indexOf(this.nameBuffer[0]) == -1) {
                        this.error("Not a name start character, U+" + Integer.toHexString(this.nameBuffer[0]));
                    }
                    String string = this.intern(this.nameBuffer, 0, this.nameBufferPos);
                    this.nameBufferPos = 0;
                    return string;
                }
            }
            if (!(this.nameBufferPos == 0 && bl || Character.isUnicodeIdentifierPart(c) || ":-_.".indexOf(c) != -1 || XmlParser.isExtender(c))) {
                this.error("Not a name character, U+" + Integer.toHexString(c));
            }
            if (this.nameBufferPos >= this.nameBuffer.length) {
                this.nameBuffer = (char[])this.extendArray(this.nameBuffer, this.nameBuffer.length, this.nameBufferPos);
            }
            this.nameBuffer[this.nameBufferPos++] = c;
        }
    }

    private static boolean isExtender(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe';
    }

    private String readLiteral(int n) throws SAXException, IOException {
        int n2 = this.line;
        boolean bl = this.expandPE;
        char c = this.readCh();
        if (c != '\"' && c != '\'' && c != '\u0000') {
            this.error("expected '\"' or \"'\"", c, null);
            return null;
        }
        this.inLiteral = true;
        if ((n & 0x10) != 0) {
            this.expandPE = false;
        }
        char[] cArray = this.readBuffer;
        try {
            char c2 = this.readCh();
            block8: while (c2 != c || this.readBuffer != cArray) {
                switch (c2) {
                    case '\n': 
                    case '\r': {
                        if ((n & 0x108) == 0) break;
                        c2 = ' ';
                        break;
                    }
                    case '\t': {
                        if ((n & 8) == 0) break;
                        c2 = ' ';
                        break;
                    }
                    case '&': {
                        c2 = this.readCh();
                        if (c2 == '#') {
                            if ((n & 0x20) != 0) {
                                this.dataBufferAppend('&');
                                continue block8;
                            }
                            this.parseCharRef();
                        } else {
                            this.unread(c2);
                            if ((n & 2) > 0) {
                                this.parseEntityRef(false);
                            } else if ((n & 0x40) != 0) {
                                this.dataBufferAppend('&');
                            } else {
                                String string = this.readNmtoken(true);
                                this.require(';', "entity reference");
                                if ((n & 0x80) != 0 && this.getEntityType(string) == 0) {
                                    this.error("General entity '" + string + "' must be declared before use");
                                }
                                this.dataBufferAppend('&');
                                this.dataBufferAppend(string);
                                this.dataBufferAppend(';');
                            }
                        }
                        c2 = this.readCh();
                        continue block8;
                    }
                    case '<': {
                        if ((n & 8) == 0) break;
                        this.error("attribute values may not contain '<'");
                        break;
                    }
                }
                this.dataBufferAppend(c2);
                c2 = this.readCh();
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + n2 + ')', null, new Character(c).toString());
        }
        this.inLiteral = false;
        this.expandPE = bl;
        if ((n & 4) > 0) {
            this.dataBufferNormalize();
        }
        return this.dataBufferToString();
    }

    private String[] readExternalIds(boolean bl) throws Exception {
        String[] stringArray = new String[2];
        int n = 112;
        if (this.tryRead("PUBLIC")) {
            char c;
            this.requireWhitespace();
            stringArray[0] = this.readLiteral(0x104 | n);
            if (bl) {
                this.skipWhitespace();
                c = this.readCh();
                this.unread(c);
                if (c == '\"' || c == '\'') {
                    stringArray[1] = this.readLiteral(n);
                }
            } else {
                this.requireWhitespace();
                stringArray[1] = this.readLiteral(n);
            }
            for (int i = 0; i < stringArray[0].length(); ++i) {
                c = stringArray[0].charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || " \r\n0123456789-' ()+,./:=?;!*#@$_%".indexOf(c) != -1) continue;
                this.error("illegal PUBLIC id character U+" + Integer.toHexString(c));
            }
        } else if (this.tryRead("SYSTEM")) {
            this.requireWhitespace();
            stringArray[1] = this.readLiteral(n);
        }
        return stringArray;
    }

    private final boolean isWhitespace(char c) {
        if (c > ' ') {
            return false;
        }
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private void dataBufferAppend(char c) {
        if (this.dataBufferPos >= this.dataBuffer.length) {
            this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos);
        }
        this.dataBuffer[this.dataBufferPos++] = c;
    }

    private void dataBufferAppend(String string) {
        this.dataBufferAppend(string.toCharArray(), 0, string.length());
    }

    private void dataBufferAppend(char[] cArray, int n, int n2) {
        this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos + n2);
        System.arraycopy(cArray, n, this.dataBuffer, this.dataBufferPos, n2);
        this.dataBufferPos += n2;
    }

    private void dataBufferNormalize() {
        int n;
        int n2 = 0;
        int n3 = this.dataBufferPos;
        for (n = 0; n < n3 && this.dataBuffer[n] == ' '; ++n) {
        }
        while (n3 > n && this.dataBuffer[n3 - 1] == ' ') {
            --n3;
        }
        while (n < n3) {
            char c;
            if ((c = this.dataBuffer[n++]) == ' ') {
                while (n < n3 && this.dataBuffer[n++] == ' ') {
                }
                this.dataBuffer[n2++] = 32;
                this.dataBuffer[n2++] = this.dataBuffer[n - 1];
                continue;
            }
            this.dataBuffer[n2++] = c;
        }
        this.dataBufferPos = n2;
    }

    private String dataBufferToString() {
        String string = new String(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
        return string;
    }

    private void dataBufferFlush() throws SAXException {
        if (this.currentElementContent == 4 && this.dataBufferPos > 0 && !this.inCDATA) {
            for (int i = 0; i < this.dataBufferPos; ++i) {
                if (this.isWhitespace(this.dataBuffer[i])) continue;
                this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
                this.dataBufferPos = 0;
            }
            if (this.dataBufferPos > 0) {
                this.handler.ignorableWhitespace(this.dataBuffer, 0, this.dataBufferPos);
                this.dataBufferPos = 0;
            }
        } else if (this.dataBufferPos > 0) {
            this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
            this.dataBufferPos = 0;
        }
    }

    private void require(String string, String string2) throws SAXException, IOException {
        char[] cArray;
        int n = string.length();
        if (n < this.dataBuffer.length) {
            cArray = this.dataBuffer;
            string.getChars(0, n, cArray, 0);
        } else {
            cArray = string.toCharArray();
        }
        if (n <= this.readBufferLength - this.readBufferPos) {
            int n2 = this.readBufferPos;
            int n3 = 0;
            while (n3 < n) {
                if (cArray[n3] != this.readBuffer[n2]) {
                    this.error("unexpected characters in " + string2, null, string);
                }
                ++n3;
                ++n2;
            }
            this.readBufferPos = n2;
        } else {
            for (int i = 0; i < n; ++i) {
                this.require(cArray[i], string);
            }
        }
    }

    private void require(char c, String string) throws SAXException, IOException {
        char c2 = this.readCh();
        if (c2 != c) {
            this.error("unexpected character after " + string, c2, c + "");
        }
    }

    public String intern(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = n; i < n + n2; ++i) {
            n4 = 31 * n4 + cArray[i];
        }
        Object[] objectArray = this.symbolTable[n4 = (n4 & Integer.MAX_VALUE) % 1087];
        if (objectArray == null) {
            objectArray = new Object[8];
        } else {
            char[] cArray2;
            while (n3 < objectArray.length && (cArray2 = (char[])objectArray[n3]) != null) {
                if (cArray2.length == n2) {
                    for (int i = 0; i < cArray2.length && cArray[n + i] == cArray2[i]; ++i) {
                        if (i != n2 - 1) continue;
                        return (String)objectArray[n3 + 1];
                    }
                }
                n3 += 2;
            }
            objectArray = (Object[])this.extendArray(objectArray, objectArray.length, n3);
        }
        this.symbolTable[n4] = objectArray;
        String string = new String(cArray, n, n2).intern();
        objectArray[n3] = string.toCharArray();
        objectArray[n3 + 1] = string;
        return string;
    }

    private Object extendArray(Object object, int n, int n2) {
        if (n2 < n) {
            return object;
        }
        Object[] objectArray = null;
        int n3 = n * 2;
        if (n3 <= n2) {
            n3 = n2 + 1;
        }
        if (object instanceof char[]) {
            objectArray = new char[n3];
        } else if (object instanceof Object[]) {
            objectArray = new Object[n3];
        } else {
            throw new RuntimeException();
        }
        System.arraycopy(object, 0, objectArray, 0, n);
        return objectArray;
    }

    public Enumeration declaredElements() {
        return this.elementInfo.keys();
    }

    private int getContentType(Object[] objectArray, int n) {
        if (objectArray == null) {
            return n;
        }
        int n2 = (Integer)objectArray[0];
        if (n2 == 0) {
            n2 = n;
        }
        return n2;
    }

    public int getElementContentType(String string) {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        return this.getContentType(objectArray, 0);
    }

    public String getElementContentModel(String string) {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    private void setElement(String string, int n, String string2, Hashtable hashtable) throws Exception {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        if (objectArray == null) {
            objectArray = new Object[]{new Integer(n), string2, hashtable};
            this.elementInfo.put(string, objectArray);
            return;
        }
        if (n != 0) {
            if ((Integer)objectArray[0] == 0) {
                objectArray[0] = new Integer(n);
                objectArray[1] = string2;
            }
        } else if (hashtable != null) {
            objectArray[2] = hashtable;
        }
    }

    private Hashtable getElementAttributes(String string) {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (Hashtable)objectArray[2];
    }

    private Enumeration declaredAttributes(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Hashtable hashtable = (Hashtable)objectArray[2];
        if (hashtable == null) {
            return null;
        }
        return hashtable.keys();
    }

    public Enumeration declaredAttributes(String string) {
        return this.declaredAttributes((Object[])this.elementInfo.get(string));
    }

    public int getAttributeType(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return 0;
        }
        return (Integer)objectArray[0];
    }

    public String getAttributeEnumeration(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[3];
    }

    public String getAttributeDefaultValue(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    public String getAttributeExpandedValue(String string, String string2) throws Exception {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return null;
        }
        if (objectArray[4] == null && objectArray[1] != null) {
            char[] cArray = new char[1];
            int n = 10;
            int n2 = this.getAttributeType(string, string2);
            if (n2 != 1 && n2 != 0) {
                n |= 4;
            }
            cArray[0] = 34;
            this.pushCharArray(null, cArray, 0, 1);
            this.pushString(null, (String)objectArray[1]);
            this.pushCharArray(null, cArray, 0, 1);
            objectArray[4] = this.readLiteral(n);
        }
        return (String)objectArray[4];
    }

    public int getAttributeDefaultValueType(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return 30;
        }
        return (Integer)objectArray[2];
    }

    private void setAttribute(String string, String string2, int n, String string3, String string4, int n2) throws Exception {
        Hashtable<String, Object[]> hashtable = this.getElementAttributes(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object[]>();
        }
        if (hashtable.get(string2) != null) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(n), string4, new Integer(n2), string3, null};
        hashtable.put(string2, objectArray);
        this.setElement(string, 0, null, hashtable);
    }

    private Object[] getAttribute(String string, String string2) {
        Hashtable hashtable = this.getElementAttributes(string);
        if (hashtable == null) {
            return null;
        }
        return (Object[])hashtable.get(string2);
    }

    public Enumeration declaredEntities() {
        return this.entityInfo.keys();
    }

    public int getEntityType(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return 0;
        }
        return (Integer)objectArray[0];
    }

    public String getEntityPublicId(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    public String getEntitySystemId(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        try {
            String string2 = (String)objectArray[2];
            URL uRL = (URL)objectArray[5];
            if (uRL == null) {
                return string2;
            }
            URL uRL2 = new URL(uRL, string2);
            return uRL2.toString();
        }
        catch (IOException iOException) {
            return (String)objectArray[2];
        }
    }

    public String getEntityValue(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[3];
    }

    public String getEntityNotationName(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[4];
    }

    private void setInternalEntity(String string, String string2) {
        this.setEntity(string, 1, null, null, string2, null);
    }

    private void setExternalDataEntity(String string, String string2, String string3, String string4) {
        this.setEntity(string, 2, string2, string3, null, string4);
    }

    private void setExternalTextEntity(String string, String string2, String string3) {
        this.setEntity(string, 3, string2, string3, null, null);
    }

    private void setEntity(String string, int n, String string2, String string3, String string4, String string5) {
        if (this.entityInfo.get(string) == null) {
            Object[] objectArray = new Object[]{new Integer(n), string2, string3, string4, string5, this.externalEntity == null ? null : this.externalEntity.getURL()};
            this.entityInfo.put(string, objectArray);
        }
    }

    public Enumeration declaredNotations() {
        return this.notationInfo.keys();
    }

    public String getNotationPublicId(String string) {
        Object[] objectArray = (Object[])this.notationInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[0];
    }

    public String getNotationSystemId(String string) {
        Object[] objectArray = (Object[])this.notationInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    private void setNotation(String string, String string2, String string3) throws Exception {
        if (this.notationInfo.get(string) == null) {
            Object[] objectArray = new Object[]{string2, string3};
            this.notationInfo.put(string, objectArray);
        }
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    private char readCh() throws SAXException, IOException {
        char c;
        block3: while (this.readBufferPos >= this.readBufferLength) {
            switch (this.sourceType) {
                case 3: 
                case 5: {
                    this.readDataChunk();
                    while (this.readBufferLength < 1) {
                        this.popInput();
                        if (this.readBufferLength >= 1) continue;
                        this.readDataChunk();
                    }
                    continue block3;
                }
            }
            this.popInput();
        }
        if ((c = this.readBuffer[this.readBufferPos++]) == '\n') {
            ++this.line;
            this.column = 0;
        } else {
            if (c != '<') {
                if (c < ' ' && c != '\t' && c != '\r' || c > '\ufffd') {
                    this.error("illegal XML character U+" + Integer.toHexString(c));
                } else if (c == '%' && this.expandPE) {
                    if (this.peIsError && this.entityStack.size() == 1) {
                        this.error("PE reference within declaration in internal subset.");
                    }
                    this.parsePEReference();
                    return this.readCh();
                }
            }
            ++this.column;
        }
        return c;
    }

    private void unread(char c) throws SAXException {
        if (c == '\n') {
            --this.line;
            this.column = -1;
        }
        if (this.readBufferPos > 0) {
            this.readBuffer[--this.readBufferPos] = c;
        } else {
            this.pushString(null, new Character(c).toString());
        }
    }

    private void unread(char[] cArray, int n) throws SAXException {
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != '\n') continue;
            --this.line;
            this.column = -1;
        }
        if (n < this.readBufferPos) {
            this.readBufferPos -= n;
        } else {
            this.pushCharArray(null, cArray, 0, n);
            this.sourceType = 4;
        }
    }

    private void pushURL(String string, String string2, String string3, Reader reader, InputStream inputStream, String string4, boolean bl) throws SAXException, IOException {
        Object object;
        boolean bl2 = false;
        this.pushInput(string);
        this.readBuffer = new char[16388];
        this.readBufferPos = 0;
        this.readBufferLength = 0;
        this.readBufferOverflow = -1;
        this.is = null;
        this.line = 1;
        this.column = 0;
        this.currentByteCount = 0;
        if (!bl) {
            try {
                if (string3 != null && this.externalEntity != null) {
                    string3 = new URL(this.externalEntity.getURL(), string3).toString();
                } else if (this.baseURI != null) {
                    string3 = new URL(new URL(this.baseURI), string3).toString();
                }
            }
            catch (IOException iOException) {
                this.popInput();
                this.error("Invalid URL " + string3 + " (" + iOException.getMessage() + ")");
            }
        }
        if (reader == null && inputStream == null && string3 != null) {
            object = null;
            try {
                object = this.handler.resolveEntity(string2, string3);
            }
            catch (IOException iOException) {
                this.popInput();
                this.error("Failure resolving entity " + string3 + " (" + iOException.getMessage() + ")");
            }
            if (object != null) {
                if (object instanceof String) {
                    string3 = (String)object;
                    bl = true;
                } else if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else if (object instanceof Reader) {
                    reader = (Reader)object;
                }
            }
        }
        if (string3 != null) {
            this.handler.startExternalEntity(string3);
        } else {
            this.handler.startExternalEntity("[unidentified data stream]");
        }
        if (reader != null) {
            this.sourceType = 5;
            this.reader = reader;
            this.tryEncodingDecl(true);
            return;
        }
        this.sourceType = 3;
        if (inputStream != null) {
            this.is = inputStream;
        } else {
            object = new URL(string3);
            try {
                this.externalEntity = ((URL)object).openConnection();
                this.externalEntity.connect();
                this.is = this.externalEntity.getInputStream();
            }
            catch (IOException iOException) {
                this.popInput();
                this.error("Cannot read from " + string3 + (string3.equals(iOException.getMessage()) ? "" : " (" + iOException.getMessage() + ")"));
            }
        }
        if (!this.is.markSupported()) {
            this.is = new BufferedInputStream(this.is);
        }
        if (string4 == null && this.externalEntity != null && !"file".equals(this.externalEntity.getURL().getProtocol())) {
            string4 = this.externalEntity.getContentType();
            int n = string4 == null ? -1 : string4.indexOf("charset");
            if (n < 0) {
                string4 = null;
            } else {
                n = string4.indexOf(61, n + 7);
                if ((n = (string4 = string4.substring(n + 1)).indexOf(59)) > 0) {
                    string4 = string4.substring(0, n);
                }
                if ((n = string4.indexOf(40)) > 0) {
                    string4 = string4.substring(0, n);
                }
                if ((n = string4.indexOf(34)) > 0) {
                    string4 = string4.substring(n + 1, string4.indexOf(34, n + 2));
                }
                string4.trim();
            }
        }
        if (string4 != null) {
            this.encoding = 0;
            this.setupDecoding(string4);
            bl2 = true;
        } else {
            this.detectEncoding();
            bl2 = false;
        }
        this.is.mark(100);
        try {
            this.tryEncodingDecl(bl2);
        }
        catch (EncodingException encodingException) {
            string4 = encodingException.getMessage();
            try {
                if (this.sourceType != 3) {
                    throw encodingException;
                }
                this.is.reset();
                this.readBufferPos = 0;
                this.readBufferLength = 0;
                this.readBufferOverflow = -1;
                this.line = 1;
                this.column = 0;
                this.currentByteCount = 0;
                this.sourceType = 5;
                this.reader = new InputStreamReader(this.is, string4);
                this.is = null;
                this.tryEncodingDecl(true);
            }
            catch (IOException iOException) {
                this.error("unsupported text encoding", string4, null);
            }
        }
    }

    private String tryEncodingDecl(boolean bl) throws SAXException, IOException {
        if (this.tryRead("<?xml")) {
            this.dataBufferFlush();
            if (this.tryWhitespace()) {
                if (this.inputStack.size() > 0) {
                    return this.parseTextDecl(bl);
                }
                return this.parseXMLDecl(bl);
            }
            this.unread("xml".toCharArray(), 3);
            this.parsePI();
        }
        return null;
    }

    private void detectEncoding() throws SAXException, IOException {
        byte[] byArray = new byte[4];
        this.is.mark(4);
        this.is.read(byArray);
        this.is.reset();
        if (XmlParser.tryEncoding(byArray, (byte)0, (byte)0, (byte)0, (byte)60)) {
            this.encoding = 5;
        } else if (XmlParser.tryEncoding(byArray, (byte)60, (byte)0, (byte)0, (byte)0)) {
            this.encoding = 6;
        } else if (XmlParser.tryEncoding(byArray, (byte)0, (byte)0, (byte)60, (byte)0)) {
            this.encoding = 7;
        } else if (XmlParser.tryEncoding(byArray, (byte)0, (byte)60, (byte)0, (byte)0)) {
            this.encoding = 8;
        } else if (XmlParser.tryEncoding(byArray, (byte)-17, (byte)-69, (byte)-65)) {
            this.encoding = 1;
            this.is.read();
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(byArray, (byte)-2, (byte)-1)) {
            this.encoding = 3;
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(byArray, (byte)-1, (byte)-2)) {
            this.encoding = 4;
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(byArray, (byte)0, (byte)60, (byte)0, (byte)63)) {
            this.encoding = 3;
            this.error("no byte-order mark for UCS-2 entity");
        } else if (XmlParser.tryEncoding(byArray, (byte)60, (byte)0, (byte)63, (byte)0)) {
            this.encoding = 4;
            this.error("no byte-order mark for UCS-2 entity");
        } else if (XmlParser.tryEncoding(byArray, (byte)60, (byte)63, (byte)120, (byte)109)) {
            this.encoding = 1;
            this.read8bitEncodingDeclaration();
        } else {
            this.encoding = 1;
        }
    }

    private static boolean tryEncoding(byte[] byArray, byte by, byte by2, byte by3, byte by4) {
        return byArray[0] == by && byArray[1] == by2 && byArray[2] == by3 && byArray[3] == by4;
    }

    private static boolean tryEncoding(byte[] byArray, byte by, byte by2) {
        return byArray[0] == by && byArray[1] == by2;
    }

    private static boolean tryEncoding(byte[] byArray, byte by, byte by2, byte by3) {
        return byArray[0] == by && byArray[1] == by2 && byArray[2] == by3;
    }

    private void pushString(String string, String string2) throws SAXException {
        char[] cArray = string2.toCharArray();
        this.pushCharArray(string, cArray, 0, cArray.length);
    }

    private void pushCharArray(String string, char[] cArray, int n, int n2) throws SAXException {
        this.pushInput(string);
        this.sourceType = 1;
        this.readBuffer = cArray;
        this.readBufferPos = n;
        this.readBufferLength = n2;
        this.readBufferOverflow = -1;
    }

    private void pushInput(String string) throws SAXException {
        Object[] objectArray = new Object[12];
        if (string != null) {
            Enumeration enumeration = this.entityStack.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2 != string) continue;
                this.error("recursive reference to entity", string, null);
            }
        }
        this.entityStack.push(string);
        if (this.sourceType == 0) {
            return;
        }
        objectArray[0] = new Integer(this.sourceType);
        objectArray[1] = this.externalEntity;
        objectArray[2] = this.readBuffer;
        objectArray[3] = new Integer(this.readBufferPos);
        objectArray[4] = new Integer(this.readBufferLength);
        objectArray[5] = new Integer(this.line);
        objectArray[6] = new Integer(this.encoding);
        objectArray[7] = new Integer(this.readBufferOverflow);
        objectArray[8] = this.is;
        objectArray[9] = new Integer(this.currentByteCount);
        objectArray[10] = new Integer(this.column);
        objectArray[11] = this.reader;
        this.inputStack.push(objectArray);
    }

    private void popInput() throws SAXException, IOException {
        String string = this.externalEntity != null ? this.externalEntity.getURL().toString() : this.baseURI;
        switch (this.sourceType) {
            case 3: {
                if (this.is == null) break;
                if (string != null) {
                    this.handler.endExternalEntity(this.baseURI);
                }
                this.is.close();
                break;
            }
            case 5: {
                if (this.reader == null) break;
                if (string != null) {
                    this.handler.endExternalEntity(this.baseURI);
                }
                this.reader.close();
            }
        }
        if (this.inputStack.isEmpty()) {
            throw new EOFException("no more input");
        }
        Object[] objectArray = (Object[])this.inputStack.pop();
        this.entityStack.pop();
        this.sourceType = (Integer)objectArray[0];
        this.externalEntity = (URLConnection)objectArray[1];
        this.readBuffer = (char[])objectArray[2];
        this.readBufferPos = (Integer)objectArray[3];
        this.readBufferLength = (Integer)objectArray[4];
        this.line = (Integer)objectArray[5];
        this.encoding = (Integer)objectArray[6];
        this.readBufferOverflow = (Integer)objectArray[7];
        this.is = (InputStream)objectArray[8];
        this.currentByteCount = (Integer)objectArray[9];
        this.column = (Integer)objectArray[10];
        this.reader = (Reader)objectArray[11];
    }

    private boolean tryRead(char c) throws SAXException, IOException {
        char c2 = this.readCh();
        if (c2 == c) {
            return true;
        }
        this.unread(c2);
        return false;
    }

    private boolean tryRead(String string) throws SAXException, IOException {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = this.readCh();
            if (c == cArray[i]) continue;
            this.unread(c);
            if (i != 0) {
                this.unread(cArray, i);
            }
            return false;
        }
        return true;
    }

    private boolean tryWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
            return true;
        }
        this.unread(c);
        return false;
    }

    private void parseUntil(String string) throws SAXException, IOException {
        int n = this.line;
        try {
            while (!this.tryRead(string)) {
                char c = this.readCh();
                this.dataBufferAppend(c);
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + n + ')', null, string);
        }
    }

    private void read8bitEncodingDeclaration() throws SAXException, IOException {
        this.readBufferLength = 0;
        this.readBufferPos = 0;
        while (true) {
            int n = this.is.read();
            this.readBuffer[this.readBufferLength++] = (char)n;
            switch (n) {
                case 62: {
                    return;
                }
                case -1: {
                    this.error("end of file before end of XML or encoding declaration.", null, "?>");
                }
            }
            if (this.readBuffer.length != this.readBufferLength) continue;
            this.error("unfinished XML or encoding declaration");
        }
    }

    private void readDataChunk() throws SAXException, IOException {
        if (this.readBufferOverflow > -1) {
            this.readBuffer[0] = (char)this.readBufferOverflow;
            this.readBufferOverflow = -1;
            this.readBufferPos = 1;
            this.sawCR = true;
        } else {
            this.readBufferPos = 0;
            this.sawCR = false;
        }
        if (this.sourceType == 5) {
            int n = this.reader.read(this.readBuffer, this.readBufferPos, 16384 - this.readBufferPos);
            this.readBufferLength = n < 0 ? this.readBufferPos : this.readBufferPos + n;
            if (this.readBufferLength > 0) {
                this.filterCR(n >= 0);
            }
            this.sawCR = false;
            return;
        }
        int n = this.is.read(this.rawReadBuffer, 0, 16384);
        if (n > 0) {
            switch (this.encoding) {
                case 9: {
                    this.copyIso8859_1ReadBuffer(n, '\u0080');
                    break;
                }
                case 1: {
                    this.copyUtf8ReadBuffer(n);
                    break;
                }
                case 2: {
                    this.copyIso8859_1ReadBuffer(n, '\u0000');
                    break;
                }
                case 3: {
                    this.copyUcs2ReadBuffer(n, 8, 0);
                    break;
                }
                case 4: {
                    this.copyUcs2ReadBuffer(n, 0, 8);
                    break;
                }
                case 5: {
                    this.copyUcs4ReadBuffer(n, 24, 16, 8, 0);
                    break;
                }
                case 6: {
                    this.copyUcs4ReadBuffer(n, 0, 8, 16, 24);
                    break;
                }
                case 7: {
                    this.copyUcs4ReadBuffer(n, 16, 24, 0, 8);
                    break;
                }
                case 8: {
                    this.copyUcs4ReadBuffer(n, 8, 0, 24, 16);
                }
            }
        } else {
            this.readBufferLength = this.readBufferPos;
        }
        this.readBufferPos = 0;
        if (this.sawCR) {
            this.filterCR(n >= 0);
            this.sawCR = false;
            if (this.readBufferLength == 0 && n >= 0) {
                this.readDataChunk();
            }
        }
        if (n > 0) {
            this.currentByteCount += n;
        }
    }

    private void filterCR(boolean bl) {
        int n;
        this.readBufferOverflow = -1;
        int n2 = n = this.readBufferPos;
        block3: while (n < this.readBufferLength) {
            switch (this.readBuffer[n]) {
                case '\r': {
                    if (n == this.readBufferLength - 1) {
                        if (bl) {
                            this.readBufferOverflow = 13;
                            --this.readBufferLength;
                            break block3;
                        }
                        this.readBuffer[n2++] = 10;
                        break block3;
                    }
                    if (this.readBuffer[n + 1] == '\n') {
                        ++n;
                    }
                    this.readBuffer[n2] = 10;
                    break;
                }
                default: {
                    this.readBuffer[n2] = this.readBuffer[n];
                }
            }
            ++n2;
            ++n;
        }
        this.readBufferLength = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void copyUtf8ReadBuffer(int n) throws SAXException, IOException {
        int n2 = 0;
        int n3 = this.readBufferPos;
        char c = '\u0000';
        while (true) {
            block8: {
                byte by;
                block9: {
                    block10: {
                        if (n2 >= n) {
                            this.readBufferLength = n3;
                            return;
                        }
                        if ((by = this.rawReadBuffer[n2++]) >= 0) break block9;
                        if ((by & 0xE0) != 192) break block10;
                        c = (char)((by & 0x1F) << 6 | this.getNextUtf8Byte(n2++, n));
                        break block8;
                    }
                    if ((by & 0xF0) == 224) {
                        c = (char)((by & 0xF) << 12 | this.getNextUtf8Byte(n2++, n) << 6 | this.getNextUtf8Byte(n2++, n));
                        break block8;
                    } else {
                        if ((by & 0xF8) == 240) {
                            int n4 = by & 7;
                            n4 = (n4 << 6) + this.getNextUtf8Byte(n2++, n);
                            n4 = (n4 << 6) + this.getNextUtf8Byte(n2++, n);
                            if ((n4 = (n4 << 6) + this.getNextUtf8Byte(n2++, n)) <= 65535) {
                                c = (char)n4;
                                break block8;
                            } else {
                                if (n4 > 0x10FFFF) {
                                    this.encodingError("UTF-8 value out of range for Unicode", n4, 0);
                                }
                                this.readBuffer[n3++] = (char)(0xD800 | (n4 -= 65536) >> 10);
                                this.readBuffer[n3++] = (char)(0xDC00 | n4 & 0x3FF);
                                continue;
                            }
                        }
                        this.encodingError("invalid UTF-8 byte (check the XML declaration)", 0xFF & by, n2);
                        c = '\u0000';
                    }
                    break block8;
                }
                c = (char)by;
            }
            this.readBuffer[n3++] = c;
            if (c != '\r') continue;
            this.sawCR = true;
        }
    }

    private int getNextUtf8Byte(int n, int n2) throws SAXException, IOException {
        int n3;
        if (n < n2) {
            n3 = this.rawReadBuffer[n];
        } else {
            n3 = this.is.read();
            if (n3 == -1) {
                this.encodingError("unfinished multi-byte UTF-8 sequence at EOF", -1, n);
            }
        }
        if ((n3 & 0xC0) != 128) {
            this.encodingError("bad continuation of multi-byte UTF-8 sequence", n3, n + 1);
        }
        return n3 & 0x3F;
    }

    private void copyIso8859_1ReadBuffer(int n, char c) throws IOException {
        int n2 = 0;
        int n3 = this.readBufferPos;
        while (n2 < n) {
            char c2 = (char)(this.rawReadBuffer[n2] & 0xFF);
            if ((c2 & c) != 0) {
                throw new CharConversionException("non-ASCII character U+" + Integer.toHexString(c2));
            }
            this.readBuffer[n3] = c2;
            if (c2 == '\r') {
                this.sawCR = true;
            }
            ++n2;
            ++n3;
        }
        this.readBufferLength = n3;
    }

    private void copyUcs2ReadBuffer(int n, int n2, int n3) throws SAXException {
        int n4 = this.readBufferPos;
        if (n > 0 && n % 2 != 0) {
            this.encodingError("odd number of bytes in UCS-2 encoding", -1, n);
        }
        if (n2 == 0) {
            for (int i = 0; i < n; i += 2) {
                char c = (char)(this.rawReadBuffer[i + 1] << 8);
                c = (char)(c | 0xFF & this.rawReadBuffer[i]);
                this.readBuffer[n4++] = c;
                if (c != '\r') continue;
                this.sawCR = true;
            }
        } else {
            for (int i = 0; i < n; i += 2) {
                char c = (char)(this.rawReadBuffer[i] << 8);
                c = (char)(c | 0xFF & this.rawReadBuffer[i + 1]);
                this.readBuffer[n4++] = c;
                if (c != '\r') continue;
                this.sawCR = true;
            }
        }
        this.readBufferLength = n4;
    }

    private void copyUcs4ReadBuffer(int n, int n2, int n3, int n4, int n5) throws SAXException {
        int n6 = this.readBufferPos;
        if (n > 0 && n % 4 != 0) {
            this.encodingError("number of bytes in UCS-4 encoding not divisible by 4", -1, n);
        }
        for (int i = 0; i < n; i += 4) {
            int n7 = (this.rawReadBuffer[i] & 0xFF) << n2 | (this.rawReadBuffer[i + 1] & 0xFF) << n3 | (this.rawReadBuffer[i + 2] & 0xFF) << n4 | (this.rawReadBuffer[i + 3] & 0xFF) << n5;
            if (n7 < 65535) {
                this.readBuffer[n6++] = (char)n7;
                if (n7 != 13) continue;
                this.sawCR = true;
                continue;
            }
            if (n7 < 0x10FFFF) {
                this.readBuffer[n6++] = (char)(0xD8 | (n7 -= 65536) >> 10 & 0x3FF);
                this.readBuffer[n6++] = (char)(0xDC | n7 & 0x3FF);
                continue;
            }
            this.encodingError("UCS-4 value out of range for Unicode", n7, i);
        }
        this.readBufferLength = n6;
    }

    private void encodingError(String string, int n, int n2) throws SAXException {
        if (n != -1) {
            string = string + " (code: 0x" + Integer.toHexString(n) + ')';
        }
        String string2 = this.externalEntity != null ? this.externalEntity.getURL().toString() : this.baseURI;
        this.handler.error(string, string2, -1, n2 + this.currentByteCount);
    }

    private void initializeVariables() {
        this.line = 1;
        this.column = 0;
        this.dataBufferPos = 0;
        this.dataBuffer = new char[DATA_BUFFER_INITIAL];
        this.nameBufferPos = 0;
        this.nameBuffer = new char[NAME_BUFFER_INITIAL];
        this.elementInfo = new Hashtable();
        this.entityInfo = new Hashtable();
        this.notationInfo = new Hashtable();
        this.currentElement = null;
        this.currentElementContent = 0;
        this.sourceType = 0;
        this.inputStack = new Stack();
        this.entityStack = new Stack();
        this.externalEntity = null;
        this.tagAttributePos = 0;
        this.tagAttributes = new String[100];
        this.rawReadBuffer = new byte[16384];
        this.readBufferOverflow = -1;
        this.inLiteral = false;
        this.expandPE = false;
        this.peIsError = false;
        this.inCDATA = false;
        this.symbolTable = new Object[1087][];
    }

    private void cleanupVariables() {
        this.dataBuffer = null;
        this.nameBuffer = null;
        this.elementInfo = null;
        this.entityInfo = null;
        this.notationInfo = null;
        this.currentElement = null;
        this.inputStack = null;
        this.entityStack = null;
        this.externalEntity = null;
        this.tagAttributes = null;
        this.rawReadBuffer = null;
        this.symbolTable = null;
    }

    static {
        attributeTypeHash.put("CDATA", new Integer(1));
        attributeTypeHash.put("ID", new Integer(2));
        attributeTypeHash.put("IDREF", new Integer(3));
        attributeTypeHash.put("IDREFS", new Integer(4));
        attributeTypeHash.put("ENTITY", new Integer(5));
        attributeTypeHash.put("ENTITIES", new Integer(6));
        attributeTypeHash.put("NMTOKEN", new Integer(7));
        attributeTypeHash.put("NMTOKENS", new Integer(8));
        attributeTypeHash.put("NOTATION", new Integer(10));
        DATA_BUFFER_INITIAL = 4096;
        NAME_BUFFER_INITIAL = 1024;
    }

    static class EncodingException
    extends IOException {
        EncodingException(String string) {
            super(string);
        }
    }
}

