/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.InternalSaxonError;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ObjectValue;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.TextFragmentValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.SingletonEnumeration;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SingletonNodeSet
extends NodeSetValue
implements NodeList {
    protected NodeInfo node = null;
    protected boolean generalUseAllowed = true;

    public void allowGeneralUse() {
        this.generalUseAllowed = true;
    }

    public boolean isGeneralUseAllowed() {
        return this.generalUseAllowed;
    }

    public SingletonNodeSet() {
        this.node = null;
    }

    public SingletonNodeSet(NodeInfo nodeInfo) {
        this.node = nodeInfo;
    }

    @Override
    public Expression simplify() {
        if (this.node == null) {
            return new EmptyNodeSet();
        }
        return this;
    }

    @Override
    public Value evaluate(Context context) {
        return this;
    }

    @Override
    public NodeSetValue evaluateAsNodeSet(Context context) {
        return this;
    }

    @Override
    public void setSorted(boolean bl) {
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public String asString() {
        if (this.node == null) {
            return "";
        }
        return this.node.getStringValue();
    }

    @Override
    public boolean asBoolean() {
        return this.node != null;
    }

    @Override
    public int getCount() {
        return this.node == null ? 0 : 1;
    }

    @Override
    public NodeSetValue sort() {
        return this;
    }

    @Override
    public NodeInfo getFirst() {
        return this.node;
    }

    @Override
    public boolean equals(Value value) throws XPathException {
        if (this.node == null) {
            if (value instanceof BooleanValue) {
                return !value.asBoolean();
            }
            return false;
        }
        if (value instanceof StringValue || value instanceof FragmentValue || value instanceof TextFragmentValue || value instanceof ObjectValue) {
            return this.node.getStringValue().equals(value.asString());
        }
        if (value instanceof NodeSetValue) {
            try {
                String string = this.node.getStringValue();
                NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
                while (nodeEnumeration.hasMoreElements()) {
                    if (!nodeEnumeration.nextElement().getStringValue().equals(string)) continue;
                    return true;
                }
                return false;
            }
            catch (XPathException xPathException) {
                throw new InternalSaxonError(xPathException.getMessage());
            }
        }
        if (value instanceof NumericValue) {
            return Value.stringToNumber(this.node.getStringValue()) == value.asNumber();
        }
        if (value instanceof BooleanValue) {
            return value.asBoolean();
        }
        throw new InternalSaxonError("Unknown data type in a relational expression");
    }

    @Override
    public boolean notEquals(Value value) throws XPathException {
        if (this.node == null) {
            if (value instanceof BooleanValue) {
                return value.asBoolean();
            }
            return false;
        }
        if (value instanceof StringValue || value instanceof FragmentValue || value instanceof TextFragmentValue || value instanceof ObjectValue) {
            return !this.node.getStringValue().equals(value.asString());
        }
        if (value instanceof NodeSetValue) {
            try {
                String string = this.node.getStringValue();
                NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
                while (nodeEnumeration.hasMoreElements()) {
                    if (nodeEnumeration.nextElement().getStringValue().equals(string)) continue;
                    return true;
                }
                return false;
            }
            catch (XPathException xPathException) {
                throw new InternalSaxonError(xPathException.getMessage());
            }
        }
        if (value instanceof NumericValue) {
            return Value.stringToNumber(this.node.getStringValue()) != value.asNumber();
        }
        if (value instanceof BooleanValue) {
            return !value.asBoolean();
        }
        throw new InternalSaxonError("Unknown data type in a relational expression");
    }

    @Override
    public NodeEnumeration enumerate() throws XPathException {
        return new SingletonEnumeration(this.node);
    }

    @Override
    public int getLength() {
        return this.getCount();
    }

    @Override
    public Node item(int n) {
        if (n == 0 && this.node instanceof Node) {
            return (Node)((Object)this.node);
        }
        return null;
    }
}

