/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.om;

import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.pattern.NodeTypeTest;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.sort.NodeOrderComparer;
import com.icl.saxon.tree.DOMExceptionImpl;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public abstract class AbstractNode
implements Node,
NodeInfo,
SourceLocator,
DOMLocator {
    public static final char[] NODE_LETTER = new char[]{'x', 'e', 'a', 't', 'x', 'x', 'x', 'p', 'c', 'r', 'x', 'x', 'x', 'n'};

    @Override
    public abstract boolean isSameNodeInfo(NodeInfo var1);

    @Override
    public abstract String generateId();

    @Override
    public abstract String getSystemId();

    @Override
    public abstract String getBaseURI();

    @Override
    public Node getOriginatingNode() {
        return this;
    }

    @Override
    public abstract int compareOrder(NodeInfo var1);

    @Override
    public abstract int getNameCode();

    @Override
    public abstract int getFingerprint();

    @Override
    public String getNodeName() {
        switch (this.getNodeType()) {
            case 9: {
                return "#document";
            }
            case 1: {
                return this.getDisplayName();
            }
            case 2: {
                return this.getDisplayName();
            }
            case 3: {
                return "#text";
            }
            case 8: {
                return "#comment";
            }
            case 7: {
                return this.getLocalName();
            }
            case 13: {
                return this.getLocalName();
            }
        }
        return "#unknown";
    }

    @Override
    public abstract String getPrefix();

    @Override
    public abstract String getURI();

    @Override
    public String getDisplayName() {
        String string = this.getLocalName();
        if ("".equals(string)) {
            return "";
        }
        String string2 = this.getPrefix();
        if ("".equals(string2)) {
            return string;
        }
        return string2 + ":" + string;
    }

    @Override
    public abstract String getLocalName();

    @Override
    public abstract boolean hasChildNodes();

    @Override
    public abstract boolean hasAttributes();

    @Override
    public abstract String getAttributeValue(String var1, String var2);

    @Override
    public abstract String getAttributeValue(int var1);

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public abstract AxisEnumeration getEnumeration(byte var1, NodeTest var2);

    @Override
    public abstract NodeInfo getParent();

    @Override
    public DocumentInfo getDocumentRoot() {
        NodeInfo nodeInfo = this;
        while (nodeInfo.getNodeType() != 9) {
            nodeInfo = nodeInfo.getParent();
        }
        return (DocumentInfo)nodeInfo;
    }

    @Override
    public Node getParentNode() {
        return (Node)((Object)this.getParent());
    }

    @Override
    public Node getPreviousSibling() {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)11, AnyNodeTest.getInstance());
        if (axisEnumeration.hasMoreElements()) {
            return (Node)((Object)axisEnumeration.nextElement());
        }
        return null;
    }

    @Override
    public Node getNextSibling() {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)7, AnyNodeTest.getInstance());
        if (axisEnumeration.hasMoreElements()) {
            return (Node)((Object)axisEnumeration.nextElement());
        }
        return null;
    }

    @Override
    public Node getFirstChild() {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)3, AnyNodeTest.getInstance());
        if (axisEnumeration.hasMoreElements()) {
            return (Node)((Object)axisEnumeration.nextElement());
        }
        return null;
    }

    @Override
    public Node getLastChild() {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)3, AnyNodeTest.getInstance());
        NodeInfo nodeInfo = null;
        while (axisEnumeration.hasMoreElements()) {
            nodeInfo = axisEnumeration.nextElement();
        }
        return (Node)((Object)nodeInfo);
    }

    public Element getDocumentElement() {
        DocumentInfo documentInfo = this.getDocumentRoot();
        AxisEnumeration axisEnumeration = documentInfo.getEnumeration((byte)3, new NodeTypeTest(1));
        if (axisEnumeration.hasMoreElements()) {
            return (Element)((Object)axisEnumeration.nextElement());
        }
        return null;
    }

    @Override
    public void copyStringValue(Outputter outputter) throws TransformerException {
        outputter.writeContent(this.getStringValue());
    }

    @Override
    public void outputNamespaceNodes(Outputter outputter, boolean bl) throws TransformerException {
    }

    @Override
    public String getNodeValue() {
        switch (this.getNodeType()) {
            case 1: 
            case 9: {
                return null;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                return this.getStringValue();
            }
        }
        return null;
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
        this.disallowUpdate();
    }

    @Override
    public NodeList getChildNodes() {
        try {
            return new NodeSetExtent(this.getEnumeration((byte)3, AnyNodeTest.getInstance()), (NodeOrderComparer)LocalOrderComparer.getInstance());
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this.getNodeType() == 1) {
            return new AttributeMap();
        }
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return (Document)((Object)this.getDocumentRoot());
    }

    @Override
    public Node insertBefore(Node node, Node node2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public Node appendChild(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public Node cloneNode(boolean bl) {
        return null;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String string, String string2) {
        return string.equalsIgnoreCase("xml");
    }

    public boolean supports(String string, String string2) {
        return this.isSupported(string, string2);
    }

    @Override
    public String getNamespaceURI() {
        String string = this.getURI();
        return string.equals("") ? null : string;
    }

    @Override
    public void setPrefix(String string) throws DOMException {
        this.disallowUpdate();
    }

    protected void disallowUpdate() throws DOMException {
        throw new UnsupportedOperationException("The Saxon DOM cannot be updated");
    }

    public DocumentType getDoctype() {
        return null;
    }

    public DOMImplementation getImplementation() {
        return new DOMImplementationImpl();
    }

    public Element createElement(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public DocumentFragment createDocumentFragment() {
        return null;
    }

    public Text createTextNode(String string) {
        return null;
    }

    public Comment createComment(String string) {
        return null;
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Attr createAttribute(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public NodeList getElementsByTagName(String string) {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)4, AnyNodeTest.getInstance());
        NodeSetExtent nodeSetExtent = new NodeSetExtent(LocalOrderComparer.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = axisEnumeration.nextElement();
            if (nodeInfo.getNodeType() != 1 || !string.equals("*") && !string.equals(nodeInfo.getDisplayName())) continue;
            nodeSetExtent.append(nodeInfo);
        }
        return nodeSetExtent;
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)4, AnyNodeTest.getInstance());
        NodeSetExtent nodeSetExtent = new NodeSetExtent(LocalOrderComparer.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = axisEnumeration.nextElement();
            if (nodeInfo.getNodeType() != 1 || !string.equals("*") && !string.equals(nodeInfo.getURI()) || !string2.equals("*") && !string2.equals(nodeInfo.getLocalName())) continue;
            nodeSetExtent.append(nodeInfo);
        }
        return nodeSetExtent;
    }

    public Element getElementById(String string) {
        return (Element)((Object)this.getDocumentRoot().selectID(string));
    }

    public String getTagName() {
        return this.getDisplayName();
    }

    public String getAttribute(String string) {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)2, AnyNodeTest.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = axisEnumeration.nextElement();
            if (!nodeInfo.getDisplayName().equals(string)) continue;
            String string2 = nodeInfo.getStringValue();
            if (string2 == null) {
                return "";
            }
            return string2;
        }
        return "";
    }

    public Attr getAttributeNode(String string) {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)2, AnyNodeTest.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = axisEnumeration.nextElement();
            if (!nodeInfo.getDisplayName().equals(string)) continue;
            return (Attr)((Object)nodeInfo);
        }
        return null;
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public void removeAttribute(String string) throws DOMException {
        this.disallowUpdate();
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public String getAttributeNS(String string, String string2) {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return "";
        }
        return string3;
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        this.disallowUpdate();
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        int n = this.getDocumentRoot().getNamePool().getFingerprint(string, string2);
        if (n == -1) {
            return null;
        }
        NameTest nameTest = new NameTest(2, n);
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)2, nameTest);
        if (axisEnumeration.hasMoreElements()) {
            return (Attr)((Object)axisEnumeration.nextElement());
        }
        return null;
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public boolean hasAttribute(String string) {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)2, AnyNodeTest.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = axisEnumeration.nextElement();
            if (!nodeInfo.getDisplayName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeValue(string, string2) != null;
    }

    public String getData() {
        return this.getStringValue();
    }

    public void setData(String string) throws DOMException {
        this.disallowUpdate();
    }

    public int getLength() {
        return this.getStringValue().length();
    }

    public String substringData(int n, int n2) throws DOMException {
        try {
            return this.getStringValue().substring(n, n + n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, "substringData: index out of bounds");
        }
    }

    public void appendData(String string) throws DOMException {
        this.disallowUpdate();
    }

    public void insertData(int n, String string) throws DOMException {
        this.disallowUpdate();
    }

    public void deleteData(int n, int n2) throws DOMException {
        this.disallowUpdate();
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        this.disallowUpdate();
    }

    public Text splitText(int n) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getValue() {
        return this.getStringValue();
    }

    public boolean getSpecified() {
        return true;
    }

    public void setValue(String string) throws DOMException {
        this.disallowUpdate();
    }

    public Element getOwnerElement() {
        if (this.getNodeType() != 2) {
            throw new UnsupportedOperationException("This method is defined only on attribute nodes");
        }
        return (Element)((Object)this.getParent());
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public boolean isId() {
        return false;
    }

    @Override
    public short compareDocumentPosition(Node node) throws DOMException {
        if (node instanceof NodeInfo) {
            int n = this.compareOrder((NodeInfo)((Object)node));
            if (n == 0) {
                return 0;
            }
            if (n < 0) {
                for (NodeInfo nodeInfo = ((NodeInfo)((Object)node)).getParent(); nodeInfo != null; nodeInfo = nodeInfo.getParent()) {
                    if (!nodeInfo.isSameNodeInfo(this)) continue;
                    return 16;
                }
                return 4;
            }
            for (NodeInfo nodeInfo = this.getParent(); nodeInfo != null; nodeInfo = nodeInfo.getParent()) {
                if (!nodeInfo.isSameNodeInfo(this)) continue;
                return 8;
            }
            return 2;
        }
        return 32;
    }

    @Override
    public Object getFeature(String string, String string2) {
        return null;
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getStringValue();
    }

    @Override
    public Object getUserData(String string) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        NodeInfo nodeInfo;
        for (nodeInfo = this; nodeInfo != null && nodeInfo.getNodeType() != 1; nodeInfo = nodeInfo.getParent()) {
        }
        if (nodeInfo == null) {
            return false;
        }
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)8, AnyNodeTest.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo2 = axisEnumeration.nextElement();
            if (!nodeInfo2.getStringValue().equals(string)) continue;
            return nodeInfo2.getLocalName().equals("");
        }
        return false;
    }

    @Override
    public boolean isEqualNode(Node node) {
        throw new UnsupportedOperationException("isEqualNode() is not supported");
    }

    @Override
    public boolean isSameNode(Node node) {
        if (node instanceof NodeInfo) {
            return this.isSameNodeInfo((NodeInfo)((Object)node));
        }
        return false;
    }

    @Override
    public String lookupNamespaceURI(String string) {
        NodeInfo nodeInfo;
        if (string == null) {
            string = "";
        }
        for (nodeInfo = this; nodeInfo != null && nodeInfo.getNodeType() != 1; nodeInfo = nodeInfo.getParent()) {
        }
        if (nodeInfo == null) {
            return null;
        }
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)8, AnyNodeTest.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo2 = axisEnumeration.nextElement();
            if (!nodeInfo2.getLocalName().equals(string)) continue;
            return nodeInfo2.getStringValue();
        }
        return null;
    }

    @Override
    public String lookupPrefix(String string) {
        NodeInfo nodeInfo;
        for (nodeInfo = this; nodeInfo != null && nodeInfo.getNodeType() != 1; nodeInfo = nodeInfo.getParent()) {
        }
        if (nodeInfo == null) {
            return null;
        }
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)8, AnyNodeTest.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo2 = axisEnumeration.nextElement();
            if (!nodeInfo2.getStringValue().equals(string)) continue;
            return nodeInfo2.getLocalName();
        }
        return null;
    }

    @Override
    public void setTextContent(String string) throws DOMException {
        this.disallowUpdate();
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        this.disallowUpdate();
        return null;
    }

    public String getWholeText() {
        return this.getStringValue();
    }

    public boolean isElementContentWhitespace() {
        return false;
    }

    public Text replaceWholeText(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public void setIdAttribute(String string, boolean bl) throws DOMException {
        this.disallowUpdate();
    }

    public void setIdAttributeNode(Attr attr, boolean bl) throws DOMException {
        this.disallowUpdate();
    }

    public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
        this.disallowUpdate();
    }

    private class AttributeMap
    implements NamedNodeMap {
        private AttributeMap() {
        }

        @Override
        public Node getNamedItem(String string) {
            AxisEnumeration axisEnumeration = AbstractNode.this.getEnumeration((byte)2, AnyNodeTest.getInstance());
            while (axisEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = axisEnumeration.nextElement();
                if (!string.equals(nodeInfo.getDisplayName())) continue;
                return (Node)((Object)nodeInfo);
            }
            return null;
        }

        @Override
        public Node item(int n) {
            if (n < 0) {
                return null;
            }
            int n2 = 0;
            AxisEnumeration axisEnumeration = AbstractNode.this.getEnumeration((byte)2, AnyNodeTest.getInstance());
            while (axisEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = axisEnumeration.nextElement();
                if (n2 == n) {
                    return (Node)((Object)nodeInfo);
                }
                ++n2;
            }
            return null;
        }

        @Override
        public int getLength() {
            int n = 0;
            AxisEnumeration axisEnumeration = AbstractNode.this.getEnumeration((byte)2, AnyNodeTest.getInstance());
            while (axisEnumeration.hasMoreElements()) {
                axisEnumeration.nextElement();
                ++n;
            }
            return n;
        }

        @Override
        public Node getNamedItemNS(String string, String string2) {
            if (string == null) {
                string = "";
            }
            AxisEnumeration axisEnumeration = AbstractNode.this.getEnumeration((byte)2, AnyNodeTest.getInstance());
            while (axisEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = axisEnumeration.nextElement();
                if (!string.equals(nodeInfo.getURI()) || !string2.equals(nodeInfo.getLocalName())) continue;
                return (Node)((Object)nodeInfo);
            }
            return null;
        }

        @Override
        public Node setNamedItem(Node node) throws DOMException {
            AbstractNode.this.disallowUpdate();
            return null;
        }

        @Override
        public Node removeNamedItem(String string) throws DOMException {
            AbstractNode.this.disallowUpdate();
            return null;
        }

        @Override
        public Node setNamedItemNS(Node node) throws DOMException {
            AbstractNode.this.disallowUpdate();
            return null;
        }

        @Override
        public Node removeNamedItemNS(String string, String string2) throws DOMException {
            AbstractNode.this.disallowUpdate();
            return null;
        }
    }

    private class DOMImplementationImpl
    implements DOMImplementation {
        private DOMImplementationImpl() {
        }

        @Override
        public boolean hasFeature(String string, String string2) {
            return false;
        }

        @Override
        public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
            AbstractNode.this.disallowUpdate();
            return null;
        }

        @Override
        public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
            AbstractNode.this.disallowUpdate();
            return null;
        }

        @Override
        public Object getFeature(String string, String string2) {
            return null;
        }
    }
}

