/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.ProxyEmitter;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class DTDEmitter
extends ProxyEmitter {
    private String current = null;
    private boolean openSquare = false;
    private StringBuffer buffer = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        String string = this.namePool.getURI(n);
        String string2 = this.namePool.getLocalName(n);
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            if (!this.namePool.getURIFromNamespaceCode(nArray[i]).equals("http://icl.com/saxon/dtd")) continue;
            n3 = i;
            break;
        }
        if (n3 > 0) {
            nArray[n3] = nArray[n2 - 1];
            --n2;
        }
        if (string.equals("http://icl.com/saxon/dtd")) {
            if ("doctype".equals(this.current) && !this.openSquare) {
                this.write(" [");
                this.openSquare = true;
            }
            if (string2.equals("doctype")) {
                this.buffer = new StringBuffer();
                if (this.current != null) {
                    throw new TransformerException("dtd:doctype can only appear at top level of DTD");
                }
                String string3 = attributes.getValue("name");
                String string4 = attributes.getValue("system");
                String string5 = attributes.getValue("public");
                if (string3 == null) {
                    throw new TransformerException("dtd:doctype must have a name attribute");
                }
                this.write("<!DOCTYPE " + string3 + " ");
                if (string4 != null) {
                    if (string5 != null) {
                        this.write("PUBLIC \"" + string5 + "\" \"" + string4 + "\"");
                    } else {
                        this.write("SYSTEM \"" + string4 + "\"");
                    }
                }
            } else if (string2.equals("element")) {
                if (!"doctype".equals(this.current)) {
                    throw new TransformerException("dtd:element can only appear as child of dtd:doctype");
                }
                String string6 = attributes.getValue("name");
                String string7 = attributes.getValue("content");
                if (string6 == null) {
                    throw new TransformerException("dtd:element must have a name attribute");
                }
                if (string7 == null) {
                    throw new TransformerException("dtd:element must have a content attribute");
                }
                this.write("\n  <!ELEMENT " + string6 + " " + string7 + " ");
            } else if (string2.equals("attlist")) {
                if (!"doctype".equals(this.current)) {
                    throw new TransformerException("dtd:attlist can only appear as child of dtd:doctype");
                }
                String string8 = attributes.getValue("element");
                if (string8 == null) {
                    throw new TransformerException("dtd:attlist must have an attribute named 'element'");
                }
                this.write("\n  <!ATTLIST " + string8 + " ");
            } else if (string2.equals("attribute")) {
                if (!"attlist".equals(this.current)) {
                    throw new TransformerException("dtd:attribute can only appear as child of dtd:attlist");
                }
                String string9 = attributes.getValue("name");
                String string10 = attributes.getValue("type");
                String string11 = attributes.getValue("value");
                if (string9 == null) {
                    throw new TransformerException("dtd:attribute must have a name attribute");
                }
                if (string10 == null) {
                    throw new TransformerException("dtd:attribute must have a type attribute");
                }
                if (string11 == null) {
                    throw new TransformerException("dtd:attribute must have a value attribute");
                }
                this.write("\n    " + string9 + " " + string10 + " " + string11);
            } else if (string2.equals("entity")) {
                if (!"doctype".equals(this.current)) {
                    throw new TransformerException("dtd:entity can only appear as child of dtd:doctype");
                }
                String string12 = attributes.getValue("name");
                String string13 = attributes.getValue("parameter");
                String string14 = attributes.getValue("system");
                String string15 = attributes.getValue("public");
                String string16 = attributes.getValue("notation");
                if (string12 == null) {
                    throw new TransformerException("dtd:entity must have a name attribute");
                }
                this.write("\n  <!ENTITY ");
                if ("yes".equals(string13)) {
                    this.write("% ");
                }
                this.write(string12 + " ");
                if (string14 != null) {
                    if (string15 != null) {
                        this.write("PUBLIC \"" + string15 + "\" \"" + string14 + "\" ");
                    } else {
                        this.write("SYSTEM \"" + string14 + "\" ");
                    }
                }
                if (string16 != null) {
                    this.write("NDATA " + string16 + " ");
                }
            } else {
                if (!string2.equals("notation")) throw new TransformerException("Unrecognized element " + string2 + " in DTD output");
                if (!"doctype".equals(this.current)) {
                    throw new TransformerException("dtd:notation can only appear as a child of dtd:doctype");
                }
                String string17 = attributes.getValue("name");
                String string18 = attributes.getValue("system");
                String string19 = attributes.getValue("public");
                if (string17 == null) {
                    throw new TransformerException("dtd:notation must have a name attribute");
                }
                if (string18 == null && string19 == null) {
                    throw new TransformerException("dtd:notation must have a system attribute or a public attribute");
                }
                this.write("\n  <!NOTATION " + string17);
                if (string19 != null) {
                    this.write(" PUBLIC \"" + string19 + "\" ");
                    if (string18 != null) {
                        this.write("\"" + string18 + "\" ");
                    }
                } else {
                    this.write(" SYSTEM \"" + string18 + "\" ");
                }
            }
        } else {
            if (!this.current.equals("entity")) {
                throw new TransformerException("Unrecognized element " + string2 + " in DTD output");
            }
            super.startElement(n, attributes, nArray, n2);
        }
        this.current = string2;
    }

    @Override
    public void endElement(int n) throws TransformerException {
        String string = this.namePool.getURI(n);
        if (string.equals("http://icl.com/saxon/dtd")) {
            String string2 = this.namePool.getLocalName(n);
            if (string2.equals("doctype")) {
                if (this.openSquare) {
                    this.write("\n]");
                    this.openSquare = false;
                }
                this.write(">\n");
                this.current = null;
                this.flush();
            } else if (string2.equals("element")) {
                this.write(">");
                this.current = "doctype";
            } else if (string2.equals("attlist")) {
                this.write(">");
                this.current = "doctype";
            } else if (string2.equals("attribute")) {
                this.current = "attlist";
            } else if (string2.equals("entity")) {
                this.write(">");
                this.current = "doctype";
            } else if (string2.equals("notation")) {
                this.write(">");
                this.current = "doctype";
            }
        } else {
            super.endElement(n);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        if (this.buffer != null) {
            this.buffer.append(cArray, n, n2);
        } else {
            super.characters(cArray, n, n2);
        }
    }

    private void write(String string) {
        this.buffer.append(string);
    }

    private void flush() throws TransformerException {
        int n = this.buffer.length();
        char[] cArray = new char[n];
        this.buffer.getChars(0, n, cArray, 0);
        this.buffer = null;
        this.setEscaping(false);
        this.characters(cArray, 0, n);
        this.setEscaping(true);
    }
}

