/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.sort;

import com.icl.saxon.sort.Comparer;
import com.icl.saxon.sort.DoubleComparer;
import com.icl.saxon.sort.StringComparer;
import com.icl.saxon.sort.UppercaseFirstComparer;
import java.util.Vector;

public class BinaryTree {
    private BinaryTreeNode root = null;
    private Comparer comparer;
    private BinaryTreeNode prev;
    private boolean ascending = true;
    private boolean allowDuplicates = false;

    public void setAscending(boolean bl) {
        this.ascending = bl;
    }

    public void setDuplicatesAllowed(boolean bl) {
        this.allowDuplicates = bl;
    }

    public void setComparer(Comparer comparer) {
        if (this.isEmpty()) {
            this.comparer = comparer;
        }
    }

    public Vector getValues() {
        BinaryTreeNode binaryTreeNode = this.root;
        Vector vector = new Vector();
        this.getValues(this.root, vector);
        return vector;
    }

    private void getValues(BinaryTreeNode binaryTreeNode, Vector vector) {
        if (binaryTreeNode != null) {
            this.getValues(binaryTreeNode.left, vector);
            if (!binaryTreeNode.isDeleted()) {
                vector.addElement(binaryTreeNode.value);
            }
            this.getValues(binaryTreeNode.right, vector);
        }
    }

    public Vector getKeys() {
        BinaryTreeNode binaryTreeNode = this.root;
        Vector vector = new Vector();
        this.getKeys(this.root, vector);
        return vector;
    }

    private void getKeys(BinaryTreeNode binaryTreeNode, Vector vector) {
        if (binaryTreeNode != null) {
            this.getKeys(binaryTreeNode.left, vector);
            if (!binaryTreeNode.isDeleted()) {
                vector.addElement(binaryTreeNode.key);
            }
            this.getKeys(binaryTreeNode.right, vector);
        }
    }

    public Object get(Object object) {
        BinaryTreeNode binaryTreeNode = this.find(object);
        return binaryTreeNode == null ? null : binaryTreeNode.value;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        BinaryTreeNode binaryTreeNode = this.root;
        if (this.comparer == null) {
            this.comparer = new StringComparer();
        }
        if (this.root == null) {
            this.root = new BinaryTreeNode(object, object2);
            return null;
        }
        while (true) {
            int n = this.comparer.compare(binaryTreeNode.key, object);
            if (!this.ascending) {
                n = 0 - n;
            }
            if (n == 0 && this.allowDuplicates) {
                n = -1;
            }
            if (n > 0) {
                if (binaryTreeNode.left == null) {
                    binaryTreeNode.left = new BinaryTreeNode(object, object2);
                    return null;
                }
                binaryTreeNode = binaryTreeNode.left;
            }
            if (n == 0) {
                Object object3 = binaryTreeNode.value;
                binaryTreeNode.value = object2;
                return object3;
            }
            if (n >= 0) continue;
            if (binaryTreeNode.right == null) {
                binaryTreeNode.right = new BinaryTreeNode(object, object2);
                return null;
            }
            binaryTreeNode = binaryTreeNode.right;
        }
    }

    public Object remove(Object object) {
        BinaryTreeNode binaryTreeNode = this.find(object);
        if (binaryTreeNode == null) {
            return null;
        }
        Object object2 = binaryTreeNode.value;
        binaryTreeNode.delete();
        return object2;
    }

    public int size() {
        return this.count(this.root);
    }

    private int count(BinaryTreeNode binaryTreeNode) {
        if (binaryTreeNode == null) {
            return 0;
        }
        return this.count(binaryTreeNode.left) + (binaryTreeNode.isDeleted() ? 0 : 1) + this.count(binaryTreeNode.right);
    }

    private BinaryTreeNode find(Object object) {
        BinaryTreeNode binaryTreeNode = this.root;
        if (binaryTreeNode == null) {
            return null;
        }
        while (binaryTreeNode != null) {
            int n = this.comparer.compare(object, binaryTreeNode.key);
            if (n < 0) {
                binaryTreeNode = binaryTreeNode.left;
            }
            if (n == 0) {
                return binaryTreeNode.isDeleted() ? null : binaryTreeNode;
            }
            if (n <= 0) continue;
            binaryTreeNode = binaryTreeNode.right;
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        BinaryTree binaryTree = new BinaryTree();
        binaryTree.setComparer(new UppercaseFirstComparer());
        binaryTree.setAscending(true);
        binaryTree.setDuplicatesAllowed(true);
        binaryTree.put("a", "1");
        binaryTree.put("b", "2");
        binaryTree.put("c", "3");
        binaryTree.put("aa", "4");
        binaryTree.put("ab", "5");
        binaryTree.put("A", "6");
        binaryTree.put("A", "6a");
        binaryTree.put("B", "7");
        binaryTree.put("AA", "8");
        binaryTree.put("XYZ", "9");
        binaryTree.put("", "10");
        System.out.println(binaryTree.getKeys());
        System.out.println(binaryTree.getValues());
        binaryTree = new BinaryTree();
        binaryTree.setComparer(new DoubleComparer());
        binaryTree.setAscending(false);
        binaryTree.put(new Double(1.43), "1");
        binaryTree.put(new Double(84.2), "2");
        binaryTree.put(new Double(-100.0), "3");
        binaryTree.put(new Double(0.0), "4");
        System.out.println(binaryTree.getKeys());
        System.out.println(binaryTree.getValues());
    }

    private class BinaryTreeNode {
        BinaryTreeNode left = null;
        BinaryTreeNode right = null;
        Object key;
        Object value;

        public BinaryTreeNode(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public boolean isDeleted() {
            return this.value == null;
        }

        public void delete() {
            this.value = null;
        }
    }
}

