/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect.util;

import com.cybozu.labs.langdetect.util.NGram;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class LangProfile {
    private static final int MINIMUM_FREQ = 2;
    private static final int LESS_FREQ_RATIO = 100000;
    public String name = null;
    public HashMap<String, Integer> freq = new HashMap();
    public int[] n_words = new int[3];

    public LangProfile() {
    }

    public LangProfile(String name) {
        this.name = name;
    }

    public void add(String gram) {
        if (this.name == null || gram == null) {
            return;
        }
        int len = gram.length();
        if (len < 1 || len > 3) {
            return;
        }
        int n = len - 1;
        this.n_words[n] = this.n_words[n] + 1;
        if (this.freq.containsKey(gram)) {
            this.freq.put(gram, this.freq.get(gram) + 1);
        } else {
            this.freq.put(gram, 1);
        }
    }

    public void omitLessFreq() {
        if (this.name == null) {
            return;
        }
        int threshold = this.n_words[0] / 100000;
        if (threshold < 2) {
            threshold = 2;
        }
        Set<String> keys = this.freq.keySet();
        int roman = 0;
        Iterator<String> i = keys.iterator();
        while (i.hasNext()) {
            String key = i.next();
            int count = this.freq.get(key);
            if (count <= threshold) {
                int n = key.length() - 1;
                this.n_words[n] = this.n_words[n] - count;
                i.remove();
                continue;
            }
            if (!key.matches("^[A-Za-z]$")) continue;
            roman += count;
        }
        if (roman < this.n_words[0] / 3) {
            Set<String> keys2 = this.freq.keySet();
            Iterator<String> i2 = keys2.iterator();
            while (i2.hasNext()) {
                String key = i2.next();
                if (!key.matches(".*[A-Za-z].*")) continue;
                int n = key.length() - 1;
                this.n_words[n] = this.n_words[n] - this.freq.get(key);
                i2.remove();
            }
        }
    }

    public void update(String text) {
        if (text == null) {
            return;
        }
        text = NGram.normalize_vi(text);
        NGram gram = new NGram();
        int i = 0;
        while (i < text.length()) {
            gram.addChar(text.charAt(i));
            int n = 1;
            while (n <= 3) {
                this.add(gram.get(n));
                ++n;
            }
            ++i;
        }
    }
}

