/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetBuilder;
import org.apache.solr.search.DocSetProducer;
import org.apache.solr.search.DocSetUtil;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.Filter;
import org.apache.solr.search.SolrIndexSearcher;

public final class SolrRangeQuery
extends ExtendedQueryBase
implements DocSetProducer {
    private final String field;
    private final BytesRef lower;
    private final BytesRef upper;
    private byte flags;
    private static byte FLAG_INC_LOWER = 1;
    private static byte FLAG_INC_UPPER = (byte)2;

    public SolrRangeQuery(String field, BytesRef lower, BytesRef upper, boolean includeLower, boolean includeUpper) {
        this.field = field;
        this.lower = lower;
        this.upper = upper;
        this.flags = (byte)((this.lower != null && includeLower ? FLAG_INC_LOWER : (byte)0) | (this.upper != null && includeUpper ? FLAG_INC_UPPER : (byte)0));
    }

    public String getField() {
        return this.field;
    }

    public boolean includeLower() {
        return (this.flags & FLAG_INC_LOWER) != 0;
    }

    public boolean includeUpper() {
        return (this.flags & FLAG_INC_UPPER) != 0;
    }

    public int hashCode() {
        int hash = -1892901977 * (this.flags + 1);
        hash = hash * 29 + (this.lower == null ? 0 : this.lower.hashCode());
        hash = hash * 29 + (this.upper == null ? 0 : this.upper.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SolrRangeQuery)) {
            return false;
        }
        SolrRangeQuery other = (SolrRangeQuery)obj;
        return this.flags == other.flags && this.field.equals(other.field) && (this.lower == other.lower || this.lower != null && other.lower != null && this.lower.equals((Object)other.lower)) && (this.upper == other.upper || this.upper != null && other.upper != null && this.upper.equals((Object)other.upper));
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.includeLower() ? (char)'[' : '{');
        buffer.append(this.endpoint(this.lower));
        buffer.append(" TO ");
        buffer.append(this.endpoint(this.upper));
        buffer.append(this.includeUpper() ? (char)']' : '}');
        return buffer.toString();
    }

    private String endpoint(BytesRef ref) {
        if (ref == null) {
            return "*";
        }
        String toStr = Term.toString((BytesRef)ref);
        if ("*".equals(toStr)) {
            toStr = "\\*";
        }
        return toStr;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needScores) throws IOException {
        return new ConstWeight(searcher, needScores);
    }

    @Override
    public DocSet createDocSet(SolrIndexSearcher searcher) throws IOException {
        return this.createDocSet(searcher, Math.min(64, (searcher.maxDoc() >>> 10) + 4));
    }

    private DocSet createDocSet(SolrIndexSearcher searcher, long cost) throws IOException {
        int maxDoc = searcher.maxDoc();
        BitDocSet liveDocs = searcher.getLiveDocs();
        FixedBitSet liveBits = liveDocs.size() == maxDoc ? null : liveDocs.getBits();
        DocSetBuilder builder = new DocSetBuilder(maxDoc, cost);
        List leaves = searcher.getTopReaderContext().leaves();
        int maxTermsPerSegment = 0;
        for (LeafReaderContext ctx : leaves) {
            TermsEnum te = this.getTermsEnum(ctx);
            int termsVisited = builder.add(te, ctx.docBase);
            maxTermsPerSegment = Math.max(maxTermsPerSegment, termsVisited);
        }
        DocSet set = maxTermsPerSegment <= 1 ? builder.buildUniqueInOrder(liveBits) : builder.build(liveBits);
        return DocSetUtil.getDocSet(set, searcher);
    }

    public TermsEnum getTermsEnum(LeafReaderContext ctx) throws IOException {
        return new RangeTermsEnum(ctx.reader().terms(this.getField()));
    }

    class ConstWeight
    extends ConstantScoreWeight {
        private static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;
        final IndexSearcher searcher;
        final boolean needScores;
        boolean checkedFilterCache;
        Filter filter;
        final SegState[] segStates;

        protected ConstWeight(IndexSearcher searcher, boolean needScores) {
            super((Query)SolrRangeQuery.this);
            this.searcher = searcher;
            this.segStates = new SegState[searcher.getIndexReader().leaves().size()];
            this.needScores = needScores;
        }

        private long collectTerms(LeafReaderContext context, TermsEnum termsEnum, List<TermAndState> terms) throws IOException {
            long count = 0L;
            int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
            for (int i = 0; i < threshold; ++i) {
                BytesRef term = termsEnum.next();
                if (term == null) {
                    return -count - 1L;
                }
                TermState state = termsEnum.termState();
                int df = termsEnum.docFreq();
                count += (long)df;
                terms.add(new TermAndState(BytesRef.deepCopyOf((BytesRef)term), state, df, termsEnum.totalTermFreq()));
            }
            return termsEnum.next() == null ? -count - 1L : count;
        }

        private SegState getSegState(LeafReaderContext context) throws IOException {
            SegState segState = this.segStates[context.ord];
            if (segState != null) {
                return segState;
            }
            boolean doCheck = !this.checkedFilterCache && context.ord == 0;
            this.checkedFilterCache = true;
            SolrIndexSearcher solrSearcher = null;
            if (doCheck && this.searcher instanceof SolrIndexSearcher) {
                solrSearcher = (SolrIndexSearcher)this.searcher;
                if (solrSearcher.getFilterCache() == null) {
                    doCheck = false;
                } else {
                    solrSearcher = (SolrIndexSearcher)this.searcher;
                    DocSet answer = solrSearcher.getFilterCache().get(SolrRangeQuery.this);
                    if (answer != null) {
                        this.filter = answer.getTopFilter();
                    }
                }
            } else {
                doCheck = false;
            }
            if (this.filter != null) {
                this.segStates[context.ord] = new SegState(this.filter.getDocIdSet(context, null));
                return this.segStates[context.ord];
            }
            Terms terms = context.reader().terms(SolrRangeQuery.this.getField());
            if (terms == null) {
                this.segStates[context.ord] = new SegState((DocIdSet)null);
                return this.segStates[context.ord];
            }
            TermsEnum termsEnum = SolrRangeQuery.this.getTermsEnum(context);
            PostingsEnum docs = null;
            ArrayList<TermAndState> collectedTerms = new ArrayList<TermAndState>();
            long count = this.collectTerms(context, termsEnum, collectedTerms);
            if (count < 0L) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                for (TermAndState t : collectedTerms) {
                    TermContext termContext = new TermContext(this.searcher.getTopReaderContext());
                    termContext.register(t.state, context.ord, t.docFreq, t.totalTermFreq);
                    bq.add((Query)new TermQuery(new Term(SolrRangeQuery.this.getField(), t.term), termContext), BooleanClause.Occur.SHOULD);
                }
                ConstantScoreQuery q = new ConstantScoreQuery((Query)bq.build());
                Weight weight = this.searcher.rewrite((Query)q).createWeight(this.searcher, this.needScores);
                weight.normalize(1.0f, this.score());
                this.segStates[context.ord] = new SegState(weight);
                return this.segStates[context.ord];
            }
            if (doCheck) {
                DocSet answer = SolrRangeQuery.this.createDocSet(solrSearcher, count);
                solrSearcher.getFilterCache().put(SolrRangeQuery.this, answer);
                this.filter = answer.getTopFilter();
                this.segStates[context.ord] = new SegState(this.filter.getDocIdSet(context, null));
                return this.segStates[context.ord];
            }
            DocIdSetBuilder builder = new DocIdSetBuilder(context.reader().maxDoc(), terms);
            builder.grow((int)Math.min(Integer.MAX_VALUE, count));
            if (!collectedTerms.isEmpty()) {
                TermsEnum termsEnum2 = terms.iterator();
                for (TermAndState t : collectedTerms) {
                    termsEnum2.seekExact(t.term, t.state);
                    docs = termsEnum2.postings(docs, 0);
                    builder.add((DocIdSetIterator)docs);
                }
            }
            do {
                docs = termsEnum.postings(docs, 0);
                builder.add((DocIdSetIterator)docs);
            } while (termsEnum.next() != null);
            DocIdSet segSet = builder.build();
            this.segStates[context.ord] = new SegState(segSet);
            return this.segStates[context.ord];
        }

        private Scorer scorer(DocIdSet set) throws IOException {
            if (set == null) {
                return null;
            }
            DocIdSetIterator disi = set.iterator();
            if (disi == null) {
                return null;
            }
            return new ConstantScoreScorer((Weight)this, this.score(), disi);
        }

        public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
            SegState weightOrBitSet = this.getSegState(context);
            if (weightOrBitSet.weight != null) {
                return weightOrBitSet.weight.bulkScorer(context);
            }
            Scorer scorer = this.scorer(weightOrBitSet.set);
            if (scorer == null) {
                return null;
            }
            return new Weight.DefaultBulkScorer(scorer);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            SegState weightOrBitSet = this.getSegState(context);
            if (weightOrBitSet.weight != null) {
                return weightOrBitSet.weight.scorer(context);
            }
            return this.scorer(weightOrBitSet.set);
        }
    }

    private static class SegState {
        final Weight weight;
        final DocIdSet set;

        SegState(Weight weight) {
            this.weight = weight;
            this.set = null;
        }

        SegState(DocIdSet set) {
            this.set = set;
            this.weight = null;
        }
    }

    private static class TermAndState {
        final BytesRef term;
        final TermState state;
        final int docFreq;
        final long totalTermFreq;

        TermAndState(BytesRef term, TermState state, int docFreq, long totalTermFreq) {
            this.term = term;
            this.state = state;
            this.docFreq = docFreq;
            this.totalTermFreq = totalTermFreq;
        }
    }

    private class RangeTermsEnum
    extends TermsEnum {
        TermsEnum te;
        BytesRef curr;
        boolean positioned;

        public RangeTermsEnum(Terms terms) throws IOException {
            if (terms == null) {
                this.positioned = true;
            } else {
                this.te = terms.iterator();
                if (SolrRangeQuery.this.lower != null) {
                    TermsEnum.SeekStatus status = this.te.seekCeil(SolrRangeQuery.this.lower);
                    if (status == TermsEnum.SeekStatus.END) {
                        this.positioned = true;
                        this.curr = null;
                    } else if (status == TermsEnum.SeekStatus.FOUND) {
                        this.positioned = SolrRangeQuery.this.includeLower();
                        this.curr = this.te.term();
                    } else {
                        this.positioned = true;
                        this.curr = this.te.term();
                    }
                }
            }
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            return this.te.seekCeil(text);
        }

        public void seekExact(long ord) throws IOException {
            this.te.seekExact(ord);
        }

        public BytesRef term() throws IOException {
            return this.te.term();
        }

        public long ord() throws IOException {
            return this.te.ord();
        }

        public int docFreq() throws IOException {
            return this.te.docFreq();
        }

        public long totalTermFreq() throws IOException {
            return this.te.totalTermFreq();
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            return this.te.postings(reuse, flags);
        }

        public BytesRef next() throws IOException {
            if (this.positioned) {
                this.positioned = false;
            } else {
                this.curr = this.te.next();
            }
            if (this.curr == null) {
                return null;
            }
            if (SolrRangeQuery.this.upper != null) {
                int cmp = this.curr.compareTo(SolrRangeQuery.this.upper);
                if (cmp < 0 || cmp == 0 && SolrRangeQuery.this.includeUpper()) {
                    return this.curr;
                }
                this.curr = null;
            }
            return this.curr;
        }

        public AttributeSource attributes() {
            return this.te.attributes();
        }

        public boolean seekExact(BytesRef text) throws IOException {
            return this.te.seekExact(text);
        }

        public void seekExact(BytesRef term, TermState state) throws IOException {
            this.te.seekExact(term, state);
        }

        public TermState termState() throws IOException {
            return this.te.termState();
        }
    }
}

