/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.Map;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetParser;
import org.apache.solr.search.facet.FacetRequest;

class FacetFieldParser
extends FacetParser<FacetField> {
    public FacetFieldParser(FacetParser parent, String key) {
        super(parent, key);
        this.facet = new FacetField();
    }

    @Override
    public FacetField parse(Object arg) throws SyntaxError {
        this.parseCommonParams(arg);
        if (arg instanceof String) {
            ((FacetField)this.facet).field = (String)arg;
            this.parseSort(null);
        } else if (arg instanceof Map) {
            Map m = (Map)arg;
            ((FacetField)this.facet).field = this.getField(m);
            ((FacetField)this.facet).offset = this.getLong(m, "offset", ((FacetField)this.facet).offset);
            ((FacetField)this.facet).limit = this.getLong(m, "limit", ((FacetField)this.facet).limit);
            ((FacetField)this.facet).overrequest = (int)this.getLong(m, "overrequest", ((FacetField)this.facet).overrequest);
            if (((FacetField)this.facet).limit == 0L) {
                ((FacetField)this.facet).offset = 0L;
            }
            ((FacetField)this.facet).mincount = this.getLong(m, "mincount", ((FacetField)this.facet).mincount);
            ((FacetField)this.facet).missing = this.getBoolean(m, "missing", ((FacetField)this.facet).missing);
            ((FacetField)this.facet).numBuckets = this.getBoolean(m, "numBuckets", ((FacetField)this.facet).numBuckets);
            ((FacetField)this.facet).prefix = this.getString(m, "prefix", ((FacetField)this.facet).prefix);
            ((FacetField)this.facet).allBuckets = this.getBoolean(m, "allBuckets", ((FacetField)this.facet).allBuckets);
            ((FacetField)this.facet).method = FacetField.FacetMethod.fromString(this.getString(m, "method", null));
            ((FacetField)this.facet).cacheDf = (int)this.getLong(m, "cacheDf", ((FacetField)this.facet).cacheDf);
            ((FacetField)this.facet).refine = FacetRequest.RefineMethod.fromObj(m.get("refine"));
            ((FacetField)this.facet).perSeg = (Boolean)m.get("perSeg");
            Object o = m.get("facet");
            this.parseSubs(o);
            this.parseSort(m.get("sort"));
        }
        return (FacetField)this.facet;
    }

    private void parseSort(Object sort) {
        if (sort == null) {
            ((FacetField)this.facet).sortVariable = "count";
            ((FacetField)this.facet).sortDirection = FacetRequest.SortDirection.desc;
        } else if (sort instanceof String) {
            String sortStr = (String)sort;
            if (sortStr.endsWith(" asc")) {
                ((FacetField)this.facet).sortVariable = sortStr.substring(0, sortStr.length() - " asc".length());
                ((FacetField)this.facet).sortDirection = FacetRequest.SortDirection.asc;
            } else if (sortStr.endsWith(" desc")) {
                ((FacetField)this.facet).sortVariable = sortStr.substring(0, sortStr.length() - " desc".length());
                ((FacetField)this.facet).sortDirection = FacetRequest.SortDirection.desc;
            } else {
                ((FacetField)this.facet).sortVariable = sortStr;
                ((FacetField)this.facet).sortDirection = "index".equals(((FacetField)this.facet).sortVariable) ? FacetRequest.SortDirection.asc : FacetRequest.SortDirection.desc;
            }
        } else {
            Map map = (Map)sort;
            Map.Entry entry = map.entrySet().iterator().next();
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            ((FacetField)this.facet).sortVariable = k;
            ((FacetField)this.facet).sortDirection = FacetRequest.SortDirection.valueOf(v.toString());
        }
    }
}

