/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.lang.invoke.MethodHandles;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.solr.common.util.SuppressForbidden;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

final class StartupLoggingUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final StaticLoggerBinder binder = StaticLoggerBinder.getSingleton();

    StartupLoggingUtils() {
    }

    static void checkLogDir() {
        if (System.getProperty("solr.log.dir") == null) {
            log.error("Missing Java Option solr.log.dir. Logging may be missing or incomplete.");
        }
    }

    @SuppressForbidden(reason="Legitimate log4j access")
    static boolean muteConsole() {
        try {
            if (!StartupLoggingUtils.isLog4jActive()) {
                StartupLoggingUtils.logNotSupported("Could not mute logging to console.");
                return false;
            }
            org.apache.log4j.Logger rootLogger = LogManager.getRootLogger();
            Enumeration appenders = rootLogger.getAllAppenders();
            while (appenders.hasMoreElements()) {
                Appender appender = (Appender)appenders.nextElement();
                if (!(appender instanceof ConsoleAppender)) continue;
                log.info("Property solr.log.muteconsole given. Muting ConsoleAppender named " + appender.getName());
                rootLogger.removeAppender(appender);
            }
            return true;
        }
        catch (Exception e) {
            StartupLoggingUtils.logNotSupported("Could not mute logging to console.");
            return false;
        }
    }

    @SuppressForbidden(reason="Legitimate log4j access")
    static boolean changeLogLevel(String logLevel) {
        try {
            if (!StartupLoggingUtils.isLog4jActive()) {
                StartupLoggingUtils.logNotSupported("Could not mute logging to console.");
                return false;
            }
            log.info("Log level override, property solr.log.level=" + logLevel);
            LogManager.getRootLogger().setLevel(Level.toLevel((String)logLevel, (Level)Level.INFO));
            return true;
        }
        catch (Exception e) {
            StartupLoggingUtils.logNotSupported("Could not change log level.");
            return false;
        }
    }

    private static boolean isLog4jActive() {
        try {
            Class.forName("org.apache.log4j.LogManager");
            return binder.getLoggerFactoryClassStr().contains("Log4jLoggerFactory");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void logNotSupported(String msg) {
        log.warn("{} Dynamic log manipulation currently only supported for Log4j. Please consult your logging framework of choice on how to configure the appropriate logging.", (Object)msg);
    }
}

