/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.common.util.StrUtils;

public class PathTrie<T> {
    private final Set<String> reserved = new HashSet<String>();
    Node root = new Node(Collections.emptyList(), null);

    public PathTrie() {
    }

    public PathTrie(Set<String> reserved) {
        this.reserved.addAll(reserved);
    }

    public void insert(String path, Map<String, String> replacements, T o) {
        List<String> parts = PathTrie.getPathSegments(path);
        this.insert(parts, replacements, o);
    }

    public void insert(List<String> parts, Map<String, String> replacements, T o) {
        if (parts.isEmpty()) {
            this.root.obj = o;
            return;
        }
        for (int i = 0; i < parts.size(); ++i) {
            String part = parts.get(i);
            if (part.charAt(0) != '$') continue;
            String replacement = replacements.get(part.substring(1));
            if (replacement == null) {
                throw new RuntimeException(part + " is not provided");
            }
            replacement = replacement.charAt(0) == '/' ? replacement.substring(1) : replacement;
            parts.set(i, replacement);
        }
        this.root.insert(parts, o);
    }

    public static List<String> getPathSegments(String path) {
        if (path == null || path.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> parts = new ArrayList<String>(){

            @Override
            public boolean add(String s) {
                if (s == null || s.isEmpty()) {
                    return false;
                }
                return super.add(s);
            }
        };
        StrUtils.splitSmart((String)path, (char)'/', (List)parts);
        return parts;
    }

    public T lookup(String path, Map<String, String> templateValues) {
        return this.root.lookup(PathTrie.getPathSegments(path), 0, templateValues);
    }

    public T lookup(List<String> path, Map<String, String> templateValues) {
        return this.root.lookup(path, 0, templateValues);
    }

    public T lookup(String path, Map<String, String> templateValues, Set<String> paths) {
        return this.root.lookup(PathTrie.getPathSegments(path), 0, templateValues, paths);
    }

    public static String templateName(String templateStr) {
        return templateStr.startsWith("{") && templateStr.endsWith("}") ? templateStr.substring(1, templateStr.length() - 1) : null;
    }

    class Node {
        String name;
        Map<String, Node> children;
        T obj;
        String templateName;

        Node(List<String> path, T o) {
            if (path.isEmpty()) {
                this.obj = o;
                return;
            }
            String part = path.get(0);
            this.templateName = PathTrie.templateName(part);
            this.name = part;
            if (path.isEmpty()) {
                this.obj = o;
            }
        }

        private synchronized void insert(List<String> path, T o) {
            String varName;
            String key;
            String part = path.get(0);
            Node matchedChild = null;
            if (this.children == null) {
                this.children = new ConcurrentHashMap<String, Node>();
            }
            if ((matchedChild = this.children.get(key = (varName = PathTrie.templateName(part)) == null ? part : "")) == null) {
                matchedChild = new Node(path, o);
                this.children.put(key, matchedChild);
            }
            if (varName != null && !matchedChild.templateName.equals(varName)) {
                throw new RuntimeException("wildcard name must be " + matchedChild.templateName);
            }
            path.remove(0);
            if (!path.isEmpty()) {
                matchedChild.insert(path, o);
            } else {
                matchedChild.obj = o;
            }
        }

        void findAvailableChildren(String path, Set<String> availableSubPaths) {
            if (availableSubPaths == null) {
                return;
            }
            if (this.children != null) {
                for (Node node : this.children.values()) {
                    if (node.obj == null) continue;
                    String s = path + "/" + node.name;
                    availableSubPaths.add(s);
                }
                for (Node node : this.children.values()) {
                    node.findAvailableChildren(path + "/" + node.name, availableSubPaths);
                }
            }
        }

        public T lookup(List<String> pieces, int i, Map<String, String> templateValues) {
            return this.lookup(pieces, i, templateValues, null);
        }

        public T lookup(List<String> pathSegments, int index, Map<String, String> templateVariables, Set<String> availableSubPaths) {
            if (this.templateName != null) {
                templateVariables.put(this.templateName, pathSegments.get(index - 1));
            }
            if (pathSegments.size() < index + 1) {
                this.findAvailableChildren("", availableSubPaths);
                return this.obj;
            }
            String piece = pathSegments.get(index);
            if (this.children == null) {
                return null;
            }
            Node n = this.children.get(piece);
            if (n == null && !PathTrie.this.reserved.contains(piece)) {
                n = this.children.get("");
            }
            if (n == null) {
                return null;
            }
            return n.lookup(pathSegments, index + 1, templateVariables, availableSubPaths);
        }
    }
}

