/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirPrimaryConstructorSuperTypeCheckerPlatformComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ(\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J \u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkSuperTypeNotInitialized", "primaryConstructorSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "regularClass", "checkSupertypeInitializedWithoutPrimaryConstructor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPrimaryConstructorSuperTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPrimaryConstructorSuperTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,120:1\n67#2:121\n34#3:122\n40#3:123\n57#4,11:124\n21#4,2:135\n*S KotlinDebug\n*F\n+ 1 FirPrimaryConstructorSuperTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker\n*L\n33#1:121\n33#1:122\n44#1:123\n70#1:124,11\n70#1:135,2\n*E\n"})
public final class FirPrimaryConstructorSuperTypeChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirPrimaryConstructorSuperTypeChecker INSTANCE = new FirPrimaryConstructorSuperTypeChecker();

    private FirPrimaryConstructorSuperTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirClass $this$isInterface$iv = declaration;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        if (bl) {
            SourceNavigator $this$check_u24lambda_u240 = SourceNavigator.Companion.forElement(declaration);
            boolean bl2 = false;
            for (FirTypeRef superTypeRef : declaration.getSuperTypeRefs()) {
                if (!$this$check_u24lambda_u240.isInConstructorCallee(superTypeRef)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_INTERFACE(), null, 8, null);
            }
            return;
        }
        ClassKind $this$isEnumEntry$iv = declaration.getClassKind();
        boolean $i$f$isEnumEntry = false;
        if ($this$isEnumEntry$iv == ClassKind.ENUM_ENTRY) {
            return;
        }
        FirConstructorSymbol primaryConstructorSymbol = org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.primaryConstructorIfAny(declaration, context2.getSession());
        if (primaryConstructorSymbol == null || FirDeclarationUtilKt.isErrorPrimaryConstructor(primaryConstructorSymbol)) {
            this.checkSupertypeInitializedWithoutPrimaryConstructor(declaration, reporter, context2);
        } else {
            this.checkSuperTypeNotInitialized(primaryConstructorSymbol, declaration, context2, reporter);
        }
    }

    private final void checkSuperTypeNotInitialized(FirConstructorSymbol primaryConstructorSymbol, FirClass regularClass, CheckerContext context2, DiagnosticReporter reporter) {
        FirTypeRef constructedTypeRef;
        FirDelegatedConstructorCall delegatedConstructorCall;
        FirRegularClass containingClass;
        block19: {
            block18: {
                Iterator<Object> iterator2;
                block17: {
                    Iterable $this$lastIsInstanceOrNull$iv = context2.getContainingDeclarations();
                    boolean $i$f$lastIsInstanceOrNull = false;
                    if ($this$lastIsInstanceOrNull$iv instanceof List) {
                        int n2 = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                        if (0 <= n2) {
                            do {
                                int i$iv;
                                Iterator<Object> element$iv;
                                if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n2--)) instanceof FirRegularClass)) continue;
                                iterator2 = element$iv;
                                break block17;
                            } while (0 <= n2);
                        }
                        iterator2 = null;
                    } else {
                        Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed($this$lastIsInstanceOrNull$iv);
                        boolean $i$f$firstIsInstanceOrNull = false;
                        for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                            if (!(element$iv$iv instanceof FirRegularClass)) continue;
                            iterator2 = (Iterator<Object>)element$iv$iv;
                            break block17;
                        }
                        iterator2 = null;
                    }
                }
                containingClass = (FirRegularClass)((Object)iterator2);
                FirDelegatedConstructorCall firDelegatedConstructorCall = primaryConstructorSymbol.getResolvedDelegatedConstructorCall();
                if (firDelegatedConstructorCall == null) {
                    return;
                }
                delegatedConstructorCall = firDelegatedConstructorCall;
                constructedTypeRef = delegatedConstructorCall.getConstructedTypeRef();
                if (constructedTypeRef instanceof FirImplicitAnyTypeRef) break block18;
                KtSourceElement ktSourceElement = constructedTypeRef.getSource();
                if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.PluginGenerated.INSTANCE)) break block19;
            }
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType(constructedTypeRef), context2.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol superClassSymbol = firRegularClassSymbol;
        if (superClassSymbol.getClassKind().isSingleton()) {
            return;
        }
        if (DeclarationUtilsKt.isEffectivelyExpect(regularClass, (FirClass)containingClass, context2) || DeclarationUtilsKt.isEffectivelyExternal(regularClass, (FirClass)containingClass, context2)) {
            return;
        }
        KtSourceElement ktSourceElement = delegatedConstructorCall.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement delegatedCallSource = ktSourceElement;
        if (!(delegatedCallSource.getKind() instanceof KtFakeSourceElementKind)) {
            return;
        }
        Set<ClassId> supertypesToSkip = FirPrimaryConstructorSuperTypeCheckerPlatformComponentKt.getPrimaryConstructorSuperTypePlatformSupport(context2.getSession()).getSupertypesThatDontNeedInitializationInSubtypesConstructors();
        if (supertypesToSkip.contains(superClassSymbol.getClassId())) {
            return;
        }
        if (!Intrinsics.areEqual(delegatedCallSource.getElementType(), KtNodeTypes.SUPER_TYPE_CALL_ENTRY)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)constructedTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_NOT_INITIALIZED(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkSupertypeInitializedWithoutPrimaryConstructor(FirClass regularClass, DiagnosticReporter reporter, CheckerContext context2) {
        SourceNavigator $this$checkSupertypeInitializedWithoutPrimaryConstructor_u24lambda_u241 = SourceNavigator.Companion.forElement(regularClass);
        boolean bl = false;
        for (FirTypeRef superTypeRef : regularClass.getSuperTypeRefs()) {
            if (!$this$checkSupertypeInitializedWithoutPrimaryConstructor_u24lambda_u241.isInConstructorCallee(superTypeRef)) continue;
            KtSourceElement ktSourceElement = superTypeRef.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = regularClass.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_WITHOUT_PRIMARY_CONSTRUCTOR(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

