/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.queries;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.queries.UnknownEncoding;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class FileEncodingQuery {
    private static final int BUFSIZ = 4096;
    private static final String DEFAULT_ENCODING = "default-encoding";
    private static final String UTF_8 = "UTF-8";
    private static final Logger LOG = Logger.getLogger(FileEncodingQuery.class.getName());
    static final String ENCODER_SELECTED = "encoder-selected";
    static final String DECODER_SELECTED = "decoder-selected";

    private FileEncodingQuery() {
    }

    public static Charset getEncoding(FileObject fileObject) {
        if (fileObject == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Charset> arrayList = new ArrayList<Charset>();
        for (FileEncodingQueryImplementation fileEncodingQueryImplementation : Lookup.getDefault().lookupAll(FileEncodingQueryImplementation.class)) {
            Charset charset = fileEncodingQueryImplementation.getEncoding(fileObject);
            if (charset != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "{0}: received encoding {1} from {2}", new Object[]{fileObject, charset, fileEncodingQueryImplementation});
                }
                arrayList.add(charset);
                continue;
            }
            if (!LOG.isLoggable(Level.FINER)) continue;
            LOG.log(Level.FINER, "{0}: received no encoding from {1}", new Object[]{fileObject, fileEncodingQueryImplementation});
        }
        try {
            if (fileObject.getFileSystem().isDefault()) {
                arrayList.add(Charset.forName(UTF_8));
            } else {
                arrayList.add(Charset.defaultCharset());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            arrayList.add(Charset.defaultCharset());
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0}: using encodings {1}", new Object[]{fileObject, arrayList});
        }
        return new ProxyCharset(arrayList);
    }

    public static Charset getDefaultEncoding() {
        Preferences preferences = NbPreferences.forModule(FileEncodingQuery.class);
        String string = preferences.get(DEFAULT_ENCODING, UTF_8);
        return Charset.forName(string);
    }

    public static void setDefaultEncoding(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException();
        }
        Preferences preferences = NbPreferences.forModule(FileEncodingQuery.class);
        preferences.put(DEFAULT_ENCODING, charset.name());
    }

    private static class ProxyCharset
    extends Charset {
        private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
        private static final CharBuffer EMPTY_CHAR_BUFFER = CharBuffer.allocate(0);
        private final List<? extends Charset> delegates;

        private ProxyCharset(List<? extends Charset> list) {
            super(list.get(0).name(), list.get(0).aliases().toArray(new String[list.get(0).aliases().size()]));
            this.delegates = list;
        }

        @Override
        public boolean contains(Charset charset) {
            return this.delegates.get(0).contains(charset);
        }

        @Override
        public CharsetDecoder newDecoder() {
            return new ProxyDecoder(this.delegates.get(0).newDecoder());
        }

        @Override
        public CharsetEncoder newEncoder() {
            return new ProxyEncoder(this.delegates.get(0).newEncoder());
        }

        private class ProxyEncoder
        extends CharsetEncoder {
            private CharsetEncoder currentEncoder;
            private CharBuffer buffer;
            private CharBuffer remainder;
            private CodingErrorAction malformedInputAction;
            private CodingErrorAction unmappableCharAction;
            private byte[] replace;
            private boolean initialized;
            private ByteBuffer lastByteBuffer;

            private ProxyEncoder(CharsetEncoder charsetEncoder) {
                super(ProxyCharset.this, charsetEncoder.averageBytesPerChar(), charsetEncoder.maxBytesPerChar(), charsetEncoder.replacement());
                this.buffer = CharBuffer.allocate(4096);
                this.currentEncoder = charsetEncoder;
                this.initialized = true;
            }

            @Override
            protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
                this.lastByteBuffer = byteBuffer;
                if (this.buffer == null) {
                    CoderResult coderResult;
                    if (this.remainder != null) {
                        coderResult = this.currentEncoder.encode(this.remainder, byteBuffer, false);
                        if (!this.remainder.hasRemaining()) {
                            this.remainder = null;
                        }
                        if (!coderResult.isUnderflow()) {
                            return coderResult;
                        }
                    }
                    coderResult = this.currentEncoder.encode(charBuffer, byteBuffer, false);
                    return coderResult;
                }
                if (this.buffer.remaining() == 0 || this.buffer.position() > 0 && charBuffer.limit() == 0) {
                    CoderResult coderResult = this.encodeHead(charBuffer, byteBuffer, false);
                    return coderResult;
                }
                if (this.buffer.remaining() < charBuffer.remaining()) {
                    int n = charBuffer.limit();
                    charBuffer.limit(charBuffer.position() + this.buffer.remaining());
                    this.buffer.put(charBuffer);
                    charBuffer.limit(n);
                    CoderResult coderResult = this.encodeHead(charBuffer, byteBuffer, false);
                    return coderResult;
                }
                this.buffer.put(charBuffer);
                return CoderResult.UNDERFLOW;
            }

            private CoderResult encodeHead(CharBuffer charBuffer, ByteBuffer byteBuffer, boolean bl) {
                CharBuffer charBuffer2 = this.buffer == null ? this.remainder : this.buffer;
                charBuffer2.flip();
                CoderResult coderResult = null;
                for (int i = 0; i < ProxyCharset.this.delegates.size(); ++i) {
                    this.currentEncoder = ((Charset)ProxyCharset.this.delegates.get(i)).newEncoder();
                    if (this.malformedInputAction != null) {
                        this.currentEncoder.onMalformedInput(this.malformedInputAction);
                    }
                    if (this.unmappableCharAction != null) {
                        this.currentEncoder.onUnmappableCharacter(this.unmappableCharAction);
                    }
                    if (this.replace != null) {
                        this.currentEncoder.replaceWith(this.replace);
                    }
                    int n = byteBuffer.position();
                    try {
                        CharBuffer charBuffer3 = charBuffer2.asReadOnlyBuffer();
                        coderResult = this.currentEncoder.encode(charBuffer3, byteBuffer, charBuffer == null);
                        if (coderResult.isOverflow()) {
                            LOG.log(Level.FINEST, FileEncodingQuery.ENCODER_SELECTED, this.currentEncoder);
                            this.remainder = charBuffer3;
                            this.buffer = null;
                            return coderResult;
                        }
                        if (coderResult.isUnmappable()) {
                            return coderResult;
                        }
                        if (charBuffer != null) {
                            coderResult = this.currentEncoder.encode(charBuffer, byteBuffer, false);
                        }
                        if (coderResult.isUnderflow() && bl) {
                            coderResult = this.currentEncoder.flush(byteBuffer);
                        }
                        LOG.log(Level.FINEST, FileEncodingQuery.ENCODER_SELECTED, this.currentEncoder);
                        this.buffer = null;
                        return coderResult;
                    }
                    catch (UnknownEncoding unknownEncoding) {
                        if (n == byteBuffer.position()) continue;
                        this.buffer = null;
                        return coderResult;
                    }
                }
                this.buffer = null;
                assert (coderResult != null);
                return coderResult;
            }

            @Override
            protected CoderResult implFlush(ByteBuffer byteBuffer) {
                this.lastByteBuffer = null;
                if (this.buffer != null || this.remainder != null) {
                    return this.encodeHead(null, byteBuffer, true);
                }
                this.currentEncoder.encode(EMPTY_CHAR_BUFFER, byteBuffer, true);
                return this.currentEncoder.flush(byteBuffer);
            }

            @Override
            protected void implReset() {
                if (this.lastByteBuffer != null) {
                    this.implFlush(this.lastByteBuffer);
                }
                this.currentEncoder.reset();
            }

            @Override
            protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
                if (this.buffer != null || !this.initialized) {
                    this.malformedInputAction = codingErrorAction;
                } else {
                    this.currentEncoder.onMalformedInput(codingErrorAction);
                }
            }

            @Override
            protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
                if (this.buffer != null || !this.initialized) {
                    this.unmappableCharAction = codingErrorAction;
                } else {
                    this.currentEncoder.onUnmappableCharacter(codingErrorAction);
                }
            }

            @Override
            protected void implReplaceWith(byte[] byArray) {
                if (this.buffer != null || !this.initialized) {
                    this.replace = byArray;
                } else {
                    this.currentEncoder.replaceWith(byArray);
                }
            }
        }

        private class ProxyDecoder
        extends CharsetDecoder {
            private CharsetDecoder currentDecoder;
            private ByteBuffer buffer;
            private ByteBuffer remainder;
            private CodingErrorAction malformedInputAction;
            private CodingErrorAction unmappableCharAction;
            private String replace;
            private boolean initialized;
            private CharBuffer lastCharBuffer;

            private ProxyDecoder(CharsetDecoder charsetDecoder) {
                super(ProxyCharset.this, charsetDecoder.averageCharsPerByte(), charsetDecoder.maxCharsPerByte());
                this.buffer = ByteBuffer.allocate(4096);
                this.currentDecoder = charsetDecoder;
                this.initialized = true;
            }

            @Override
            protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
                this.lastCharBuffer = charBuffer;
                if (this.buffer == null) {
                    if (this.remainder != null) {
                        ByteBuffer byteBuffer2 = ByteBuffer.allocate(this.remainder.remaining() + byteBuffer.remaining());
                        byteBuffer2.put(this.remainder);
                        byteBuffer2.put(byteBuffer);
                        byteBuffer2.flip();
                        CoderResult coderResult = this.currentDecoder.decode(byteBuffer2, charBuffer, false);
                        this.remainder = byteBuffer2.hasRemaining() ? byteBuffer2 : null;
                        return coderResult;
                    }
                    return this.currentDecoder.decode(byteBuffer, charBuffer, false);
                }
                if (this.buffer.remaining() == 0) {
                    return this.decodeHead(byteBuffer, charBuffer, false);
                }
                if (this.buffer.remaining() < byteBuffer.remaining()) {
                    int n = byteBuffer.limit();
                    byteBuffer.limit(byteBuffer.position() + this.buffer.remaining());
                    this.buffer.put(byteBuffer);
                    byteBuffer.limit(n);
                    return this.decodeHead(byteBuffer, charBuffer, false);
                }
                this.buffer.put(byteBuffer);
                return CoderResult.UNDERFLOW;
            }

            private CoderResult decodeHead(ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) {
                this.buffer.flip();
                CoderResult coderResult = null;
                for (int i = 0; i < ProxyCharset.this.delegates.size(); ++i) {
                    this.currentDecoder = ((Charset)ProxyCharset.this.delegates.get(i)).newDecoder();
                    if (this.malformedInputAction != null) {
                        this.currentDecoder.onMalformedInput(this.malformedInputAction);
                    }
                    if (this.unmappableCharAction != null) {
                        this.currentDecoder.onUnmappableCharacter(this.unmappableCharAction);
                    }
                    if (this.replace != null) {
                        this.currentDecoder.replaceWith(this.replace);
                    }
                    int n = charBuffer.position();
                    try {
                        ByteBuffer byteBuffer2 = this.buffer.asReadOnlyBuffer();
                        coderResult = this.currentDecoder.decode(byteBuffer2, charBuffer, byteBuffer == null);
                        if (byteBuffer2.hasRemaining()) {
                            if (bl) {
                                this.currentDecoder.flush(charBuffer);
                            }
                            LOG.log(Level.FINEST, FileEncodingQuery.DECODER_SELECTED, this.currentDecoder);
                            this.remainder = byteBuffer2;
                            this.buffer = null;
                            return coderResult;
                        }
                        if (byteBuffer != null) {
                            coderResult = this.currentDecoder.decode(byteBuffer, charBuffer, false);
                        }
                        if (bl) {
                            coderResult = this.currentDecoder.flush(charBuffer);
                        }
                        LOG.log(Level.FINEST, FileEncodingQuery.DECODER_SELECTED, this.currentDecoder);
                        this.buffer = null;
                        return coderResult;
                    }
                    catch (UnknownEncoding unknownEncoding) {
                        if (n == charBuffer.position()) continue;
                        this.buffer = null;
                        return coderResult;
                    }
                }
                this.buffer = null;
                assert (coderResult != null);
                return coderResult;
            }

            @Override
            protected CoderResult implFlush(CharBuffer charBuffer) {
                this.lastCharBuffer = null;
                if (this.buffer != null) {
                    return this.decodeHead(null, charBuffer, true);
                }
                this.currentDecoder.decode(EMPTY_BYTE_BUFFER, charBuffer, true);
                return this.currentDecoder.flush(charBuffer);
            }

            @Override
            protected void implReset() {
                if (this.lastCharBuffer != null) {
                    this.implFlush(this.lastCharBuffer);
                }
                this.currentDecoder.reset();
            }

            @Override
            protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
                if (this.buffer != null || !this.initialized) {
                    this.malformedInputAction = codingErrorAction;
                } else {
                    this.currentDecoder.onMalformedInput(codingErrorAction);
                }
            }

            @Override
            protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
                if (this.buffer != null || !this.initialized) {
                    this.unmappableCharAction = codingErrorAction;
                } else {
                    this.currentDecoder.onUnmappableCharacter(codingErrorAction);
                }
            }

            @Override
            protected void implReplaceWith(String string) {
                if (this.buffer != null || !this.initialized) {
                    this.replace = string;
                } else {
                    this.currentDecoder.replaceWith(string);
                }
            }
        }
    }
}

