/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.util.function.IntPredicate;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSingletonIterator;

public class UnicodeChar
extends UnicodeString {
    private final int codepoint;

    public UnicodeChar(int codepoint) {
        this.codepoint = codepoint;
    }

    @Override
    public IntIterator codePoints() {
        return new IntSingletonIterator(this.codepoint);
    }

    public int getCodepoint() {
        return this.codepoint;
    }

    @Override
    public long length() {
        return 1L;
    }

    @Override
    public int getWidth() {
        if (this.codepoint < 128) {
            return 7;
        }
        if (this.codepoint < 256) {
            return 8;
        }
        if (this.codepoint < 65536) {
            return 16;
        }
        return 24;
    }

    @Override
    public long indexOf(int codePoint, long from) {
        return this.codepoint == codePoint && from <= 0L ? 0L : -1L;
    }

    @Override
    public int codePointAt(long index) {
        if (index == 0L) {
            return this.codepoint;
        }
        throw new IndexOutOfBoundsException("Only valid index for a single-character string is zero");
    }

    @Override
    public UnicodeString substring(long start, long end) {
        this.checkSubstringBounds(start, end);
        if (start == 0L && end == 1L) {
            return this;
        }
        return EmptyUnicodeString.getInstance();
    }

    @Override
    public long indexWhere(IntPredicate predicate, long from) {
        return from == 0L && predicate.test(this.codepoint) ? 0L : -1L;
    }

    public String toString() {
        if (this.codepoint < 65536) {
            return "" + (char)this.codepoint;
        }
        return "" + UTF16CharacterSet.highSurrogate(this.codepoint) + UTF16CharacterSet.lowSurrogate(this.codepoint);
    }

    @Override
    void copy8bit(byte[] target, int offset) {
        target[offset] = (byte)(this.codepoint & 0xFF);
    }

    @Override
    void copy16bit(char[] target, int offset) {
        target[offset] = (char)this.codepoint;
    }

    @Override
    void copy24bit(byte[] target, int offset) {
        target[offset] = (byte)(this.codepoint >> 16);
        target[offset + 1] = (byte)(this.codepoint >> 8);
        target[offset + 2] = (byte)(this.codepoint & 0xFF);
    }
}

