/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.ocf.OCFResource;
import com.adobe.epubcheck.ocf.encryption.EncryptionFilter;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.w3c.epubcheck.util.url.URLUtils;

public final class OCFContainer
implements GenericResourceProvider {
    private final URL rootURL;
    private final boolean isPackaged;
    private final ImmutableMap<URL, OCFResource> resources;
    private final ImmutableMap<URL, EncryptionFilter> encryptionFilters;

    public OCFContainer(Builder builder) {
        this.rootURL = builder.rootURL;
        this.isPackaged = builder.isPackaged;
        this.resources = ImmutableMap.copyOf((Map)builder.resources);
        this.encryptionFilters = builder.encryptionFilters.buildKeepingLast();
    }

    public boolean contains(URL resource) {
        if (this.resources.containsKey((Object)resource)) {
            return true;
        }
        return this.resources.containsKey((Object)URLUtils.normalize(resource));
    }

    @Override
    public InputStream openStream(URL url) throws IOException {
        OCFResource resource = (OCFResource)this.resources.get((Object)URLUtils.normalize(url));
        if (resource == null) {
            throw new IllegalArgumentException("Resource not found: " + url);
        }
        return resource.openStream();
    }

    public boolean canDecrypt(URL url) {
        OCFResource resource = (OCFResource)this.resources.get((Object)url);
        if (resource == null) {
            throw new IllegalArgumentException("Resource not found: " + url);
        }
        EncryptionFilter filter = (EncryptionFilter)this.encryptionFilters.get((Object)url);
        return filter == null || filter.canDecrypt();
    }

    public Set<URL> getResources() {
        return this.resources.keySet();
    }

    public URL getRootURL() {
        return this.rootURL;
    }

    public String relativize(URL url) {
        return this.rootURL.relativize(url);
    }

    public boolean isPackaged() {
        return this.isPackaged;
    }

    public boolean isRemote(URL url) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"URL is null");
        if ("data".equals(url.scheme()) || this.contains(url)) {
            return false;
        }
        return URLUtils.isRemote(url, this.rootURL);
    }

    static final class Builder {
        private final URL rootURL;
        private boolean isPackaged;
        private Map<URL, OCFResource> resources = new LinkedHashMap<URL, OCFResource>();
        private ImmutableMap.Builder<URL, EncryptionFilter> encryptionFilters = ImmutableMap.builder();

        public Builder() {
            try {
                this.rootURL = URL.parse((String)("https://" + UUID.randomUUID() + ".epubcheck.w3c.org"));
            }
            catch (GalimatiasParseException e) {
                throw new AssertionError((Object)"Could not create root URL");
            }
        }

        public Builder addResource(OCFResource resource) {
            Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"resource must not be null");
            try {
                this.resources.put(URLUtils.normalize(this.rootURL.resolve(URLUtils.encodePath(resource.getPath()))), resource);
            }
            catch (GalimatiasParseException e) {
                throw new IllegalArgumentException("Could not create container URL of " + resource.getPath(), e);
            }
            return this;
        }

        public OCFContainer build() {
            return new OCFContainer(this);
        }

        public void addEncryption(URL resource, EncryptionFilter filter) {
            Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"resource must not be null");
            Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (Object)"filter must not be null");
            Preconditions.checkArgument((boolean)this.resources.containsKey(resource), (Object)(resource + " was not found in the container"));
            this.encryptionFilters.put((Object)resource, (Object)filter);
        }

        public void setPackaged(boolean isPackaged) {
            this.isPackaged = isPackaged;
        }
    }
}

