#an interesting variety example
pg1 := PG(1, 7);
pg3 := PG(3, 7);
points := Points(pg1);
coords := List(points, Coordinates);
curve := List(coords, t -> VectorSpaceToElement(pg3, [ t[1]^3, t[1]^2 * t[2], t[1] * t[2]^2, t[2]^3  ] ));;
pgl := ProjectivityGroup( pg3 );
stabcurve := FiningSetwiseStabiliser( pgl, curve );
StructureDescription( stabcurve );
Span( curve );
pg3lines := Lines( pg3 );
orbits := FiningOrbits(stabcurve, pg3lines);
List(orbits, Size);
pg3points := Points( pg3 );
orbits := FiningOrbits(stabcurve, pg3points);
List(orbits, Size);
reps := List(orbits, Representative);
x := reps[2];
proj := NaturalProjectionBySubspace(pg3, x);
curveminusx := Difference(curve, [x]);
cuspidal := ImagesSet(proj, List(curveminusx, t -> Span(x, t)));
coords := List(cuspidal, Coordinates);
r := PolynomialRing(GF(7), 3);
indets := IndeterminatesOfPolynomialRing(r);
shapes := Filtered(Tuples([0,1,2,3], 3), t -> Sum(t) = 3);
mat := List(coords, t -> List(shapes, u -> Product([1,2,3], i -> t[i]^u[i])));
mat2 := ShallowCopy(mat);
sol := NullspaceMat(TransposedMat(mat2))[1];
terms := List(shapes, u -> Product([1,2,3], i -> indets[i]^u[i]));
poly := terms * sol;
pg2 := AmbientGeometry(Range(proj));
variety := ProjectiveVariety(pg2, [poly]);
points := Points(variety);
Size(points);
quit;
