/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.EditAltitudeCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.NumberUtils;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.edit.PointAltitudeEdit;
import tim.prune.function.srtm.Interpolator;
import tim.prune.function.srtm.SrtmAuthException;
import tim.prune.function.srtm.SrtmHighResSource;
import tim.prune.function.srtm.SrtmLowResSource;
import tim.prune.function.srtm.SrtmSource;
import tim.prune.function.srtm.SrtmTile;
import tim.prune.gui.ProgressDialog;

public class LookupSrtmFunction
extends GenericFunction {
    private ProgressDialog _progress = null;
    private Track _track = null;
    private boolean _normalTrack = true;
    private boolean _hadToDownload = false;
    private int _numCached = 0;
    private boolean _running = false;
    private boolean _cancelled = false;

    public LookupSrtmFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.lookupsrtm";
    }

    @Override
    public void begin() {
        this.begin(this._app.getTrackInfo().getTrack(), true);
    }

    public void begin(Track track) {
        this.begin(track, false);
    }

    private void begin(Track track, boolean bl) {
        this._running = true;
        this._cancelled = false;
        this._hadToDownload = false;
        if (this._progress == null) {
            this._progress = new ProgressDialog(this._parentFrame, this.getNameKey(), null, () -> {
                boolean bl = this._cancelled = true;
            });
        }
        this._progress.show();
        this._track = track;
        this._normalTrack = bl;
        new Thread(this::run).start();
    }

    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this._track.getNumPoints()) {
            if (this._track.getPoint(n).hasAltitude()) {
                if (this._track.getPoint(n).getAltitude().getValue() == 0.0) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            }
            n += 1;
        }
        int n2 = n = bl && !bl2 ? 1 : 0;
        if (bl2 && bl && JOptionPane.showConfirmDialog(this._parentFrame, I18nManager.getText("dialog.lookupsrtm.overwritezeros"), this.getName(), 0) == 0) {
            n = 1;
        }
        HashSet<SrtmTile> hashSet = new HashSet<SrtmTile>();
        int n3 = 0;
        while (n3 < this._track.getNumPoints()) {
            if (!this._track.getPoint(n3).hasAltitude() || n && this._track.getPoint(n3).getAltitude().getValue() == 0.0) {
                hashSet.add(new SrtmTile(this._track.getPoint(n3)));
            }
            ++n3;
        }
        CookieHandler cookieHandler = CookieHandler.getDefault();
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        this.lookupValues(hashSet, n != 0);
        CookieHandler.setDefault(cookieHandler);
        this._running = false;
        if (this._hadToDownload) {
            this._app.showTip(2);
        } else if (this._numCached > 0) {
            this.showConfirmMessage(this._numCached);
        }
    }

    private void lookupValues(HashSet<SrtmTile> hashSet, boolean bl) {
        String string = this.getConfig().getConfigString("prune.diskcache");
        SrtmSource[] srtmSourceArray = new SrtmSource[]{new SrtmHighResSource(string, this.getConfig().getConfigString("prune.earthdataauth")), new SrtmLowResSource(string)};
        String string2 = null;
        int n = hashSet.size();
        if (this._progress != null) {
            this._progress.showProgress(0, n);
        }
        int n2 = 0;
        this._numCached = 0;
        ArrayList<PointAltitudeEdit> arrayList = new ArrayList<PointAltitudeEdit>();
        for (SrtmTile object : hashSet) {
            this._progress.showProgress(n2++, n);
            int[] nArray = null;
            SrtmSource[] srtmSourceArray2 = srtmSourceArray;
            int n3 = srtmSourceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                SrtmSource srtmSource = srtmSourceArray2[n4];
                if (nArray == null && !this._cancelled) {
                    try {
                        nArray = this.getHeightsForTile(object, srtmSource);
                        arrayList.addAll(this.applySrtmTileToWholeTrack(object, nArray, bl, srtmSource.getTilePixels()));
                    }
                    catch (IOException srtmAuthException) {
                        string2 = String.valueOf(srtmAuthException.getClass().getName()) + " - " + srtmAuthException.getMessage();
                    }
                    catch (SrtmAuthException srtmAuthException) {
                        string2 = String.valueOf(I18nManager.getText("error.srtm.authenticationfailed")) + " - " + srtmAuthException.getMessage();
                    }
                }
                ++n4;
            }
        }
        this._progress.close();
        if (this._cancelled) {
            return;
        }
        if (string2 != null) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), string2);
        }
        if (!arrayList.isEmpty()) {
            EditAltitudeCmd editAltitudeCmd = new EditAltitudeCmd(arrayList);
            if (this._normalTrack) {
                editAltitudeCmd.setConfirmText(I18nManager.getTextWithNumber("confirm.lookupsrtm", arrayList.size()));
                editAltitudeCmd.setDescription(this.getName());
                this._app.execute(editAltitudeCmd);
            } else {
                editAltitudeCmd.executeCommand(this._track);
            }
        } else if (n > 0) {
            this._app.showErrorMessage(this.getNameKey(), "error.lookupsrtm.nonefound");
        } else {
            this._app.showErrorMessage(this.getNameKey(), "error.lookupsrtm.nonerequired");
        }
    }

    private int[] getHeightsForTile(SrtmTile srtmTile, SrtmSource srtmSource) throws IOException, SrtmAuthException {
        int[] nArray = null;
        ZipInputStream zipInputStream = this.getStreamToSrtmData(srtmTile, srtmSource);
        boolean bl = false;
        if (zipInputStream != null) {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            boolean bl2 = bl = zipEntry != null && zipEntry.getSize() == srtmSource.getTileSizeBytes();
            if (bl) {
                int n = srtmSource.getTilePixels() * srtmSource.getTilePixels();
                nArray = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    nArray[n2] = zipInputStream.read() * 256 + zipInputStream.read();
                    if (nArray[n2] >= 32768) {
                        int n3 = n2;
                        nArray[n3] = nArray[n3] - 65536;
                    }
                    ++n2;
                }
            }
            zipInputStream.close();
        }
        if (!bl) {
            nArray = null;
        }
        return nArray;
    }

    private ZipInputStream getStreamToSrtmData(SrtmTile srtmTile, SrtmSource srtmSource) throws IOException, SrtmAuthException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = this.getStreamToLocalHgtFile(srtmSource.getCacheDir(), srtmSource.getFilename(srtmTile));
        }
        catch (IOException iOException) {
            zipInputStream = null;
        }
        if (zipInputStream != null) {
            return zipInputStream;
        }
        SrtmSource.Result result = srtmSource.downloadTile(srtmTile);
        if (result == SrtmSource.Result.DOWNLOADED) {
            ++this._numCached;
            return this.getStreamToLocalHgtFile(srtmSource.getCacheDir(), srtmSource.getFilename(srtmTile));
        }
        if (result == SrtmSource.Result.NOT_ENABLED) {
            return null;
        }
        if (result != SrtmSource.Result.DOWNLOAD_FAILED) {
            this._hadToDownload = true;
            URL uRL = srtmSource.getUrl(srtmTile);
            if (uRL == null) {
                return null;
            }
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "GpsPrune v26.1");
            return new ZipInputStream(uRLConnection.getInputStream());
        }
        return null;
    }

    private ZipInputStream getStreamToLocalHgtFile(File file, String string) throws IOException {
        File file2;
        if (file != null && file.exists() && file.isDirectory() && file.canRead() && (file2 = new File(file, string)).exists() && file2.isFile() && file2.canRead() && file2.length() > 400L) {
            return new ZipInputStream(new FileInputStream(file2));
        }
        return null;
    }

    private ArrayList<PointAltitudeEdit> applySrtmTileToWholeTrack(SrtmTile srtmTile, int[] nArray, boolean bl, int n) {
        ArrayList<PointAltitudeEdit> arrayList = new ArrayList<PointAltitudeEdit>();
        if (nArray == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < this._track.getNumPoints()) {
            double d;
            boolean bl2;
            DataPoint dataPoint = this._track.getPoint(n2);
            boolean bl3 = bl2 = !dataPoint.hasAltitude() || bl && dataPoint.getAltitude().getValue() == 0.0;
            if (bl2 && srtmTile.contains(dataPoint) && (d = Interpolator.calculateAltitude(dataPoint.getLongitude().getDouble(), dataPoint.getLatitude().getDouble(), nArray, this._normalTrack, n)) != -32768.0) {
                String string = NumberUtils.formatNumberUk(d, 3);
                arrayList.add(new PointAltitudeEdit(n2, string, UnitSetLibrary.UNITS_METRES));
            }
            ++n2;
        }
        return arrayList;
    }

    public boolean isRunning() {
        return this._running;
    }

    private void showConfirmMessage(int n) {
        if (n == 1) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getTextWithNumber("confirm.downloadsrtm.1", n), this.getName(), 1);
        } else if (n > 1) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getTextWithNumber("confirm.downloadsrtm", n), this.getName(), 1);
        }
    }
}

