# This script was generated by crazy-complete.
# crazy-complete: A tool that creates robust and reliable autocompletion scripts for Bash, Fish and Zsh.
# For more information, visit: https://github.com/crazy-complete/crazy-complete

function _j4-dmenu-desktop__--desktop-file-quirks
  printf "%s\t%s\n" \
    wine 'compatibility with desktop files generated by Wine' \
    multispace 'accept multiple spaces as argument separators in Exec' \
    nowine '' \
    nomultispace ''
end

function _j4-dmenu-desktop_fish_query
  # ===========================================================================
  #
  # This function implements the parsing of options and positionals in the Fish shell.
  #
  # Usage: __fish_query <OPTIONS> <COMMAND> [ARGS...]
  #
  # The first argument is a comma-separated list of options that the parser should know about.
  # Short options (-o), long options (--option), and old-style options (-option) are supported.
  #
  # If an option takes an argument, it is suffixed by '='.
  # If an option takes an optional argument, it is suffixed by '=?'.
  #
  # For example:
  #   __fish_query '-f,--flag,-old-style,--with-arg=,--with-optional=?' [...]
  #
  #   Here, -f, --flag and -old-style don't take options, --with-arg requires an
  #   argument and --with-optional takes an optional argument.
  #
  # COMMANDS
  #   positional_contains <NUM> <WORDS...>
  #     Checks if the positional argument number NUM is one of WORDS.
  #     NUM counts from one.
  #
  #   has_option [WITH_INCOMPLETE] <OPTIONS...>
  #     Checks if an option given in OPTIONS is passed on commandline.
  #     If an option requires an argument, this command returns true only if the
  #     option includes an argument. If 'WITH_INCOMPLETE' is specified, it also
  #     returns true for options missing their arguments.
  #
  #   option_is <OPTIONS...> -- <VALUES...>
  #     Checks if any option in OPTIONS has a value of VALUES.
  #
  #   num_of_positionals [<OPERATOR> <NUMBER>]
  #     Checks the number of positional arguments.
  #     If no arguments are provided, print the total count of positional arguments.
  #     If two arguments are provided, the first argument should be one of
  #     the comparison operators: '-lt', '-le', '-eq', '-ne', '-gt', '-ge'.
  #     Returns 0 if the count of positional arguments matches the
  #     specified NUMBER according to the comparison operator, otherwise returns 1.
  #
  # ===========================================================================

  set -l positionals
  set -l having_options
  set -l option_values

  set -l options $argv[1]
  set -e argv[1]

  set -l cmd $argv[1]
  set -e argv[1]

  set -l my_cache_key "$(commandline -b) $options"

  if test "$__QUERY_CACHE_KEY" = "$my_cache_key"
    set positionals    $__QUERY_CACHE_POSITIONALS
    set having_options $__QUERY_CACHE_HAVING_OPTIONS
    set option_values  $__QUERY_CACHE_OPTION_VALUES
  else
    # =========================================================================
    # Parsing of OPTIONS argument
    # =========================================================================

    set -l short_opts_with_arg
    set -l short_opts_without_arg
    set -l short_opts_with_optional_arg
    set -l long_opts_with_arg
    set -l long_opts_without_arg
    set -l long_opts_with_optional_arg

    set -l option

    if test -n "$options"
      for option in (string split -- ',' $options)
        # Using one big switch case is the fastest way
        switch $option
          case '--?*=';   set -a long_opts_with_arg           (string replace -- '='  '' $option)
          case '--?*=\?'; set -a long_opts_with_optional_arg  (string replace -- '=?' '' $option)
          case '--?*';    set -a long_opts_without_arg        $option
          case '-?=';     set -a short_opts_with_arg          (string replace -- '='  '' $option)
          case '-?=\?';   set -a short_opts_with_optional_arg (string replace -- '=?' '' $option)
          case '-?';      set -a short_opts_without_arg       $option
        end
      end
    end

    # =========================================================================
    # Parsing of options and positionals
    # =========================================================================

    set -l cmdline (commandline -poc)
    set -l cmdline_count (count $cmdline)

    set -l argi 2 # cmdline[1] is command name
    while test $argi -le $cmdline_count
      set -l arg "$cmdline[$argi]"
      set -l have_trailing_arg (test $argi -lt $cmdline_count && echo true || echo false)

      switch $arg
        case '-'
          set -a positionals -
        case '--'
          for argi in (seq (math $argi + 1) $cmdline_count)
            set -a positionals $cmdline[$argi]
          end
          break
        case '--*=*'
          set -l split (string split -m 1 -- '=' $arg)
          set -a having_options $split[1]
          set -a option_values "$split[2]"
        case '--*'
          if contains -- $arg $long_opts_with_arg
            if $have_trailing_arg
              set -a having_options $arg
              set -a option_values $cmdline[(math $argi + 1)]
              set argi (math $argi + 1)
            end
          else
            set -a having_options $arg
            set -a option_values ""
          end
        case '-*'
          set -l end_of_parsing false

          set -l arg_length (string length -- $arg)
          set -l i 2
          while not $end_of_parsing; and test $i -le $arg_length
            set -l option "-$(string sub -s $i -l 1 -- $arg)"
            set -l trailing_chars "$(string sub -s (math $i + 1) -- $arg)"

            if contains -- $option $short_opts_without_arg
              set -a having_options $option
              set -a option_values ""
            else if contains -- $option $short_opts_with_arg
              set end_of_parsing true

              if test -n "$trailing_chars"
                set -a having_options $option
                set -a option_values $trailing_chars
              else if $have_trailing_arg
                set -a having_options $option
                set -a option_values $cmdline[(math $argi + 1)]
                set argi (math $argi + 1)
              end
            else if contains -- $option $short_opts_with_optional_arg
              set end_of_parsing true
              set -a having_options $option
              set -a option_values "$trailing_chars" # may be empty
            end

            set i (math $i + 1)
          end
        case '*'
          set -a positionals $arg
      end

      set argi (math $argi + 1)
    end

    set -g __QUERY_CACHE_POSITIONALS    $positionals
    set -g __QUERY_CACHE_HAVING_OPTIONS $having_options
    set -g __QUERY_CACHE_OPTION_VALUES  $option_values
    set -g __QUERY_CACHE_KEY            $my_cache_key
  end

  # ===========================================================================
  # Commands
  # ===========================================================================

  switch $cmd
    case 'has_option'
      for option in $having_options
        contains -- $option $argv && return 0
      end

      return 1
  end
end

set -l prog "j4-dmenu-desktop"
set -l query "_j4-dmenu-desktop_fish_query"

# Generally disable file completion
complete -c $prog -x

# command j4-dmenu-desktop
set -l opts "-h,--help,--version,-b,--display-binary,-f,--display-binary-base,-d=,--dmenu=,--no-exec,--no-generic,-t=,--term=,--term-mode=,--usage-log=,--prune-bad-usage-log-entries,-x,--use-xdg-de,--wait-on=,--wrapper=,-I,--i3-ipc,--skip-i3-exec-check,-i,--case-insensitive,-v,--log-level=,--log-file=,--log-file-level=,--desktop-file-quirks=,--strict-parsing"
set -l C000 "not $query '$opts' has_option -h --help --version"
set -l C001 "not $query '$opts' has_option -h --help --version -b --display-binary"
set -l C002 "not $query '$opts' has_option -h --help --version -f --display-binary-base"
set -l C003 "not $query '$opts' has_option -h --help --version -d --dmenu"
set -l C004 "not $query '$opts' has_option -h --help --version --no-exec"
set -l C005 "not $query '$opts' has_option -h --help --version --no-generic"
set -l C006 "not $query '$opts' has_option -h --help --version -t --term"
set -l C007 "not $query '$opts' has_option -h --help --version --term-mode"
set -l C008 "not $query '$opts' has_option -h --help --version --usage-log"
set -l C009 "not $query '$opts' has_option -h --help --version --prune-bad-usage-log-entries"
set -l C010 "not $query '$opts' has_option -h --help --version -x --use-xdg-de"
set -l C011 "not $query '$opts' has_option -h --help --version --wait-on"
set -l C012 "not $query '$opts' has_option -h --help --version --wrapper"
set -l C013 "not $query '$opts' has_option -h --help --version -I --i3-ipc"
set -l C014 "not $query '$opts' has_option -h --help --version --skip-i3-exec-check"
set -l C015 "not $query '$opts' has_option -h --help --version -i --case-insensitive"
set -l C016 "not $query '$opts' has_option -h --help --version --log-level"
set -l C017 "not $query '$opts' has_option -h --help --version --log-file"
set -l C018 "not $query '$opts' has_option -h --help --version --log-file-level"
set -l C019 "not $query '$opts' has_option -h --help --version --strict-parsing --desktop-file-quirks"
set -l C020 "not $query '$opts' has_option -h --help --version --desktop-file-quirks --strict-parsing"
complete -c $prog -n $C000 -s h -l help -d 'print help message' -f
complete -c $prog -n $C000 -l version -d 'display program version' -f
complete -c $prog -n $C001 -s b -l display-binary -d 'display binary name after each entry' -f
complete -c $prog -n $C002 -s f -l display-binary-base -d 'display binary name after each entry' -f
complete -c $prog -n $C003 -s d -l dmenu -d 'command used to invoke dmenu' -x -a '(__fish_complete_command)'
complete -c $prog -n $C004 -l no-exec -d 'do not execute selected command, send to stdout instead' -f
complete -c $prog -n $C005 -l no-generic -d 'do not include the generic name of desktop entries' -f
complete -c $prog -n $C006 -s t -l term -d 'sets the terminal emulator used to start terminal apps' -x -a '(__fish_complete_command)'
complete -c $prog -n $C007 -l term-mode -d 'set terminal emulator execution strategy' -x -a 'default xterm alacritty kitty terminator gnome-terminal custom'
complete -c $prog -n $C008 -l usage-log -d 'set usage log' -Fr
complete -c $prog -n $C009 -l prune-bad-usage-log-entries -d 'remove bad history entries' -f
complete -c $prog -n $C010 -s x -l use-xdg-de -d 'enables reading $XDG_CURRENT_DESKTOP to determine the desktop environment' -f
complete -c $prog -n $C011 -l wait-on -d 'enable daemon mode' -Fr
complete -c $prog -n $C012 -l wrapper -d 'a wrapper binary' -x -a '(__fish_complete_command)'
complete -c $prog -n $C013 -s I -l i3-ipc -d 'execute desktop entries through i3 IPC' -f
complete -c $prog -n $C014 -l skip-i3-exec-check -d 'disable the check for '"'"'--wrapper "i3 exec"'"'"'' -f
complete -c $prog -n $C015 -s i -l case-insensitive -d 'sort applications case insensitively' -f
complete -c $prog -n $C000 -s v -d 'be more verbose, can be specified multiple times' -f
complete -c $prog -n $C016 -l log-level -d 'set loglevel' -x -a 'ERROR WARNING INFO DEBUG'
complete -c $prog -n $C017 -l log-file -d 'specify a log file' -Fr
complete -c $prog -n $C018 -l log-file-level -d 'set file loglevel' -x -a 'ERROR WARNING INFO DEBUG'
complete -c $prog -n $C019 -l desktop-file-quirks -d 'set compatibility modes' -x -a '(__fish_complete_list , _j4-dmenu-desktop__--desktop-file-quirks)'
complete -c $prog -n $C020 -l strict-parsing -d 'enable strict desktop file parsing' -f

# vim: ft=fish ts=2 sts=2 sw=2 et