import os
import socket

this_script_dir, _ = os.path.split(__file__)
report_path = os.path.join(this_script_dir, "data/gfx_hotspot.sqlite")
if not os.path.exists(report_path):
    print(f"Recipe output not found at {report_path}.")
    print("Please re-run the recipe and try again.")
    exit()


def is_server_port_open(server_hostname, server_port):
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.settimeout(0.1)
    err = sock.connect_ex((server_hostname, server_port))
    sock.close()
    return 0 == err


os.environ["NSYS_CPU_STATS_DATABASE_PROVIDER"] = "sqlite"
os.environ["NSYS_CPU_STATS_DATABASE_HOST"] = report_path
os.environ["NSYS_CPU_STATS_STANDALONE"] = "True"

try:
    import uvicorn
    from server.app.main import app  # pylint: disable=import-outside-toplevel
except ModuleNotFoundError as e:
    req_file = "viewer/server/requirements.txt"
    print(
        f"{e}\nAll packages listed in '{req_file}' must be installed."
        f" Please run pip install -r '{req_file}' and try again."
    )
    exit()

server_port = 4200
server_hostname = "127.0.0.1"

if is_server_port_open(server_hostname, server_port):
    print(f"Connection at {server_hostname}:{server_port} already open, aborting")
    exit()
viewer_url = f"http://{server_hostname}:{server_port}"
print(f"Serving report viewer at {viewer_url}/ ...")
print("Please open this URL in a web browser to view the report")
print("Press <Ctrl>+C to exit")

config = uvicorn.Config(
    app=app, host=server_hostname, port=server_port, log_level="critical"
)
server = uvicorn.Server(config=config)
try:
    server.run()
except KeyboardInterrupt as e:
    pass
