/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.EntityType;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class ModuleDeclaration
extends EntityDeclaration {
    public static final ModuleDeclaration NULL = new NullModuleDeclaration();

    public final JavaTokenNode getLeftBraceToken() {
        return this.getChildByRole(Roles.LEFT_BRACE);
    }

    public final AstNodeCollection<EntityDeclaration> getMembers() {
        return this.getChildrenByRole(Roles.TYPE_MEMBER);
    }

    public final JavaTokenNode getRightBraceToken() {
        return this.getChildByRole(Roles.RIGHT_BRACE);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MODULE_DECLARATION;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.MODULE_DEFINITION;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitModuleDeclaration(this, data);
    }

    @Override
    public ModuleDeclaration clone() {
        return (ModuleDeclaration)super.clone();
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof ModuleDeclaration) {
            ModuleDeclaration otherDeclaration = (ModuleDeclaration)other;
            return !otherDeclaration.isNull() && ModuleDeclaration.matchString(this.getName(), otherDeclaration.getName());
        }
        return false;
    }

    private static final class NullModuleDeclaration
    extends ModuleDeclaration {
        private NullModuleDeclaration() {
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

