/*
 * Decompiled with CFR 0.152.
 */
package viz;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import viz.DensiTree;

public class GridDrawer {
    public Font m_gridfont = Font.getFont("Monospaced");
    public GridMode m_nGridMode = GridMode.NONE;
    public float m_fGridOrigin = 0.0f;
    public boolean m_bReverseGrid = false;
    public boolean m_bAutoGrid = true;
    public float m_fGridTicks = 100.0f;
    public float m_fGridOffset = 0.0f;
    public int m_nGridDigits = 2;
    DensiTree m_dt;
    final int[] NR_OF_TICKS = new int[]{5, 10, 8, 6, 8, 10, 6, 7, 8, 9, 10};
    int m_nTicks = 10;

    public GridDrawer(DensiTree dt) {
        this.m_dt = dt;
    }

    void drawHeightInfoSVG(StringBuffer buf) {
        block17: {
            if (this.m_nGridMode == GridMode.NONE || !(this.m_dt.m_fHeight > 0.0f)) break block17;
            DecimalFormat formatter = new DecimalFormat("##.##");
            float fTreeHeight = this.m_dt.m_fHeight * this.m_dt.m_fUserScale;
            float fUserSign = Math.signum(this.m_dt.m_fUserScale);
            if (this.m_bReverseGrid) {
                fUserSign = -fUserSign;
            }
            if (this.m_dt.m_treeDrawer.m_bRootAtTop) {
                int nW = this.m_dt.getWidth();
                if (this.m_nGridMode == GridMode.SHORT) {
                    nW = 10;
                }
                buf.append("<path fill='none' stroke='rgb(" + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getRed() + "," + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getGreen() + "," + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getBlue() + ")' " + "stroke-width='" + 1 + "' " + " d='");
                if (this.m_bAutoGrid) {
                    int y;
                    float fHeight = (float)this.adjust(fTreeHeight);
                    int i = 0;
                    while (i <= this.m_nTicks) {
                        y = this.m_dt.getPosY((this.m_dt.m_fHeight - fHeight / this.m_dt.m_fUserScale * (float)i / (float)this.m_nTicks - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
                        buf.append("M0 " + y + "L" + nW + " " + y);
                        ++i;
                    }
                    buf.append("'/>\n");
                    i = 0;
                    while (i <= this.m_nTicks) {
                        y = this.m_dt.getPosY((this.m_dt.m_fHeight - fHeight / this.m_dt.m_fUserScale * (float)i / (float)this.m_nTicks - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
                        String sStr = formatter.format(this.m_fGridOrigin + fHeight * (float)i / (float)this.m_nTicks * fUserSign);
                        buf.append("<text x='" + this.m_gridfont.getSize() + "' y='" + y + "' font-family='" + this.m_gridfont.getFamily() + "' " + "font-size='" + this.m_gridfont.getSize() + "pt' " + "font-style='" + (this.m_gridfont.isBold() ? "oblique" : "") + (this.m_gridfont.isItalic() ? "italic" : "") + "' " + "stroke='rgb(" + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getRed() + "," + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getGreen() + "," + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getBlue() + ")' " + ">" + sStr + "</text>\n");
                        ++i;
                    }
                } else {
                    float fHeight = this.m_fGridOffset;
                    while (fHeight < fTreeHeight) {
                        int y = this.m_dt.getPosY((this.m_dt.m_fHeight - fHeight / this.m_dt.m_fUserScale - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
                        buf.append("M0 " + y + "L" + nW + " " + y);
                        fHeight += Math.abs(this.m_fGridTicks);
                    }
                    buf.append("'/>\n");
                    fHeight = this.m_fGridOffset;
                    while (fHeight < fTreeHeight) {
                        String sStr = formatter.format(this.m_fGridOrigin + fHeight * fUserSign);
                        int y = this.m_dt.getPosY((this.m_dt.m_fHeight - fHeight / this.m_dt.m_fUserScale - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
                        buf.append("<text x='" + this.m_gridfont.getSize() + "' y='" + y + "' font-family='" + this.m_gridfont.getFamily() + "' " + "font-size='" + this.m_gridfont.getSize() + "pt' " + "font-style='" + (this.m_gridfont.isBold() ? "oblique" : "") + (this.m_gridfont.isItalic() ? "italic" : "") + "' " + "stroke='rgb(" + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getRed() + "," + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getGreen() + "," + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getBlue() + ")' " + ">" + sStr + "</text>\n");
                        fHeight += Math.abs(this.m_fGridTicks);
                    }
                }
            } else {
                int nH = this.m_dt.getHeight();
                if (this.m_nGridMode == GridMode.SHORT) {
                    nH = 10;
                }
                buf.append("<path fill='none' stroke='rgb(" + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getRed() + "," + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getGreen() + "," + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getBlue() + ")' " + "stroke-width='" + 1 + "' " + " d='");
                if (this.m_bAutoGrid) {
                    int x;
                    float fHeight = (float)this.adjust(this.m_dt.m_fHeight);
                    int i = 0;
                    while (i <= this.m_nTicks) {
                        x = this.m_dt.getPosX((this.m_dt.m_fHeight - fHeight * (float)i / (float)this.m_nTicks - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
                        buf.append("M" + x + " " + 0 + "L" + x + " " + nH);
                        ++i;
                    }
                    buf.append("'/>\n");
                    i = 0;
                    while (i <= this.m_nTicks) {
                        x = this.m_dt.getPosX((this.m_dt.m_fHeight - fHeight * (float)i / (float)this.m_nTicks - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
                        String sStr = formatter.format(this.m_fGridOrigin + fHeight * (float)i / (float)this.m_nTicks * fUserSign);
                        buf.append("<text x='" + x + "' y='" + this.m_gridfont.getSize() + "' font-family='" + this.m_gridfont.getFamily() + "' " + "font-size='" + this.m_gridfont.getSize() + "pt' " + "font-style='" + (this.m_gridfont.isBold() ? "oblique" : "") + (this.m_gridfont.isItalic() ? "italic" : "") + "' " + "stroke='rgb(" + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getRed() + "," + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getGreen() + "," + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getBlue() + ")' " + ">" + sStr + "</text>\n");
                        ++i;
                    }
                } else {
                    float fHeight = this.m_fGridOffset;
                    while (fHeight < this.m_dt.m_fHeight) {
                        int x = this.m_dt.getPosX((this.m_dt.m_fHeight - fHeight - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
                        buf.append("M" + x + " " + 0 + "L" + x + " " + nH);
                        fHeight += Math.abs(this.m_fGridTicks);
                    }
                    buf.append("'/>\n");
                    fHeight = this.m_fGridOffset;
                    while (fHeight < this.m_dt.m_fHeight) {
                        String sStr = formatter.format(this.m_fGridOrigin + fHeight * fUserSign);
                        int x = this.m_dt.getPosX((this.m_dt.m_fHeight - fHeight - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
                        buf.append("<text x='" + x + "' y='" + this.m_gridfont.getSize() + "' font-family='" + this.m_gridfont.getFamily() + "' " + "font-size='" + this.m_gridfont.getSize() + "pt' " + "font-style='" + (this.m_gridfont.isBold() ? "oblique" : "") + (this.m_gridfont.isItalic() ? "italic" : "") + "' " + "stroke='rgb(" + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getRed() + "," + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getGreen() + "," + this.m_dt.m_color[DensiTree.HEIGHTCOLOR].getBlue() + ")' " + ">" + sStr + "</text>\n");
                        fHeight += Math.abs(this.m_fGridTicks);
                    }
                }
            }
        }
    }

    void paintHeightInfo(Graphics g) {
        block15: {
            if (this.m_nGridMode == GridMode.NONE || !(this.m_dt.m_fHeight > 0.0f)) break block15;
            String format = "##.";
            int i = 0;
            while (i < this.m_nGridDigits) {
                format = String.valueOf(format) + "#";
                ++i;
            }
            DecimalFormat formatter = new DecimalFormat(format);
            ((Graphics2D)g).setStroke(new BasicStroke(1.0f, 0, 2));
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
            if (this.m_gridfont == null) {
                this.m_gridfont = new Font("SansSerif", 0, 10);
            }
            g.setFont(this.m_gridfont);
            float fUserScale = Math.abs(this.m_dt.m_fUserScale);
            float fUserSign = Math.signum(this.m_dt.m_fUserScale);
            if (this.m_bReverseGrid) {
                fUserSign = -fUserSign;
            }
            if (this.m_dt.m_treeDrawer.m_bRootAtTop) {
                int nW = (int)((float)this.m_dt.getWidth() * this.m_dt.m_fScale);
                if (this.m_nGridMode == GridMode.SHORT) {
                    nW = 10;
                }
                g.setColor(this.m_dt.m_color[DensiTree.HEIGHTCOLOR]);
                float fTreeHeight = this.m_dt.m_fHeight * fUserScale;
                if (this.m_bAutoGrid) {
                    float fHeight = (float)this.adjust(fTreeHeight);
                    int i2 = 0;
                    while (i2 <= this.m_nTicks) {
                        String sStr = formatter.format(this.m_fGridOrigin + fHeight * (float)i2 / (float)this.m_nTicks * fUserSign);
                        int y = this.m_dt.getPosY((this.m_dt.m_fHeight - fHeight / fUserScale * (float)i2 / (float)this.m_nTicks - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
                        g.drawString(sStr, 0, y - 2);
                        g.drawLine(0, y, nW, y);
                        ++i2;
                    }
                } else {
                    float fHeight = this.m_fGridOffset;
                    while (fHeight < this.m_dt.m_fHeight * fUserScale) {
                        String sStr = formatter.format(this.m_fGridOrigin + fHeight * fUserSign);
                        int y = this.m_dt.getPosY((this.m_dt.m_fHeight - fHeight / fUserScale - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
                        g.drawString(sStr, 0, y - 2);
                        g.drawLine(0, y, nW, y);
                        fHeight += Math.abs(this.m_fGridTicks);
                    }
                }
            } else {
                int nH;
                int maxH = 0;
                int strPos = nH = (int)((float)this.m_dt.getHeight() * this.m_dt.m_fScale);
                if (this.m_nGridMode == GridMode.SHORT) {
                    maxH = nH;
                    nH = maxH - 10;
                }
                g.setColor(this.m_dt.m_color[DensiTree.HEIGHTCOLOR]);
                float fTreeHeight = this.m_dt.m_fHeight * fUserScale;
                if (this.m_bAutoGrid) {
                    float fHeight = (float)this.adjust(fTreeHeight);
                    int i3 = 0;
                    while (i3 <= this.m_nTicks) {
                        String sStr = formatter.format(this.m_fGridOrigin + fHeight * (float)i3 / (float)this.m_nTicks * fUserSign);
                        int x = this.m_dt.getPosX((this.m_dt.m_fHeight - fHeight / fUserScale * (float)i3 / (float)this.m_nTicks - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
                        g.drawString(sStr, x + 2, strPos - this.m_gridfont.getSize());
                        g.drawLine(x, maxH, x, nH);
                        ++i3;
                    }
                } else {
                    float fHeight = this.m_fGridOffset;
                    while (fHeight < fTreeHeight) {
                        String sStr = formatter.format(this.m_fGridOrigin + fHeight * fUserSign);
                        int x = this.m_dt.getPosX((this.m_dt.m_fHeight - fHeight / fUserScale - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
                        g.drawString(sStr, x + 2, strPos - this.m_gridfont.getSize());
                        g.drawLine(x, maxH, x, nH);
                        fHeight += Math.abs(this.m_fGridTicks);
                    }
                }
            }
        }
    }

    private double adjust(double fYMax) {
        int k = 0;
        double fY = fYMax;
        while (fY > 10.0) {
            fY /= 10.0;
            ++k;
        }
        while (fY < 1.0 && fY > 0.0) {
            fY *= 10.0;
            --k;
        }
        fY = Math.ceil(fY);
        this.m_nTicks = this.NR_OF_TICKS[(int)fY];
        this.m_nTicks *= (int)this.m_dt.m_fTreeScale;
        int i = 0;
        while (i < k) {
            fY *= 10.0;
            ++i;
        }
        i = k;
        while (i < 0) {
            fY /= 10.0;
            ++i;
        }
        return fY;
    }

    public static enum GridMode {
        NONE,
        SHORT,
        FULL;

    }
}

