/*
 * Decompiled with CFR 0.152.
 */
package viz.graphics;

import java.awt.Component;
import java.awt.Graphics;
import viz.graphics.BufferedImageF;

public class BufferedImageBounded
extends BufferedImageF {
    float[] m_fCount;

    public BufferedImageBounded(int nWidth, int nHeight) {
        super(nWidth, nHeight);
        this.m_fCount = new float[nHeight * nWidth];
    }

    @Override
    void plot(int x, int y, float fAlpha, int nRed, int nGreen, int nBlue) {
        super.plot(x, y, fAlpha, nRed, nGreen, nBlue);
        int p = y * this.m_nWidth + x;
        if (p < this.m_fCount.length) {
            int n = p;
            this.m_fCount[n] = this.m_fCount[n] + fAlpha;
        }
    }

    @Override
    public void drawImage(Graphics g, Component component) {
        int[] rgbArray = new int[this.m_nWidth * this.m_nHeight];
        int k = 0;
        int y = 0;
        while (y < this.m_nHeight) {
            int x = 0;
            while (x < this.m_nWidth) {
                int nRGB = this.m_nR[k] & 0xFF0000;
                nRGB += (this.m_nG[k] & 0xFF0000) >> 8;
                rgbArray[k++] = (nRGB += (this.m_nB[k] & 0xFF0000) >> 16) | 0xFF000000;
                ++x;
            }
            ++y;
        }
        this.drawBounds(rgbArray);
        this.m_localImage.setRGB(0, 0, this.m_nWidth, this.m_nHeight, rgbArray, 0, this.m_nWidth);
        g.drawImage(this.m_localImage, 0, 0, component);
    }

    /*
     * Unable to fully structure code
     */
    void drawBounds(int[] rgbArray) {
        block9: {
            if (!this.m_bIsHorizontal) break block9;
            i = 0;
            while (i < this.m_nWidth) {
                block10: {
                    fSum = 0.0f;
                    j = 0;
                    while (j < this.m_nHeight) {
                        fSum += this.m_fCount[j * this.m_nWidth + i];
                        ++j;
                    }
                    if (!(fSum > 0.0f)) break block10;
                    fHPD = 0.9f * fSum;
                    jOptMin = 0;
                    jOptMax = this.m_nHeight;
                    k = 0;
                    fPartSum = 0.0f;
                    j = 0;
                    ** GOTO lbl27
                    {
                        fPartSum += this.m_fCount[k * this.m_nWidth + i];
                        ++k;
                        do {
                            if (fPartSum < fHPD && k < this.m_nHeight) continue block2;
                            if (k - j < jOptMax - jOptMin) {
                                jOptMin = j;
                                jOptMax = k;
                            }
                            fPartSum -= this.m_fCount[j * this.m_nWidth + i];
                            ++j;
lbl27:
                            // 2 sources

                        } while (j < this.m_nHeight && k < this.m_nHeight);
                    }
                    k = 0;
                    fPartSum = 0.0f;
                    while (fPartSum < fSum / 2.0f) {
                        fPartSum += this.m_fCount[k * this.m_nWidth + i];
                        ++k;
                    }
                    jOptMin = Math.max(jOptMin, 1);
                    jOptMax = Math.min(jOptMax, this.m_nHeight - 1);
                    j = -1;
                    while (j < 2) {
                        if (jOptMin + j > 0) {
                            rgbArray[(jOptMin + j) * this.m_nWidth + i] = -16777216;
                        }
                        if (jOptMax + j - 1 > 0) {
                            rgbArray[(jOptMax + j - 1) * this.m_nWidth + i] = -16777216;
                        }
                        rgbArray[(k + j) * this.m_nWidth + i] = -16777216;
                        ++j;
                    }
                }
                ++i;
            }
        }
    }
}

