/*
 * Decompiled with CFR 0.152.
 */
package viz.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import viz.DensiTree;
import viz.Node;
import viz.TreeFileParser;

public class ImportRootCanalDialog
extends JPanel {
    private static final long serialVersionUID = 1L;
    DensiTree m_dt;
    ButtonGroup group;
    JRadioButton b1 = new JRadioButton("Newick tree:");
    JRadioButton b2 = new JRadioButton("Use summary_tree");
    private JTextField txtNewick;
    private final JSeparator separator = new JSeparator();
    private final JComboBox<STOption> comboBox = new JComboBox();
    private final JLabel lblTopTrees = new JLabel("# top trees");
    private final JTextField textField = new JTextField();
    private final JLabel lblTimeLimitseconds = new JLabel("time limit (seconds)");
    private final JTextField textField_1 = new JTextField();

    public ImportRootCanalDialog(DensiTree dt) {
        this.textField_1.setText("-1");
        this.textField_1.setColumns(10);
        this.textField.setText("1");
        this.textField.setColumns(10);
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[3];
        nArray[1] = 203;
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = new int[6];
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 1.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc_rdbtnNewRadioButton = new GridBagConstraints();
        gbc_rdbtnNewRadioButton.anchor = 17;
        gbc_rdbtnNewRadioButton.insets = new Insets(0, 0, 5, 5);
        gbc_rdbtnNewRadioButton.gridx = 0;
        gbc_rdbtnNewRadioButton.gridy = 0;
        this.b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportRootCanalDialog.this.update();
            }
        });
        this.add((Component)this.b1, gbc_rdbtnNewRadioButton);
        this.b1.setSelected(true);
        this.txtNewick = new JTextField();
        this.txtNewick.setText("newick");
        GridBagConstraints gbc_txtNewick = new GridBagConstraints();
        gbc_txtNewick.insets = new Insets(0, 0, 5, 0);
        gbc_txtNewick.fill = 2;
        gbc_txtNewick.gridx = 1;
        gbc_txtNewick.gridy = 0;
        gbc_txtNewick.gridwidth = 2;
        this.add((Component)this.txtNewick, gbc_txtNewick);
        this.txtNewick.setColumns(10);
        GridBagConstraints gbc_separator = new GridBagConstraints();
        gbc_separator.fill = 2;
        gbc_separator.gridwidth = 2;
        gbc_separator.insets = new Insets(0, 0, 5, 5);
        gbc_separator.gridx = 0;
        gbc_separator.gridy = 1;
        this.add((Component)this.separator, gbc_separator);
        GridBagConstraints gbc_rdbtnNewRadioButton_1 = new GridBagConstraints();
        gbc_rdbtnNewRadioButton_1.anchor = 17;
        gbc_rdbtnNewRadioButton_1.insets = new Insets(0, 0, 5, 5);
        gbc_rdbtnNewRadioButton_1.gridx = 0;
        gbc_rdbtnNewRadioButton_1.gridy = 2;
        this.add((Component)this.b2, gbc_rdbtnNewRadioButton_1);
        this.b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportRootCanalDialog.this.update();
            }
        });
        this.m_dt = dt;
        this.group = new ButtonGroup();
        this.group.add(this.b1);
        this.group.add(this.b2);
        GridBagConstraints gbc_comboBox = new GridBagConstraints();
        gbc_comboBox.gridwidth = 2;
        gbc_comboBox.insets = new Insets(0, 0, 5, 0);
        gbc_comboBox.fill = 2;
        gbc_comboBox.gridx = 1;
        gbc_comboBox.gridy = 2;
        this.comboBox.addItem(new STOption("Taxon partitions", "--method taxon-partitions", false));
        this.comboBox.addItem(new STOption("Clade ca", "--method clade-ca", false));
        this.comboBox.addItem(new STOption("Min. distance by height score", "--method min-distance  --distance-method heights-score", true));
        this.comboBox.addItem(new STOption("Min. distance by heights only", "--method min-distance  --distance-method heights-only", true));
        this.comboBox.addItem(new STOption("Min. distance by branch score", "--method min-distance  --distance-method branch-score", true));
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportRootCanalDialog.this.update();
            }
        });
        this.add(this.comboBox, gbc_comboBox);
        GridBagConstraints gbc_lblTopTrees = new GridBagConstraints();
        gbc_lblTopTrees.insets = new Insets(0, 0, 5, 5);
        gbc_lblTopTrees.anchor = 17;
        gbc_lblTopTrees.gridx = 1;
        gbc_lblTopTrees.gridy = 3;
        this.add((Component)this.lblTopTrees, gbc_lblTopTrees);
        GridBagConstraints gbc_textField = new GridBagConstraints();
        gbc_textField.insets = new Insets(0, 0, 5, 0);
        gbc_textField.fill = 2;
        gbc_textField.gridx = 2;
        gbc_textField.gridy = 3;
        this.add((Component)this.textField, gbc_textField);
        GridBagConstraints gbc_lblTimeLimitseconds = new GridBagConstraints();
        gbc_lblTimeLimitseconds.anchor = 17;
        gbc_lblTimeLimitseconds.insets = new Insets(0, 0, 0, 5);
        gbc_lblTimeLimitseconds.gridx = 1;
        gbc_lblTimeLimitseconds.gridy = 4;
        this.add((Component)this.lblTimeLimitseconds, gbc_lblTimeLimitseconds);
        GridBagConstraints gbc_textField_1 = new GridBagConstraints();
        gbc_textField_1.fill = 2;
        gbc_textField_1.gridx = 2;
        gbc_textField_1.gridy = 4;
        this.add((Component)this.textField_1, gbc_textField_1);
        this.update();
    }

    private void update() {
        if (this.b2.getModel() == this.group.getSelection()) {
            STOption option = (STOption)this.comboBox.getSelectedItem();
            this.textField_1.setEnabled(option.m_bHasExtraOptions);
            this.textField.setEnabled(option.m_bHasExtraOptions);
            this.lblTopTrees.setEnabled(option.m_bHasExtraOptions);
            this.lblTimeLimitseconds.setEnabled(option.m_bHasExtraOptions);
            this.comboBox.setEnabled(true);
            this.txtNewick.setEnabled(false);
        } else {
            this.textField_1.setEnabled(false);
            this.textField.setEnabled(false);
            this.lblTopTrees.setEnabled(false);
            this.lblTimeLimitseconds.setEnabled(false);
            this.comboBox.setEnabled(false);
            this.txtNewick.setEnabled(true);
        }
    }

    public boolean showDialog(JComponent parent) {
        JOptionPane optionPane = new JOptionPane(this, -1, 2, null, new String[]{"Cancel", "OK"}, "OK");
        optionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        JDialog dialog = optionPane.createDialog(parent, "Import root canal tree");
        dialog.setName("ImportRootCanal");
        dialog.pack();
        dialog.setVisible(true);
        if (!optionPane.getValue().equals("OK")) {
            return false;
        }
        String newick = null;
        if (this.b1.getModel() == this.group.getSelection()) {
            newick = this.txtNewick.getText();
        }
        if (this.b2.getModel() == this.group.getSelection()) {
            this.m_dt.setWaitCursor();
            try {
                String line;
                double fBurnIn = this.m_dt.m_bBurnInIsPercentage ? (double)this.m_dt.m_nBurnIn : 100.0 * (double)this.m_dt.m_nBurnIn / (double)(this.m_dt.m_nBurnIn + this.m_dt.m_trees.length);
                STOption option = (STOption)this.comboBox.getSelectedItem();
                String sCmd = "summary_tree --burnin " + fBurnIn + " " + option.m_sOptions;
                if (option.m_bHasExtraOptions) {
                    sCmd = String.valueOf(sCmd) + " --ntops " + this.textField.getText() + " --limit " + this.textField_1.getText();
                }
                sCmd = String.valueOf(sCmd) + " " + this.m_dt.m_sFileName;
                System.err.println("Trying to execute: " + sCmd);
                Process p = Runtime.getRuntime().exec(sCmd);
                BufferedReader pout = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader perr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((line = pout.readLine()) != null) {
                    newick = line;
                }
                pout.close();
                while ((line = perr.readLine()) != null) {
                    System.err.println(line);
                }
                perr.close();
                p.waitFor();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            this.m_dt.setDefaultCursor();
        }
        if (newick != null) {
            TreeFileParser parser = new TreeFileParser(this.m_dt.m_sLabels, null, null, 0);
            try {
                Node tree = parser.parseNewick(newick);
                tree.sort();
                System.err.println("labelInternalNodes");
                tree.labelInternalNodes(this.m_dt.m_sLabels.size());
                System.err.println("positionHeight");
                float fTreeHeight = this.m_dt.positionHeight(tree, 0.0f);
                System.err.println("offsetHeight");
                this.m_dt.offsetHeight(tree, this.m_dt.m_fHeight - fTreeHeight);
                System.err.println("calcCladeIDForNode");
                this.m_dt.calcCladeIDForNode(tree, this.m_dt.mapCladeToIndex);
                System.err.println("resetCladeNr");
                this.m_dt.resetCladeNr(tree, this.m_dt.reverseindex);
                this.m_dt.m_summaryTree.add(tree);
                return true;
            }
            catch (Exception e) {
                System.err.println("ImportRootCanalDialog: " + e.getMessage());
            }
        }
        return false;
    }

    class STOption {
        String m_sDisplay;
        String m_sOptions;
        boolean m_bHasExtraOptions;

        public STOption(String sDisplay, String sOptions, boolean bHasExtraOptions) {
            this.m_sDisplay = sDisplay;
            this.m_sOptions = sOptions;
            this.m_bHasExtraOptions = bHasExtraOptions;
        }

        public String toString() {
            return this.m_sDisplay;
        }
    }
}

