/*
 * Decompiled with CFR 0.152.
 */
package viz.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CladeBranchInfo {
    int count = 0;
    int totalNrOfTrees = 0;
    float[] cumscore;
    List<Float> height = new ArrayList<Float>();
    private float score;
    private float oldLength = -1.0f;
    private float dScore;
    private float dOldLength = -1.0f;

    void initialise(List<Double> cladeHeightSetBottom, List<Double> cladeHeightSetTop, int totalNrOfTrees) {
        this.totalNrOfTrees = totalNrOfTrees;
        int i = 0;
        while (i < cladeHeightSetBottom.size()) {
            this.height.add(Float.valueOf((float)(cladeHeightSetBottom.get(i) - cladeHeightSetTop.get(i))));
            ++i;
        }
        Collections.sort(this.height);
        this.count = this.height.size();
        float[] revcumscore = new float[this.count];
        this.cumscore = new float[this.count];
        this.cumscore[0] = 0.0f;
        int i2 = 1;
        while (i2 < this.count) {
            this.cumscore[i2] = this.cumscore[i2 - 1] + (this.height.get(i2).floatValue() - this.height.get(i2 - 1).floatValue()) * (float)i2;
            ++i2;
        }
        revcumscore[this.count - 1] = 0.0f;
        i2 = this.count - 2;
        while (i2 >= 0) {
            revcumscore[i2] = revcumscore[i2 + 1] + (this.height.get(i2 + 1).floatValue() - this.height.get(i2).floatValue()) * (float)(this.count - i2 - 1);
            --i2;
        }
        i2 = 0;
        while (i2 < this.count) {
            int n = i2;
            this.cumscore[n] = this.cumscore[n] + revcumscore[i2];
            ++i2;
        }
    }

    float score(float bottom, float top) {
        if (this.count == 0) {
            return 0.0f;
        }
        float length = top - bottom;
        if (length == this.oldLength) {
            return this.score;
        }
        this.oldLength = length;
        if ((double)length < -1.0E-8) {
            return Float.POSITIVE_INFINITY;
        }
        this.score = length * (float)(this.totalNrOfTrees - this.count);
        int i = Collections.binarySearch(this.height, Float.valueOf(length));
        if (i >= 0) {
            this.score += this.cumscore[i];
            return this.score;
        }
        if ((i = -1 - i) >= this.count) {
            this.score += this.cumscore[this.count - 1];
            this.score += (length - this.height.get(this.count - 1).floatValue()) * (float)this.count;
            return this.score;
        }
        if (i == 0) {
            this.score += this.cumscore[0];
            this.score += (this.height.get(0).floatValue() - length) * (float)this.count;
            return this.score;
        }
        this.score += this.cumscore[i - 1];
        this.score += (length - this.height.get(i - 1).floatValue()) / (this.height.get(i).floatValue() - this.height.get(i - 1).floatValue()) * (this.cumscore[i] - this.cumscore[i - 1]);
        return this.score;
    }

    float dScore(float bottom, float top) {
        float length = top - bottom;
        if (length == this.dOldLength) {
            return this.dScore;
        }
        this.dOldLength = length;
        int i = Collections.binarySearch(this.height, Float.valueOf(length));
        if (i < 0) {
            i = -1 - i;
        }
        if (i >= this.count) {
            this.dScore = this.count;
            return this.dScore;
        }
        if (i == 0) {
            this.dScore = -this.count;
            return this.dScore;
        }
        this.dScore += (this.cumscore[i] - this.cumscore[i - 1]) / (this.height.get(i).floatValue() - this.height.get(i - 1).floatValue());
        return this.dScore;
    }

    public float getMaxLength() {
        return this.height.get(this.count - 1).floatValue();
    }
}

