/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.beauti.PartitionContext;
import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.core.MCMC;
import beast.core.Operator;
import java.lang.reflect.Method;
import java.util.List;

@Description(value="Specifies which part of the template get connected to the main network")
public class BeautiConnector
extends BEASTObject {
    public final Input<String> methodnput = new Input("method", "name of static method that should be called with BeautiDoc as argument. For example beast.app.beauti.SiteModelInputEditor.custmoConnector");
    public final Input<String> sourceIDInput = new Input("srcID", "ID of the beastObject to be connected", Input.Validate.XOR, this.methodnput);
    public final Input<String> targetIDInput = new Input("targetID", "ID of beastObject to connect to", Input.Validate.XOR, this.methodnput);
    public final Input<String> inputNameInput = new Input("inputName", "name of the input of the beastObject to connect to", Input.Validate.XOR, this.methodnput);
    public final Input<String> tipText = new Input("value", "associate some tip text with the srcID beastObject, useful for displaying prior and operator specific information");
    public final Input<String> conditionInput = new Input("if", "condition under which this connector should be executed.These should be of the form inposterior(id) or id/input=value, e.g. inposterior(kappa), kappa/estimate=true. inlikelihood(id) to check there is a beastObject with suplied id that is predecessor of likelihood. nooperator(id) to check there is no operator with suplied id. isInitialising to execute only when subtemplate is first instantiated. For partition specific ids, use $(n), e.g. e.g. kappa.$(n)/estimate=true. For multiple conditions, separate by 'and', e.g. inposterior(kappa.$(n)) and kappa.$(n)/estimate=true");
    String sourceID;
    String targetID;
    String targetInput;
    String[] conditionIDs;
    String[] conditionInputs;
    Operation[] conditionOperations;
    String[] conditionValues;
    boolean isRegularConnector = true;
    Method method = null;

    public BeautiConnector() {
    }

    public BeautiConnector(String string, String string2, String string3, String string4) {
        this.initByName("srcID", string, "targetID", string2, "inputName", string3, "if", string4);
    }

    @Override
    public void initAndValidate() {
        Object object;
        Object object2;
        this.sourceID = this.sourceIDInput.get();
        this.targetID = this.targetIDInput.get();
        this.targetInput = this.inputNameInput.get();
        if (this.conditionInput.get() != null) {
            object2 = this.conditionInput.get().split("\\s+and\\s+");
            this.conditionIDs = new String[((String[])object2).length];
            this.conditionInputs = new String[((String[])object2).length];
            this.conditionValues = new String[((String[])object2).length];
            this.conditionOperations = new Operation[((String[])object2).length];
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object = object2[i];
                if (((String)object).startsWith("inposterior(")) {
                    this.conditionIDs[i] = ((String)object).substring(((String)object).indexOf("(") + 1, ((String)object).lastIndexOf(")"));
                    this.conditionInputs[i] = null;
                    this.conditionOperations[i] = Operation.IS_IN_POSTERIOR;
                    this.conditionValues[i] = null;
                    continue;
                }
                if (((String)object).startsWith("inlikelihood(")) {
                    this.conditionIDs[i] = ((String)object).substring(((String)object).indexOf("(") + 1, ((String)object).lastIndexOf(")"));
                    this.conditionInputs[i] = null;
                    this.conditionOperations[i] = Operation.IS_IN_LIKELIHOOD;
                    this.conditionValues[i] = null;
                    continue;
                }
                if (((String)object).startsWith("nooperator")) {
                    this.conditionIDs[i] = ((String)object).substring(((String)object).indexOf("(") + 1, ((String)object).lastIndexOf(")"));
                    this.conditionOperations[i] = Operation.IS_NOT_AN_OPERTOR;
                    this.conditionInputs[i] = null;
                    this.conditionValues[i] = null;
                    continue;
                }
                if (((String)object).startsWith("isInitializing")) {
                    this.conditionIDs[i] = null;
                    this.conditionOperations[i] = Operation.AT_INITIALISATION_ONLY;
                    this.conditionInputs[i] = null;
                    this.conditionValues[i] = null;
                    continue;
                }
                this.conditionIDs[i] = ((String)object).substring(0, ((String)object).indexOf("/"));
                this.conditionInputs[i] = ((String)object).substring(((String)object).indexOf("/") + 1, ((String)object).indexOf("="));
                this.conditionValues[i] = ((String)object).substring(((String)object).indexOf("=") + 1);
                this.conditionOperations[i] = Operation.EQUALS;
                if (!this.conditionInputs[i].endsWith("!")) continue;
                this.conditionInputs[i] = this.conditionInputs[i].substring(0, this.conditionInputs[i].length() - 1);
                this.conditionOperations[i] = Operation.NOT_EQUALS;
            }
        } else {
            this.conditionIDs = new String[0];
            this.conditionInputs = new String[0];
            this.conditionOperations = new Operation[0];
            this.conditionValues = new String[0];
        }
        if (this.methodnput.get() != null) {
            object2 = this.methodnput.get();
            String string = ((String)object2).substring(0, ((String)object2).lastIndexOf(46));
            object = ((String)object2).substring(((String)object2).lastIndexOf(46) + 1);
            try {
                Class<?> clazz = Class.forName(string);
                this.method = clazz.getMethod((String)object, BeautiDoc.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            this.isRegularConnector = false;
        }
    }

    public boolean atInitialisationOnly() {
        if (this.conditionOperations.length > 0) {
            return this.conditionOperations[0].equals((Object)Operation.AT_INITIALISATION_ONLY);
        }
        return false;
    }

    public boolean isActivated(PartitionContext partitionContext, List<BEASTInterface> list, List<BEASTInterface> list2, BeautiDoc beautiDoc) {
        Object object;
        String string;
        if (this.atInitialisationOnly()) {
            return false;
        }
        if (this.methodnput.get() != null) {
            try {
                String string2 = this.methodnput.get();
                String string3 = string2.substring(0, string2.lastIndexOf(46));
                string = string2.substring(string2.lastIndexOf(46) + 1);
                object = Class.forName(string3);
                this.method = ((Class)object).getMethod(string, BeautiDoc.class);
                this.method.invoke(null, beautiDoc);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl = true;
        block11: for (int i = 0; i < this.conditionIDs.length; ++i) {
            string = BeautiDoc.translatePartitionNames(this.conditionIDs[i], partitionContext);
            object = beautiDoc.pluginmap.get(string);
            if (object == null && this.conditionOperations[i] != Operation.IS_NOT_AN_OPERTOR) {
                return false;
            }
            try {
                switch (this.conditionOperations[i]) {
                    case IS_IN_POSTERIOR: {
                        if (list.contains(object)) continue block11;
                        return false;
                    }
                    case IS_IN_LIKELIHOOD: {
                        if (list2.contains(object)) continue block11;
                        return false;
                    }
                    case IS_NOT_AN_OPERTOR: {
                        List<Operator> list3 = ((MCMC)beautiDoc.mcmc.get()).operatorsInput.get();
                        if (!list3.contains(object)) continue block11;
                        return false;
                    }
                    case EQUALS: {
                        Input<?> input = object.getInput(this.conditionInputs[i]);
                        if (!(input.get() == null ? !this.conditionValues[i].equals("null") : !input.get().toString().equals(this.conditionValues[i]))) continue block11;
                        return false;
                    }
                    case NOT_EQUALS: {
                        Input<?> input = object.getInput(this.conditionInputs[i]);
                        if (!(input.get() == null ? this.conditionValues[i].equals("null") : input.get().toString().equals(this.conditionValues[i]))) continue block11;
                        return false;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected operation: " + (Object)((Object)this.conditionOperations[i]));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return bl;
    }

    public String getTipText() {
        return this.tipText.get();
    }

    @Override
    public String toString() {
        if (this.methodnput.get() != null) {
            return "call " + this.methodnput.get();
        }
        return "@" + this.sourceID + " -> @" + this.targetID + "/" + this.targetInput;
    }

    public String toString(PartitionContext partitionContext) {
        if (this.methodnput.get() != null) {
            return this.toString();
        }
        return "@" + BeautiDoc.translatePartitionNames(this.sourceID, partitionContext) + " -> @" + this.targetID + "/" + BeautiDoc.translatePartitionNames(this.targetInput, partitionContext);
    }

    static enum Operation {
        EQUALS,
        NOT_EQUALS,
        IS_IN_POSTERIOR,
        IS_IN_LIKELIHOOD,
        IS_NOT_AN_OPERTOR,
        AT_INITIALISATION_ONLY;

    }
}

