/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiPanel;
import beast.app.beauti.guiutil.S11InitialSelection;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ClonePartitionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    final BeautiPanel beautiPanel;
    final JComboBox<Object> cloneFromComboBox;
    final JButton okButton = new JButton("OK");

    public ClonePartitionPanel(BeautiPanel beautiPanel) {
        this.beautiPanel = beautiPanel;
        DefaultListModel<String> defaultListModel = beautiPanel.listModel;
        Object[] objectArray = new Object[defaultListModel.getSize()];
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            objectArray[i] = defaultListModel.getElementAt(i);
        }
        this.cloneFromComboBox = new JComboBox<Object>(objectArray);
        this.cloneFromComboBox.setEditable(true);
        new S11InitialSelection(this.cloneFromComboBox);
        this.init();
    }

    public void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel(new FlowLayout());
        JLabel jLabel = new JLabel("Clone from");
        jPanel.add(jLabel);
        this.cloneFromComboBox.setMaximumRowCount(10);
        jPanel.add(this.cloneFromComboBox);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(jPanel);
        this.add(Box.createVerticalGlue());
        this.add(Box.createVerticalStrut(5));
        this.okButton.setName("ok");
        this.okButton.setToolTipText("Click to clone configuration from the above selected partition into all selected partitions on the left.");
        this.okButton.addActionListener(actionEvent -> this.clonePartitions());
        this.add(this.okButton);
    }

    protected void clonePartitions() {
        String string = this.cloneFromComboBox.getSelectedItem().toString();
        for (String string2 : this.beautiPanel.listOfPartitions.getSelectedValuesList()) {
            this.beautiPanel.cloneFrom(string, string2.toString());
        }
    }
}

