/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.beauti.BeautiSubTemplate;
import beast.app.beauti.PartitionContext;
import beast.app.draw.InputEditor;
import beast.app.draw.SmallLabel;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.evolution.tree.Tree;
import beast.evolution.tree.TreeDistribution;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class TreeDistributionInputEditor
extends InputEditor.Base {
    private static final long serialVersionUID = 1L;
    ActionEvent m_e;

    public TreeDistributionInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return TreeDistribution.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        this.m_bAddButtons = bl;
        this.m_input = input;
        this.m_beastObject = bEASTInterface;
        this.itemNr = n;
        Box box = Box.createHorizontalBox();
        TreeDistribution treeDistribution = (TreeDistribution)bEASTInterface;
        String string = "";
        string = treeDistribution.treeInput.get() != null ? string + treeDistribution.treeInput.get().getID() : string + treeDistribution.treeIntervalsInput.get().treeInput.get().getID();
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Dimension dimension = new Dimension(font.getSize() * 200 / 12, font.getSize() * 2);
        jLabel.setMinimumSize(dimension);
        jLabel.setPreferredSize(dimension);
        box.add(jLabel);
        List<BeautiSubTemplate> list = this.doc.getInputEditorFactory().getAvailableTemplates(this.m_input, this.m_beastObject, null, this.doc);
        for (int i = list.size() - 1; i >= 0; --i) {
            BeautiSubTemplate beautiSubTemplate = list.get(i);
            Class<?> clazz = beautiSubTemplate._class;
            if (TreeDistribution.class.isAssignableFrom(clazz)) continue;
            list.remove(i);
        }
        JComboBox<BeautiSubTemplate> jComboBox = new JComboBox<BeautiSubTemplate>(list.toArray(new BeautiSubTemplate[0]));
        jComboBox.setName("TreeDistribution");
        for (int i = list.size() - 1; i >= 0; --i) {
            if (TreeDistribution.class.isAssignableFrom(list.get((int)i)._class)) continue;
            list.remove(i);
        }
        String string2 = treeDistribution.getID();
        try {
            string2 = string2.substring(0, string2.indexOf(46));
        }
        catch (Exception exception) {
            throw new RuntimeException("Improperly formatted ID: " + treeDistribution.getID());
        }
        for (BeautiSubTemplate beautiSubTemplate : list) {
            if (!beautiSubTemplate.matchesName(string2)) continue;
            jComboBox.setSelectedItem(beautiSubTemplate);
        }
        jComboBox.addActionListener(actionEvent -> {
            this.m_e = actionEvent;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JComboBox jComboBox = (JComboBox)TreeDistributionInputEditor.this.m_e.getSource();
                    List list = (List)TreeDistributionInputEditor.this.m_input.get();
                    BeautiSubTemplate beautiSubTemplate = (BeautiSubTemplate)jComboBox.getSelectedItem();
                    PartitionContext partitionContext = TreeDistributionInputEditor.this.doc.getContextFor((BEASTInterface)list.get(TreeDistributionInputEditor.this.itemNr));
                    try {
                        beautiSubTemplate.createSubNet(partitionContext, list, TreeDistributionInputEditor.this.itemNr, true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    TreeDistributionInputEditor.this.sync();
                    TreeDistributionInputEditor.this.refreshPanel();
                }
            });
        });
        box.add(jComboBox);
        box.add(Box.createGlue());
        this.m_validateLabel = new SmallLabel("x", new Color(200, 0, 0));
        this.m_validateLabel.setVisible(false);
        this.validateInput();
        box.add(this.m_validateLabel);
        this.add(box);
    }

    @Override
    public void validateInput() {
        TreeDistribution treeDistribution = (TreeDistribution)this.m_beastObject;
        Tree tree = (Tree)treeDistribution.treeInput.get();
        if (tree == null) {
            tree = treeDistribution.treeIntervalsInput.get().treeInput.get();
        }
        if (tree.hasDateTrait() && !treeDistribution.canHandleTipDates()) {
            this.m_validateLabel.setToolTipText("This tree prior cannot handle dated tips. Choose another tree prior.");
            this.m_validateLabel.m_circleColor = Color.red;
            this.m_validateLabel.setVisible(true);
            return;
        }
        super.validateInput();
    }
}

