/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.core.Operator;
import beast.core.parameter.IntegerParameter;
import beast.util.Randomizer;

@Description(value="A random walk operator that selects a random dimension of the integer parameter and perturbs the value a random amount within +/- windowSize.")
public class IntRandomWalkOperator
extends Operator {
    public final Input<Integer> windowSizeInput = new Input("windowSize", "the size of the window both up and down", Input.Validate.REQUIRED);
    public final Input<IntegerParameter> parameterInput = new Input("parameter", "the parameter to operate a random walk on.", Input.Validate.REQUIRED);
    int windowSize = 1;

    @Override
    public void initAndValidate() {
        this.windowSize = this.windowSizeInput.get();
    }

    @Override
    public double proposal() {
        int n;
        IntegerParameter integerParameter = this.parameterInput.get(this);
        int n2 = (Integer)integerParameter.getValue(n = Randomizer.nextInt(integerParameter.getDimension()));
        int n3 = n2 + Randomizer.nextInt(2 * this.windowSize + 1) - this.windowSize;
        if (n3 < (Integer)integerParameter.getLower() || n3 > (Integer)integerParameter.getUpper()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n3 == n2) {
            return Double.NEGATIVE_INFINITY;
        }
        integerParameter.setValue(n, n3);
        return 0.0;
    }

    @Override
    public void optimize(double d) {
    }
}

