/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.core.Operator;
import beast.core.StateNode;
import beast.core.parameter.Parameter;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.util.Randomizer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

@Description(value="This element represents an operator that scales two parameters in different directions. Each operation involves selecting a scale uniformly at random between scaleFactor and 1/scaleFactor. The up parameter is multiplied by this scale and the down parameter is divided by this scale.")
public class UpDownOperator
extends Operator {
    public final Input<Double> scaleFactorInput = new Input("scaleFactor", "magnitude factor used for scaling", Input.Validate.REQUIRED);
    public final Input<List<StateNode>> upInput = new Input("up", "zero or more items to scale upwards", new ArrayList());
    public final Input<List<StateNode>> downInput = new Input("down", "zero or more items to scale downwards", new ArrayList());
    public final Input<Boolean> optimiseInput = new Input<Boolean>("optimise", "flag to indicate that the scale factor is automatically changed in order to acheive a good acceptance rate (default true)", true);
    public final Input<Boolean> elementWiseInput = new Input<Boolean>("elementWise", "flag to indicate that the scaling is applied to a random index in multivariate parameters (default false)", false);
    public final Input<Double> scaleUpperLimit = new Input<Double>("upper", "Upper Limit of scale factor", 1.0);
    public final Input<Double> scaleLowerLimit = new Input<Double>("lower", "Lower limit of scale factor", 0.0);
    double scaleFactor;
    private double upper;
    private double lower;

    @Override
    public void initAndValidate() {
        this.scaleFactor = this.scaleFactorInput.get();
        if (this.upInput.get().size() + this.downInput.get().size() == 0) {
            Log.warning.println("WARNING: At least one up or down item must be specified");
        }
        if (this.upInput.get().size() == 0 || this.downInput.get().size() == 0) {
            Log.warning.println("WARNING: no " + (this.upInput.get().size() == 0 ? "up" : "down") + " item specified in UpDownOperator");
        }
        this.upper = this.scaleUpperLimit.get();
        this.lower = this.scaleLowerLimit.get();
    }

    @Override
    public final double proposal() {
        double d = this.scaleFactor + Randomizer.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
        int n = 0;
        int n2 = 0;
        if (this.elementWiseInput.get().booleanValue()) {
            RealParameter realParameter;
            int n3 = 0;
            for (StateNode iterator : this.upInput.get()) {
                if (n3 == 0) {
                    n3 = iterator.getDimension();
                }
                if (n3 > 0 && iterator.getDimension() != n3) {
                    throw new RuntimeException("elementWise=true but parameters of differing lengths!");
                }
                ++n;
            }
            for (StateNode stateNode : this.downInput.get()) {
                if (n3 == 0) {
                    n3 = stateNode.getDimension();
                }
                if (n3 > 0 && stateNode.getDimension() != n3) {
                    throw new RuntimeException("elementWise=true but parameters of differing lengths!");
                }
                ++n2;
            }
            int n4 = Randomizer.nextInt(n3);
            for (StateNode stateNode : this.upInput.get()) {
                if (stateNode instanceof RealParameter) {
                    realParameter = (RealParameter)stateNode;
                    realParameter.setValue((Double)realParameter.getValue(n4) * d);
                }
                if (!this.outsideBounds(stateNode)) continue;
                return Double.NEGATIVE_INFINITY;
            }
            for (StateNode stateNode : this.downInput.get()) {
                if (stateNode instanceof RealParameter) {
                    realParameter = (RealParameter)stateNode;
                    realParameter.setValue((Double)realParameter.getValue(n4) / d);
                }
                if (!this.outsideBounds(stateNode)) continue;
                return Double.NEGATIVE_INFINITY;
            }
        } else {
            try {
                for (StateNode stateNode : this.upInput.get()) {
                    stateNode = stateNode.getCurrentEditable(this);
                    n += stateNode.scale(d);
                }
                for (StateNode stateNode : this.upInput.get()) {
                    if (!this.outsideBounds(stateNode)) continue;
                    return Double.NEGATIVE_INFINITY;
                }
                for (StateNode stateNode : this.downInput.get()) {
                    stateNode = stateNode.getCurrentEditable(this);
                    n2 += stateNode.scale(1.0 / d);
                }
                for (StateNode stateNode : this.downInput.get()) {
                    if (!this.outsideBounds(stateNode)) continue;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            catch (Exception exception) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return (double)(n - n2 - 2) * Math.log(d);
    }

    private boolean outsideBounds(StateNode stateNode) {
        if (stateNode instanceof Parameter) {
            Parameter parameter = (Parameter)((Object)stateNode);
            Double d = (Double)parameter.getLower();
            Double d2 = (Double)parameter.getUpper();
            Double d3 = (Double)parameter.getValue();
            if (d3 < d || d3 > d2) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void optimize(double d) {
        if (this.optimiseInput.get().booleanValue()) {
            double d2 = this.calcDelta(d);
            this.setCoercableParameterValue(1.0 / (Math.exp(d2 += Math.log(1.0 / this.scaleFactor - 1.0)) + 1.0));
        }
    }

    @Override
    public double getCoercableParameterValue() {
        return this.scaleFactor;
    }

    @Override
    public void setCoercableParameterValue(double d) {
        this.scaleFactor = Math.max(Math.min(d, this.upper), this.lower);
    }

    @Override
    public String getPerformanceSuggestion() {
        double d = (double)this.m_nNrAccepted / ((double)(this.m_nNrAccepted + this.m_nNrRejected) + 0.0);
        double d2 = this.getTargetAcceptanceProbability();
        double d3 = d / d2;
        if (d3 > 2.0) {
            d3 = 2.0;
        }
        if (d3 < 0.5) {
            d3 = 0.5;
        }
        double d4 = Math.pow(this.scaleFactor, d3);
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        if (d < 0.1) {
            return "Try setting scaleFactor to about " + decimalFormat.format(d4);
        }
        if (d > 0.4) {
            return "Try setting scaleFactor to about " + decimalFormat.format(d4);
        }
        return "";
    }
}

