/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree;

import beast.evolution.alignment.TaxonSet;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.util.FrequencySet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class CladeSet
extends FrequencySet<BitSet> {
    private TaxonSet taxonSet = null;
    private final Map<BitSet, Double> totalNodeHeight = new HashMap<BitSet, Double>();
    private int totalTrees = 0;

    public CladeSet() {
    }

    public CladeSet(Tree tree) {
        this(tree, tree.getTaxonset());
    }

    public CladeSet(Tree tree, TaxonSet taxonSet) {
        this.taxonSet = taxonSet;
        this.add(tree);
    }

    public int getCladeCount() {
        return this.size();
    }

    public String getClade(int n) {
        BitSet bitSet = (BitSet)this.get(n);
        StringBuffer stringBuffer = new StringBuffer("{");
        boolean bl = true;
        for (String string : this.getTaxaSet(bitSet)) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append(string);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private SortedSet<String> getTaxaSet(BitSet bitSet) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            treeSet.add(this.taxonSet.asStringList().get(i));
        }
        return treeSet;
    }

    int getCladeFrequency(int n) {
        return this.getFrequency(n);
    }

    @Override
    public void add(Tree tree) {
        if (this.taxonSet == null) {
            this.taxonSet = tree.getTaxonset();
        }
        ++this.totalTrees;
        this.addClades(tree.getRoot(), null);
    }

    private void addClades(Node node, BitSet bitSet) {
        if (node.isLeaf()) {
            if (this.taxonSet != null) {
                int n = this.taxonSet.getTaxonIndex(node.getID());
                bitSet.set(n);
            } else {
                bitSet.set(node.getNr());
            }
        } else {
            BitSet bitSet2 = new BitSet();
            for (Node node2 : node.getChildren()) {
                this.addClades(node2, bitSet2);
            }
            this.add(bitSet2, 1);
            this.addNodeHeight(bitSet2, node.getHeight());
            if (bitSet != null) {
                bitSet.or(bitSet2);
            }
        }
    }

    public double getMeanNodeHeight(int n) {
        BitSet bitSet = (BitSet)this.get(n);
        return this.getTotalNodeHeight(bitSet) / (double)this.getFrequency(n);
    }

    private double getTotalNodeHeight(BitSet bitSet) {
        Double d = this.totalNodeHeight.get(bitSet);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    private void addNodeHeight(BitSet bitSet, double d) {
        this.totalNodeHeight.put(bitSet, this.getTotalNodeHeight(bitSet) + d);
    }

    private BitSet annotate(Tree tree, Node node, String string) {
        BitSet bitSet = null;
        if (node.isLeaf()) {
            int n = this.taxonSet != null ? this.taxonSet.getTaxonIndex(node.getID()) : node.getNr();
            bitSet = new BitSet(tree.getLeafNodeCount());
            bitSet.set(n);
        } else {
            for (Node node2 : node.getChildren()) {
                BitSet bitSet2 = this.annotate(tree, node2, string);
                if (node2.isRoot()) {
                    bitSet = bitSet2;
                    continue;
                }
                bitSet.or(bitSet2);
            }
            int n = this.getFrequency(bitSet);
            if (n >= 0) {
                node.setMetaData(string, (double)n / (double)this.totalTrees);
            }
        }
        return bitSet;
    }

    public double annotate(Tree tree, String string) {
        this.annotate(tree, tree.getRoot(), string);
        double d = 0.0;
        for (Node node : tree.getInternalNodes()) {
            double d2 = (Double)node.getMetaData(string);
            d += Math.log(d2);
        }
        return d;
    }

    public boolean hasClade(int n, Tree tree) {
        BitSet bitSet = (BitSet)this.get(n);
        Node[] nodeArray = new Node[1];
        this.findClade(bitSet, tree.getRoot(), nodeArray);
        return nodeArray[0] != null;
    }

    private int findClade(BitSet bitSet, Node node, Node[] nodeArray) {
        if (node.isLeaf()) {
            int n;
            if (this.taxonSet != null ? bitSet.get(n = this.taxonSet.getTaxonIndex(node.getID())) : bitSet.get(node.getNr())) {
                return 1;
            }
            return -1;
        }
        int n = 0;
        for (Node node2 : node.getChildren()) {
            int n2 = this.findClade(bitSet, node2, nodeArray);
            if (n2 != -1 && n != -1) {
                n += n2;
                continue;
            }
            n = -1;
        }
        if (n == bitSet.cardinality()) {
            nodeArray[0] = node;
        }
        return n;
    }
}

