/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.math.distributions.ParametricDistribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ContinuousDistribution;

@Description(value="Laplace distribution.    f(x|\\mu,b) = \\frac{1}{2b} \\exp \\left( -\\frac{|x-\\mu|}{b} \\right)The probability density function of the Laplace distribution is also reminiscent of the normal distribution; however, whereas the normal distribution is expressed in terms of the squared difference from the mean ?, the Laplace density is expressed in terms of the absolute difference from the mean. Consequently the Laplace distribution has fatter tails than the normal distribution.")
public class LaplaceDistribution
extends ParametricDistribution {
    public final Input<RealParameter> muInput = new Input("mu", "location parameter, defaults to 0");
    public final Input<RealParameter> scaleInput = new Input("scale", "scale parameter, defaults to 1");
    double mu;
    double scale;
    double c;
    LaplaceImpl dist = new LaplaceImpl();

    @Override
    public void initAndValidate() {
        this.refresh();
    }

    void refresh() {
        this.mu = this.muInput.get() == null ? 0.0 : this.muInput.get().getValue();
        this.scale = this.scaleInput.get() == null || this.scaleInput.get().getValue() <= 0.0 ? 1.0 : this.scaleInput.get().getValue();
        this.c = 1.0 / (2.0 * this.scale);
    }

    @Override
    public ContinuousDistribution getDistribution() {
        this.refresh();
        return this.dist;
    }

    @Override
    public double getMean() {
        return this.mu;
    }

    class LaplaceImpl
    implements ContinuousDistribution {
        LaplaceImpl() {
        }

        @Override
        public double cumulativeProbability(double d) throws MathException {
            if (d == LaplaceDistribution.this.mu) {
                return 0.5;
            }
            return 0.5 * (1.0 + (d - LaplaceDistribution.this.mu) / Math.abs(d - LaplaceDistribution.this.mu) * (1.0 - Math.exp(-Math.abs(d - LaplaceDistribution.this.mu) / LaplaceDistribution.this.scale)));
        }

        @Override
        public double cumulativeProbability(double d, double d2) throws MathException {
            return this.cumulativeProbability(d2) - this.cumulativeProbability(d);
        }

        @Override
        public double inverseCumulativeProbability(double d) throws MathException {
            return LaplaceDistribution.this.mu - LaplaceDistribution.this.scale * Math.signum(d - 0.5) * Math.log(1.0 - 2.0 * Math.abs(d - 0.5));
        }

        @Override
        public double density(double d) {
            return LaplaceDistribution.this.c * Math.exp(-Math.abs(d - LaplaceDistribution.this.mu) / LaplaceDistribution.this.scale);
        }

        @Override
        public double logDensity(double d) {
            return Math.log(LaplaceDistribution.this.c) - Math.abs(d - LaplaceDistribution.this.mu) / LaplaceDistribution.this.scale;
        }
    }
}

