/*
 * Decompiled with CFR 0.152.
 */
package beast.math.statistic;

import beast.util.HeapSort;

public class DiscreteStatistics {
    public static double mean(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (double d2 : dArray) {
            if (Double.isNaN(d2)) {
                --n;
                continue;
            }
            d += d2;
        }
        return d / (double)n;
    }

    public static double median(double[] dArray, int[] nArray) {
        int n = dArray.length / 2;
        if (dArray.length % 2 == 1) {
            return dArray[nArray[n]];
        }
        return (dArray[nArray[n - 1]] + dArray[nArray[n]]) / 2.0;
    }

    public static double meanSquaredError(double[] dArray, double d) {
        if (dArray == null || dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d2 = 0.0;
        for (double d3 : dArray) {
            d2 += (d3 - d) * (d3 - d);
        }
        return d2 /= (double)dArray.length;
    }

    public static double median(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        int[] nArray = new int[dArray.length];
        HeapSort.sort(dArray, nArray);
        return DiscreteStatistics.median(dArray, nArray);
    }

    public static double variance(double[] dArray, double d) {
        double d2 = 0.0;
        int n = dArray.length;
        for (double d3 : dArray) {
            if (Double.isNaN(d3)) {
                --n;
                continue;
            }
            double d4 = d3 - d;
            d2 += d4 * d4;
        }
        n = n < 2 ? 1 : --n;
        return d2 / (double)n;
    }

    public static double covariance(double[] dArray, double[] dArray2) {
        return DiscreteStatistics.covariance(dArray, dArray2, DiscreteStatistics.mean(dArray), DiscreteStatistics.mean(dArray2), DiscreteStatistics.stdev(dArray), DiscreteStatistics.stdev(dArray2));
    }

    public static double covariance(double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("x and y arrays must be same length!");
        }
        int n = dArray.length;
        double d5 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i]) || Double.isNaN(dArray2[i])) {
                --n;
                continue;
            }
            d5 += (dArray[i] - d) * (dArray2[i] - d2);
        }
        d5 /= (double)n;
        return d5 /= d3 * d4;
    }

    public static double skewness(double[] dArray) {
        double d = DiscreteStatistics.mean(dArray);
        double d2 = DiscreteStatistics.stdev(dArray);
        double d3 = 0.0;
        double d4 = dArray.length;
        for (double d5 : dArray) {
            double d6 = d5 - d;
            d3 += (d6 /= d2) * d6 * d6;
        }
        return d3 *= d4 / ((d4 - 1.0) * (d4 - 2.0));
    }

    public static double stdev(double[] dArray) {
        return Math.sqrt(DiscreteStatistics.variance(dArray));
    }

    public static double variance(double[] dArray) {
        double d = DiscreteStatistics.mean(dArray);
        return DiscreteStatistics.variance(dArray, d);
    }

    public static double varianceSampleMean(double[] dArray, double d) {
        return DiscreteStatistics.variance(dArray, d) / (double)dArray.length;
    }

    public static double varianceSampleMean(double[] dArray) {
        return DiscreteStatistics.variance(dArray) / (double)dArray.length;
    }

    public static double quantile(double d, double[] dArray, int[] nArray) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Quantile out of range");
        }
        if (d == 0.0) {
            return dArray[nArray[0]] - 1.0;
        }
        return dArray[nArray[(int)Math.ceil(d * (double)nArray.length) - 1]];
    }

    public static double quantile(double d, double[] dArray) {
        int[] nArray = new int[dArray.length];
        HeapSort.sort(dArray, nArray);
        return DiscreteStatistics.quantile(d, dArray, nArray);
    }

    public static double quantile(double d, double[] dArray, int n) {
        int[] nArray = new int[n];
        HeapSort.sort(dArray, nArray);
        return DiscreteStatistics.quantile(d, dArray, nArray);
    }

    public static double[] HPDInterval(double d, double[] dArray, int[] nArray) {
        double d2 = Double.MAX_VALUE;
        int n = 0;
        int n2 = (int)Math.round(d * (double)dArray.length);
        for (int i = 0; i <= dArray.length - n2; ++i) {
            double d3 = dArray[nArray[i + n2 - 1]];
            double d4 = dArray[nArray[i]];
            double d5 = Math.abs(d3 - d4);
            if (!(d5 < d2)) continue;
            d2 = d5;
            n = i;
        }
        return new double[]{dArray[nArray[n]], dArray[nArray[n + n2 - 1]]};
    }

    public static double cdf(double d, double[] dArray, int[] nArray) {
        int n;
        for (n = 0; n < dArray.length && !(dArray[nArray[n]] > d); ++n) {
        }
        return (double)n / (double)dArray.length;
    }

    public static double cdf(double d, double[] dArray) {
        int[] nArray = new int[dArray.length];
        HeapSort.sort(dArray, nArray);
        return DiscreteStatistics.cdf(d, dArray, nArray);
    }

    public static double max(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static double min(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static double geometricMean(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += Math.log(dArray[i]);
        }
        return Math.exp(d / (double)n);
    }
}

