/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.util.CredibleSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FrequencySet<T> {
    public static final double DEFAULT_CRED_SET = 0.95;
    private List<T> sortedList = new ArrayList<T>();
    private Map<T, Integer> frequencyMap = new HashMap<T, Integer>();
    private boolean sorted = false;
    private double credSetProbability = 0.0;
    private Comparator<T> frequencyComparator = new Comparator<T>(){

        @Override
        public int compare(T t, T t2) {
            return (Integer)FrequencySet.this.frequencyMap.get(t2) - (Integer)FrequencySet.this.frequencyMap.get(t);
        }
    };

    public FrequencySet() {
        this.setCredSetProbability(0.95);
    }

    public FrequencySet(double d) {
        this.setCredSetProbability(d);
    }

    public int size() {
        return this.frequencyMap.size();
    }

    public T get(int n) {
        if (!this.sorted) {
            this.sortByFrequency();
        }
        return this.sortedList.get(n);
    }

    public Integer getFrequency(T t) {
        if (!this.sorted) {
            this.sortByFrequency();
        }
        return this.frequencyMap.get(t);
    }

    public int getFrequency(int n) {
        if (!this.sorted) {
            this.sortByFrequency();
        }
        return this.getFrequency(this.sortedList.get(n));
    }

    public int getSumFrequency() {
        if (!this.sorted) {
            this.sortByFrequency();
        }
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            n += this.getFrequency(i);
        }
        return n;
    }

    public void add(T t) {
        this.add(t, 1);
    }

    public void add(T t, int n) {
        Integer n2 = this.frequencyMap.get(t);
        if (n2 != null) {
            n2 = n2 + n;
            this.frequencyMap.put(t, n2);
        } else {
            this.frequencyMap.put(t, n);
            this.sortedList.add(t);
            this.sorted = false;
        }
    }

    public boolean equals(Object object) {
        return object instanceof FrequencySet && this.sortedList.equals(((FrequencySet)object).sortedList);
    }

    public Map<T, Integer> getFrequencyMap() {
        return this.frequencyMap;
    }

    public CredibleSet<T> getCredibleSet(T t) {
        CredibleSet<T> credibleSet = new CredibleSet<T>(this.getCredSetProbability());
        credibleSet.setCredibleSetList(t, this);
        return credibleSet;
    }

    public CredibleSet<T> getCredibleSet() {
        return this.getCredibleSet(null);
    }

    public double getCredSetProbability() {
        if (this.credSetProbability == 0.0) {
            this.setCredSetProbability(0.95);
        }
        return this.credSetProbability;
    }

    public void setCredSetProbability(double d) {
        this.credSetProbability = d;
    }

    private void sortByFrequency() {
        this.sortedList.clear();
        this.sortedList.addAll(this.frequencyMap.keySet());
        Collections.sort(this.sortedList, this.frequencyComparator);
        this.sorted = true;
    }
}

