/*
 * Decompiled with CFR 0.152.
 */
package jam.mac;

import jam.framework.Application;
import java.lang.reflect.Method;

public class Utils {
    protected static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    protected static String MAC_OS_X_VERSION = MAC_OS_X ? System.getProperty("os.version") : null;

    public static boolean isMacOSX() {
        return MAC_OS_X;
    }

    public static String getMacOSXVersion() {
        return MAC_OS_X_VERSION;
    }

    public static int getMacOSXMajorVersionNumber() {
        String[] bits = Utils.getMacOSXVersion().split("\\.");
        if (bits.length >= 2 && bits[0].equals("10")) {
            return Integer.parseInt(bits[1]);
        }
        return -1;
    }

    public static void macOSXRegistration(Application application) {
        if (MAC_OS_X) {
            Class<?> osxAdapter = null;
            try {
                osxAdapter = Class.forName("jam.maconly.NewOSXAdapter");
            }
            catch (Exception e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.");
            }
            try {
                Class[] defArgs;
                Method registerMethod;
                if (osxAdapter != null && (registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs = new Class[]{Application.class})) != null) {
                    Object[] args = new Object[]{application};
                    registerMethod.invoke(osxAdapter, args);
                }
            }
            catch (Exception e) {
                System.err.println("Exception while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }
}

