/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.BinomialDistribution;
import org.apache.commons.math.distribution.SaddlePointExpansion;
import org.apache.commons.math.special.Beta;

public class BinomialDistributionImpl
extends AbstractIntegerDistribution
implements BinomialDistribution,
Serializable {
    private static final long serialVersionUID = 6751309484392813623L;
    private int numberOfTrials;
    private double probabilityOfSuccess;

    public BinomialDistributionImpl(int n, double d) {
        this.setNumberOfTrialsInternal(n);
        this.setProbabilityOfSuccessInternal(d);
    }

    @Override
    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    @Override
    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    @Deprecated
    public void setNumberOfTrials(int n) {
        this.setNumberOfTrialsInternal(n);
    }

    private void setNumberOfTrialsInternal(int n) {
        if (n < 0) {
            throw MathRuntimeException.createIllegalArgumentException("number of trials must be non-negative ({0})", n);
        }
        this.numberOfTrials = n;
    }

    @Override
    @Deprecated
    public void setProbabilityOfSuccess(double d) {
        this.setProbabilityOfSuccessInternal(d);
    }

    private void setProbabilityOfSuccessInternal(double d) {
        if (d < 0.0 || d > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException("{0} out of [{1}, {2}] range", d, 0.0, 1.0);
        }
        this.probabilityOfSuccess = d;
    }

    @Override
    protected int getDomainLowerBound(double d) {
        return -1;
    }

    @Override
    protected int getDomainUpperBound(double d) {
        return this.numberOfTrials;
    }

    @Override
    public double cumulativeProbability(int n) throws MathException {
        double d = n < 0 ? 0.0 : (n >= this.numberOfTrials ? 1.0 : 1.0 - Beta.regularizedBeta(this.getProbabilityOfSuccess(), (double)n + 1.0, this.numberOfTrials - n));
        return d;
    }

    @Override
    public double probability(int n) {
        double d = n < 0 || n > this.numberOfTrials ? 0.0 : Math.exp(SaddlePointExpansion.logBinomialProbability(n, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess));
        return d;
    }

    @Override
    public int inverseCumulativeProbability(double d) throws MathException {
        if (d == 0.0) {
            return -1;
        }
        if (d == 1.0) {
            return Integer.MAX_VALUE;
        }
        return super.inverseCumulativeProbability(d);
    }
}

