/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "notification_options.h"

NotificationOptions::NotificationOptions (bool init /* = true */) :
    mOptions (NotificationOptions::OptionNum),
    mNotify (NotificationOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
NotificationOptions::initOptions ()
{

    // timeout
    mOptions[NotificationOptions::Timeout].setName ("timeout", CompOption::TypeInt);
    mOptions[NotificationOptions::Timeout].rest ().set (-1, 30);
    mOptions[NotificationOptions::Timeout].value().set((int) -1);

    // max_log_level
    mOptions[NotificationOptions::MaxLogLevel].setName ("max_log_level", CompOption::TypeInt);
    mOptions[NotificationOptions::MaxLogLevel].rest ().set (MINSHORT, MAXSHORT);
    mOptions[NotificationOptions::MaxLogLevel].value().set((int) 1);

}

NotificationOptions::~NotificationOptions ()
{
}


CompOption::Vector &
NotificationOptions::getOptions ()
{
    return mOptions;
}

bool
NotificationOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case NotificationOptions::Timeout:
            if (o->set (value))
            {
                if (!mNotify[NotificationOptions::Timeout].empty ())
                    mNotify[NotificationOptions::Timeout] (o, NotificationOptions::Timeout);
                return true;
            }
            break;
        case NotificationOptions::MaxLogLevel:
            if (o->set (value))
            {
                if (!mNotify[NotificationOptions::MaxLogLevel].empty ())
                    mNotify[NotificationOptions::MaxLogLevel] (o, NotificationOptions::MaxLogLevel);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

