/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "wall_options.h"

WallOptions::WallOptions (bool init /* = true */) :
    mOptions (WallOptions::OptionNum),
    mNotify (WallOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
WallOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned int edge;
    unsigned short color[4];

    // show_switcher
    mOptions[WallOptions::ShowSwitcher].setName ("show_switcher", CompOption::TypeBool);
    mOptions[WallOptions::ShowSwitcher].value().set(true);

    // miniscreen
    mOptions[WallOptions::Miniscreen].setName ("miniscreen", CompOption::TypeBool);
    mOptions[WallOptions::Miniscreen].value().set(false);

    // preview_timeout
    mOptions[WallOptions::PreviewTimeout].setName ("preview_timeout", CompOption::TypeFloat);
    mOptions[WallOptions::PreviewTimeout].rest ().set (0.0, 2.0, 0.05);
    mOptions[WallOptions::PreviewTimeout].value().set((float) 0.4);

    // preview_scale
    mOptions[WallOptions::PreviewScale].setName ("preview_scale", CompOption::TypeInt);
    mOptions[WallOptions::PreviewScale].rest ().set (0, 400);
    mOptions[WallOptions::PreviewScale].value().set((int) 100);

    // edge_radius
    mOptions[WallOptions::EdgeRadius].setName ("edge_radius", CompOption::TypeInt);
    mOptions[WallOptions::EdgeRadius].rest ().set (0, 20);
    mOptions[WallOptions::EdgeRadius].value().set((int) 5);

    // border_width
    mOptions[WallOptions::BorderWidth].setName ("border_width", CompOption::TypeInt);
    mOptions[WallOptions::BorderWidth].rest ().set (0, 30);
    mOptions[WallOptions::BorderWidth].value().set((int) 10);

    // outline_color
    mOptions[WallOptions::OutlineColor].setName ("outline_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x3333));
    color[1] = MAX (0, MIN (0xffff, 0x3333));
    color[2] = MAX (0, MIN (0xffff, 0x3333));
    color[3] = MAX (0, MIN (0xffff, 0xd998));
    mOptions[WallOptions::OutlineColor].value().set(color);

    // background_gradient_base_color
    mOptions[WallOptions::BackgroundGradientBaseColor].setName ("background_gradient_base_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xcccc));
    color[1] = MAX (0, MIN (0xffff, 0xcccc));
    color[2] = MAX (0, MIN (0xffff, 0xe665));
    color[3] = MAX (0, MIN (0xffff, 0xd998));
    mOptions[WallOptions::BackgroundGradientBaseColor].value().set(color);

    // background_gradient_highlight_color
    mOptions[WallOptions::BackgroundGradientHighlightColor].setName ("background_gradient_highlight_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xf332));
    color[1] = MAX (0, MIN (0xffff, 0xf332));
    color[2] = MAX (0, MIN (0xffff, 0xffff));
    color[3] = MAX (0, MIN (0xffff, 0xd998));
    mOptions[WallOptions::BackgroundGradientHighlightColor].value().set(color);

    // background_gradient_shadow_color
    mOptions[WallOptions::BackgroundGradientShadowColor].setName ("background_gradient_shadow_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xf332));
    color[1] = MAX (0, MIN (0xffff, 0xf332));
    color[2] = MAX (0, MIN (0xffff, 0xffff));
    color[3] = MAX (0, MIN (0xffff, 0xd998));
    mOptions[WallOptions::BackgroundGradientShadowColor].value().set(color);

    // thumb_gradient_base_color
    mOptions[WallOptions::ThumbGradientBaseColor].setName ("thumb_gradient_base_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x3333));
    color[1] = MAX (0, MIN (0xffff, 0x3333));
    color[2] = MAX (0, MIN (0xffff, 0x3333));
    color[3] = MAX (0, MIN (0xffff, 0x5999));
    mOptions[WallOptions::ThumbGradientBaseColor].value().set(color);

    // thumb_gradient_highlight_color
    mOptions[WallOptions::ThumbGradientHighlightColor].setName ("thumb_gradient_highlight_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x3fff));
    color[1] = MAX (0, MIN (0xffff, 0x3fff));
    color[2] = MAX (0, MIN (0xffff, 0x3fff));
    color[3] = MAX (0, MIN (0xffff, 0x3fff));
    mOptions[WallOptions::ThumbGradientHighlightColor].value().set(color);

    // thumb_highlight_gradient_base_color
    mOptions[WallOptions::ThumbHighlightGradientBaseColor].setName ("thumb_highlight_gradient_base_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0xffff));
    color[2] = MAX (0, MIN (0xffff, 0xffff));
    color[3] = MAX (0, MIN (0xffff, 0xf332));
    mOptions[WallOptions::ThumbHighlightGradientBaseColor].value().set(color);

    // thumb_highlight_gradient_shadow_color
    mOptions[WallOptions::ThumbHighlightGradientShadowColor].setName ("thumb_highlight_gradient_shadow_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xdfff));
    color[1] = MAX (0, MIN (0xffff, 0xdfff));
    color[2] = MAX (0, MIN (0xffff, 0xdfff));
    color[3] = MAX (0, MIN (0xffff, 0xa665));
    mOptions[WallOptions::ThumbHighlightGradientShadowColor].value().set(color);

    // arrow_base_color
    mOptions[WallOptions::ArrowBaseColor].setName ("arrow_base_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xe665));
    color[1] = MAX (0, MIN (0xffff, 0xe665));
    color[2] = MAX (0, MIN (0xffff, 0xe665));
    color[3] = MAX (0, MIN (0xffff, 0xd998));
    mOptions[WallOptions::ArrowBaseColor].value().set(color);

    // arrow_shadow_color
    mOptions[WallOptions::ArrowShadowColor].setName ("arrow_shadow_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xdc28));
    color[1] = MAX (0, MIN (0xffff, 0xdc28));
    color[2] = MAX (0, MIN (0xffff, 0xdc28));
    color[3] = MAX (0, MIN (0xffff, 0xd998));
    mOptions[WallOptions::ArrowShadowColor].value().set(color);

    // allow_wraparound
    mOptions[WallOptions::AllowWraparound].setName ("allow_wraparound", CompOption::TypeBool);
    mOptions[WallOptions::AllowWraparound].value().set(false);

    // slide_duration
    mOptions[WallOptions::SlideDuration].setName ("slide_duration", CompOption::TypeFloat);
    mOptions[WallOptions::SlideDuration].rest ().set (0.0, 5.0, 0.05);
    mOptions[WallOptions::SlideDuration].value().set((float) 0.3);

    // no_slide_match
    mOptions[WallOptions::NoSlideMatch].setName ("no_slide_match", CompOption::TypeMatch);
    mOptions[WallOptions::NoSlideMatch].value().set(CompMatch ("type=Dock | type=Desktop | state=Sticky"));
    mOptions[WallOptions::NoSlideMatch].value().match ().update ();

    // auto_switch_vp_and_window
    mOptions[WallOptions::AutoSwitchVpAndWindow].setName ("auto_switch_vp_and_window", CompOption::TypeBool);
    mOptions[WallOptions::AutoSwitchVpAndWindow].value().set(true);

    // left_key
    mOptions[WallOptions::LeftKey].setName ("left_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>Left");
    mOptions[WallOptions::LeftKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::LeftKey].value ().action ());

    // left_button
    mOptions[WallOptions::LeftButton].setName ("left_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[WallOptions::LeftButton].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::LeftButton].value ().action ());

    // right_key
    mOptions[WallOptions::RightKey].setName ("right_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>Right");
    mOptions[WallOptions::RightKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::RightKey].value ().action ());

    // right_button
    mOptions[WallOptions::RightButton].setName ("right_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[WallOptions::RightButton].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::RightButton].value ().action ());

    // up_key
    mOptions[WallOptions::UpKey].setName ("up_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>Up");
    mOptions[WallOptions::UpKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::UpKey].value ().action ());

    // up_button
    mOptions[WallOptions::UpButton].setName ("up_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[WallOptions::UpButton].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::UpButton].value ().action ());

    // down_key
    mOptions[WallOptions::DownKey].setName ("down_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>Down");
    mOptions[WallOptions::DownKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::DownKey].value ().action ());

    // down_button
    mOptions[WallOptions::DownButton].setName ("down_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[WallOptions::DownButton].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::DownButton].value ().action ());

    // next_key
    mOptions[WallOptions::NextKey].setName ("next_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[WallOptions::NextKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::NextKey].value ().action ());

    // next_button
    mOptions[WallOptions::NextButton].setName ("next_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[WallOptions::NextButton].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::NextButton].value ().action ());

    // prev_key
    mOptions[WallOptions::PrevKey].setName ("prev_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[WallOptions::PrevKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::PrevKey].value ().action ());

    // prev_button
    mOptions[WallOptions::PrevButton].setName ("prev_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[WallOptions::PrevButton].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::PrevButton].value ().action ());

    // left_window_key
    mOptions[WallOptions::LeftWindowKey].setName ("left_window_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt><Shift>Left");
    mOptions[WallOptions::LeftWindowKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::LeftWindowKey].value ().action ());

    // right_window_key
    mOptions[WallOptions::RightWindowKey].setName ("right_window_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt><Shift>Right");
    mOptions[WallOptions::RightWindowKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::RightWindowKey].value ().action ());

    // up_window_key
    mOptions[WallOptions::UpWindowKey].setName ("up_window_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt><Shift>Up");
    mOptions[WallOptions::UpWindowKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::UpWindowKey].value ().action ());

    // down_window_key
    mOptions[WallOptions::DownWindowKey].setName ("down_window_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt><Shift>Down");
    mOptions[WallOptions::DownWindowKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WallOptions::DownWindowKey].value ().action ());

    // flip_left_edge
    mOptions[WallOptions::FlipLeftEdge].setName ("flip_left_edge", CompOption::TypeEdge);
    state = 0;
    state |= CompAction::StateNoEdgeDelay;
    state |= CompAction::StateInitEdgeDnd;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    edge |= 1;
    action.setEdgeMask (edge);
    mOptions[WallOptions::FlipLeftEdge].value().set (action);

    // flip_right_edge
    mOptions[WallOptions::FlipRightEdge].setName ("flip_right_edge", CompOption::TypeEdge);
    state = 0;
    state |= CompAction::StateNoEdgeDelay;
    state |= CompAction::StateInitEdgeDnd;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    edge |= (1 << 1);
    action.setEdgeMask (edge);
    mOptions[WallOptions::FlipRightEdge].value().set (action);

    // flip_up_edge
    mOptions[WallOptions::FlipUpEdge].setName ("flip_up_edge", CompOption::TypeEdge);
    state = 0;
    state |= CompAction::StateNoEdgeDelay;
    state |= CompAction::StateInitEdgeDnd;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    edge |= (1 << 2);
    action.setEdgeMask (edge);
    mOptions[WallOptions::FlipUpEdge].value().set (action);

    // flip_down_edge
    mOptions[WallOptions::FlipDownEdge].setName ("flip_down_edge", CompOption::TypeEdge);
    state = 0;
    state |= CompAction::StateNoEdgeDelay;
    state |= CompAction::StateInitEdgeDnd;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    edge |= (1 << 3);
    action.setEdgeMask (edge);
    mOptions[WallOptions::FlipDownEdge].value().set (action);

    // mmmode
    mOptions[WallOptions::Mmmode].setName ("mmmode", CompOption::TypeInt);
    mOptions[WallOptions::Mmmode].rest ().set (0, 1);
    mOptions[WallOptions::Mmmode].value().set((int) 0);

    // edgeflip_pointer
    mOptions[WallOptions::EdgeflipPointer].setName ("edgeflip_pointer", CompOption::TypeBool);
    mOptions[WallOptions::EdgeflipPointer].value().set(false);

    // edgeflip_move
    mOptions[WallOptions::EdgeflipMove].setName ("edgeflip_move", CompOption::TypeBool);
    mOptions[WallOptions::EdgeflipMove].value().set(true);

    // edgeflip_dnd
    mOptions[WallOptions::EdgeflipDnd].setName ("edgeflip_dnd", CompOption::TypeBool);
    mOptions[WallOptions::EdgeflipDnd].value().set(false);

}

WallOptions::~WallOptions ()
{
}


CompOption::Vector &
WallOptions::getOptions ()
{
    return mOptions;
}

bool
WallOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case WallOptions::ShowSwitcher:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::ShowSwitcher].empty ())
                    mNotify[WallOptions::ShowSwitcher] (o, WallOptions::ShowSwitcher);
                return true;
            }
            break;
        case WallOptions::Miniscreen:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::Miniscreen].empty ())
                    mNotify[WallOptions::Miniscreen] (o, WallOptions::Miniscreen);
                return true;
            }
            break;
        case WallOptions::PreviewTimeout:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::PreviewTimeout].empty ())
                    mNotify[WallOptions::PreviewTimeout] (o, WallOptions::PreviewTimeout);
                return true;
            }
            break;
        case WallOptions::PreviewScale:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::PreviewScale].empty ())
                    mNotify[WallOptions::PreviewScale] (o, WallOptions::PreviewScale);
                return true;
            }
            break;
        case WallOptions::EdgeRadius:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::EdgeRadius].empty ())
                    mNotify[WallOptions::EdgeRadius] (o, WallOptions::EdgeRadius);
                return true;
            }
            break;
        case WallOptions::BorderWidth:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::BorderWidth].empty ())
                    mNotify[WallOptions::BorderWidth] (o, WallOptions::BorderWidth);
                return true;
            }
            break;
        case WallOptions::OutlineColor:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::OutlineColor].empty ())
                    mNotify[WallOptions::OutlineColor] (o, WallOptions::OutlineColor);
                return true;
            }
            break;
        case WallOptions::BackgroundGradientBaseColor:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::BackgroundGradientBaseColor].empty ())
                    mNotify[WallOptions::BackgroundGradientBaseColor] (o, WallOptions::BackgroundGradientBaseColor);
                return true;
            }
            break;
        case WallOptions::BackgroundGradientHighlightColor:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::BackgroundGradientHighlightColor].empty ())
                    mNotify[WallOptions::BackgroundGradientHighlightColor] (o, WallOptions::BackgroundGradientHighlightColor);
                return true;
            }
            break;
        case WallOptions::BackgroundGradientShadowColor:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::BackgroundGradientShadowColor].empty ())
                    mNotify[WallOptions::BackgroundGradientShadowColor] (o, WallOptions::BackgroundGradientShadowColor);
                return true;
            }
            break;
        case WallOptions::ThumbGradientBaseColor:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::ThumbGradientBaseColor].empty ())
                    mNotify[WallOptions::ThumbGradientBaseColor] (o, WallOptions::ThumbGradientBaseColor);
                return true;
            }
            break;
        case WallOptions::ThumbGradientHighlightColor:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::ThumbGradientHighlightColor].empty ())
                    mNotify[WallOptions::ThumbGradientHighlightColor] (o, WallOptions::ThumbGradientHighlightColor);
                return true;
            }
            break;
        case WallOptions::ThumbHighlightGradientBaseColor:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::ThumbHighlightGradientBaseColor].empty ())
                    mNotify[WallOptions::ThumbHighlightGradientBaseColor] (o, WallOptions::ThumbHighlightGradientBaseColor);
                return true;
            }
            break;
        case WallOptions::ThumbHighlightGradientShadowColor:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::ThumbHighlightGradientShadowColor].empty ())
                    mNotify[WallOptions::ThumbHighlightGradientShadowColor] (o, WallOptions::ThumbHighlightGradientShadowColor);
                return true;
            }
            break;
        case WallOptions::ArrowBaseColor:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::ArrowBaseColor].empty ())
                    mNotify[WallOptions::ArrowBaseColor] (o, WallOptions::ArrowBaseColor);
                return true;
            }
            break;
        case WallOptions::ArrowShadowColor:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::ArrowShadowColor].empty ())
                    mNotify[WallOptions::ArrowShadowColor] (o, WallOptions::ArrowShadowColor);
                return true;
            }
            break;
        case WallOptions::AllowWraparound:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::AllowWraparound].empty ())
                    mNotify[WallOptions::AllowWraparound] (o, WallOptions::AllowWraparound);
                return true;
            }
            break;
        case WallOptions::SlideDuration:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::SlideDuration].empty ())
                    mNotify[WallOptions::SlideDuration] (o, WallOptions::SlideDuration);
                return true;
            }
            break;
        case WallOptions::NoSlideMatch:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::NoSlideMatch].empty ())
                    mNotify[WallOptions::NoSlideMatch] (o, WallOptions::NoSlideMatch);
                return true;
            }
            break;
        case WallOptions::AutoSwitchVpAndWindow:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::AutoSwitchVpAndWindow].empty ())
                    mNotify[WallOptions::AutoSwitchVpAndWindow] (o, WallOptions::AutoSwitchVpAndWindow);
                return true;
            }
            break;
        case WallOptions::LeftKey:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::LeftKey].empty ())
                    mNotify[WallOptions::LeftKey] (o, WallOptions::LeftKey);
                return true;
            }
            break;
        case WallOptions::LeftButton:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::LeftButton].empty ())
                    mNotify[WallOptions::LeftButton] (o, WallOptions::LeftButton);
                return true;
            }
            break;
        case WallOptions::RightKey:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::RightKey].empty ())
                    mNotify[WallOptions::RightKey] (o, WallOptions::RightKey);
                return true;
            }
            break;
        case WallOptions::RightButton:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::RightButton].empty ())
                    mNotify[WallOptions::RightButton] (o, WallOptions::RightButton);
                return true;
            }
            break;
        case WallOptions::UpKey:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::UpKey].empty ())
                    mNotify[WallOptions::UpKey] (o, WallOptions::UpKey);
                return true;
            }
            break;
        case WallOptions::UpButton:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::UpButton].empty ())
                    mNotify[WallOptions::UpButton] (o, WallOptions::UpButton);
                return true;
            }
            break;
        case WallOptions::DownKey:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::DownKey].empty ())
                    mNotify[WallOptions::DownKey] (o, WallOptions::DownKey);
                return true;
            }
            break;
        case WallOptions::DownButton:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::DownButton].empty ())
                    mNotify[WallOptions::DownButton] (o, WallOptions::DownButton);
                return true;
            }
            break;
        case WallOptions::NextKey:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::NextKey].empty ())
                    mNotify[WallOptions::NextKey] (o, WallOptions::NextKey);
                return true;
            }
            break;
        case WallOptions::NextButton:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::NextButton].empty ())
                    mNotify[WallOptions::NextButton] (o, WallOptions::NextButton);
                return true;
            }
            break;
        case WallOptions::PrevKey:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::PrevKey].empty ())
                    mNotify[WallOptions::PrevKey] (o, WallOptions::PrevKey);
                return true;
            }
            break;
        case WallOptions::PrevButton:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::PrevButton].empty ())
                    mNotify[WallOptions::PrevButton] (o, WallOptions::PrevButton);
                return true;
            }
            break;
        case WallOptions::LeftWindowKey:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::LeftWindowKey].empty ())
                    mNotify[WallOptions::LeftWindowKey] (o, WallOptions::LeftWindowKey);
                return true;
            }
            break;
        case WallOptions::RightWindowKey:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::RightWindowKey].empty ())
                    mNotify[WallOptions::RightWindowKey] (o, WallOptions::RightWindowKey);
                return true;
            }
            break;
        case WallOptions::UpWindowKey:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::UpWindowKey].empty ())
                    mNotify[WallOptions::UpWindowKey] (o, WallOptions::UpWindowKey);
                return true;
            }
            break;
        case WallOptions::DownWindowKey:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::DownWindowKey].empty ())
                    mNotify[WallOptions::DownWindowKey] (o, WallOptions::DownWindowKey);
                return true;
            }
            break;
        case WallOptions::FlipLeftEdge:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::FlipLeftEdge].empty ())
                    mNotify[WallOptions::FlipLeftEdge] (o, WallOptions::FlipLeftEdge);
                return true;
            }
            break;
        case WallOptions::FlipRightEdge:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::FlipRightEdge].empty ())
                    mNotify[WallOptions::FlipRightEdge] (o, WallOptions::FlipRightEdge);
                return true;
            }
            break;
        case WallOptions::FlipUpEdge:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::FlipUpEdge].empty ())
                    mNotify[WallOptions::FlipUpEdge] (o, WallOptions::FlipUpEdge);
                return true;
            }
            break;
        case WallOptions::FlipDownEdge:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::FlipDownEdge].empty ())
                    mNotify[WallOptions::FlipDownEdge] (o, WallOptions::FlipDownEdge);
                return true;
            }
            break;
        case WallOptions::Mmmode:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::Mmmode].empty ())
                    mNotify[WallOptions::Mmmode] (o, WallOptions::Mmmode);
                return true;
            }
            break;
        case WallOptions::EdgeflipPointer:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::EdgeflipPointer].empty ())
                    mNotify[WallOptions::EdgeflipPointer] (o, WallOptions::EdgeflipPointer);
                return true;
            }
            break;
        case WallOptions::EdgeflipMove:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::EdgeflipMove].empty ())
                    mNotify[WallOptions::EdgeflipMove] (o, WallOptions::EdgeflipMove);
                return true;
            }
            break;
        case WallOptions::EdgeflipDnd:
            if (o->set (value))
            {
                if (!mNotify[WallOptions::EdgeflipDnd].empty ())
                    mNotify[WallOptions::EdgeflipDnd] (o, WallOptions::EdgeflipDnd);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

