/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "water_options.h"

WaterOptions::WaterOptions (bool init /* = true */) :
    mOptions (WaterOptions::OptionNum),
    mNotify (WaterOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
WaterOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // initiate_key
    mOptions[WaterOptions::InitiateKey].setName ("initiate_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Super>");
    mOptions[WaterOptions::InitiateKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WaterOptions::InitiateKey].value ().action ());

    // toggle_rain_key
    mOptions[WaterOptions::ToggleRainKey].setName ("toggle_rain_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Shift>F9");
    mOptions[WaterOptions::ToggleRainKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WaterOptions::ToggleRainKey].value ().action ());

    // toggle_wiper_key
    mOptions[WaterOptions::ToggleWiperKey].setName ("toggle_wiper_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Shift>F8");
    mOptions[WaterOptions::ToggleWiperKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WaterOptions::ToggleWiperKey].value ().action ());

    // offset_scale
    mOptions[WaterOptions::OffsetScale].setName ("offset_scale", CompOption::TypeFloat);
    mOptions[WaterOptions::OffsetScale].rest ().set (0, 1000, 0.1);
    mOptions[WaterOptions::OffsetScale].value().set((float) 10);

    // rain_delay
    mOptions[WaterOptions::RainDelay].setName ("rain_delay", CompOption::TypeInt);
    mOptions[WaterOptions::RainDelay].rest ().set (1, 3600000);
    mOptions[WaterOptions::RainDelay].value().set((int) 250);

    // light_vec_x
    mOptions[WaterOptions::LightVecX].setName ("light_vec_x", CompOption::TypeFloat);
    mOptions[WaterOptions::LightVecX].rest ().set (-1, 1, 0.1);
    mOptions[WaterOptions::LightVecX].value().set((float) -1.0);

    // light_vec_y
    mOptions[WaterOptions::LightVecY].setName ("light_vec_y", CompOption::TypeFloat);
    mOptions[WaterOptions::LightVecY].rest ().set (-1, 1, 0.1);
    mOptions[WaterOptions::LightVecY].value().set((float) 1.0);

    // light_vec_z
    mOptions[WaterOptions::LightVecZ].setName ("light_vec_z", CompOption::TypeFloat);
    mOptions[WaterOptions::LightVecZ].rest ().set (-1, 1, 0.1);
    mOptions[WaterOptions::LightVecZ].value().set((float) 0.0);

    // title_wave
    mOptions[WaterOptions::TitleWave].setName ("title_wave", CompOption::TypeBell);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitBell);
    mOptions[WaterOptions::TitleWave].value().set (action);
    if (screen) screen->addAction (&mOptions[WaterOptions::TitleWave].value ().action ());

    // point
    mOptions[WaterOptions::Point].setName ("point", CompOption::TypeAction);
    state = CompAction::StateAutoGrab;
    mOptions[WaterOptions::Point].value().set(CompAction ());
    mOptions[WaterOptions::Point].value().action ().setState (state);

    // line
    mOptions[WaterOptions::Line].setName ("line", CompOption::TypeAction);
    state = CompAction::StateAutoGrab;
    mOptions[WaterOptions::Line].value().set(CompAction ());
    mOptions[WaterOptions::Line].value().action ().setState (state);

}

WaterOptions::~WaterOptions ()
{
}


CompOption::Vector &
WaterOptions::getOptions ()
{
    return mOptions;
}

bool
WaterOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case WaterOptions::InitiateKey:
            if (o->set (value))
            {
                if (!mNotify[WaterOptions::InitiateKey].empty ())
                    mNotify[WaterOptions::InitiateKey] (o, WaterOptions::InitiateKey);
                return true;
            }
            break;
        case WaterOptions::ToggleRainKey:
            if (o->set (value))
            {
                if (!mNotify[WaterOptions::ToggleRainKey].empty ())
                    mNotify[WaterOptions::ToggleRainKey] (o, WaterOptions::ToggleRainKey);
                return true;
            }
            break;
        case WaterOptions::ToggleWiperKey:
            if (o->set (value))
            {
                if (!mNotify[WaterOptions::ToggleWiperKey].empty ())
                    mNotify[WaterOptions::ToggleWiperKey] (o, WaterOptions::ToggleWiperKey);
                return true;
            }
            break;
        case WaterOptions::OffsetScale:
            if (o->set (value))
            {
                if (!mNotify[WaterOptions::OffsetScale].empty ())
                    mNotify[WaterOptions::OffsetScale] (o, WaterOptions::OffsetScale);
                return true;
            }
            break;
        case WaterOptions::RainDelay:
            if (o->set (value))
            {
                if (!mNotify[WaterOptions::RainDelay].empty ())
                    mNotify[WaterOptions::RainDelay] (o, WaterOptions::RainDelay);
                return true;
            }
            break;
        case WaterOptions::LightVecX:
            if (o->set (value))
            {
                if (!mNotify[WaterOptions::LightVecX].empty ())
                    mNotify[WaterOptions::LightVecX] (o, WaterOptions::LightVecX);
                return true;
            }
            break;
        case WaterOptions::LightVecY:
            if (o->set (value))
            {
                if (!mNotify[WaterOptions::LightVecY].empty ())
                    mNotify[WaterOptions::LightVecY] (o, WaterOptions::LightVecY);
                return true;
            }
            break;
        case WaterOptions::LightVecZ:
            if (o->set (value))
            {
                if (!mNotify[WaterOptions::LightVecZ].empty ())
                    mNotify[WaterOptions::LightVecZ] (o, WaterOptions::LightVecZ);
                return true;
            }
            break;
        case WaterOptions::TitleWave:
            if (o->set (value))
            {
                if (!mNotify[WaterOptions::TitleWave].empty ())
                    mNotify[WaterOptions::TitleWave] (o, WaterOptions::TitleWave);
                return true;
            }
            break;
        case WaterOptions::Point:
            if (o->set (value))
            {
                if (!mNotify[WaterOptions::Point].empty ())
                    mNotify[WaterOptions::Point] (o, WaterOptions::Point);
                return true;
            }
            break;
        case WaterOptions::Line:
            if (o->set (value))
            {
                if (!mNotify[WaterOptions::Line].empty ())
                    mNotify[WaterOptions::Line] (o, WaterOptions::Line);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

